/*
 * Decompiled with CFR 0.152.
 */
package com.spket.buffer;

import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class ZipPath
implements IPath {
    public static final String JAR_DEVICE = "jar:";
    private IPath file;
    private IPath entry;

    public ZipPath(IPath iPath, IPath iPath2) {
        this.file = iPath;
        this.entry = iPath2;
    }

    public ZipPath(String string, String string2) {
        this.file = new Path(string);
        this.entry = Path.fromPortableString((String)string2);
    }

    public String getFileName() {
        return this.file.toOSString();
    }

    public String getEntryName() {
        return this.entry.toPortableString();
    }

    public IPath addFileExtension(String string) {
        IPath iPath = this.entry.addFileExtension(string);
        if (iPath == this.entry) {
            return this;
        }
        return new ZipPath(this.file, iPath);
    }

    public IPath addTrailingSeparator() {
        if (this.entry.hasTrailingSeparator() || this.entry.isRoot()) {
            return this;
        }
        return new ZipPath(this.file, this.entry.addTrailingSeparator());
    }

    public IPath append(IPath iPath) {
        if (iPath == null || iPath.segmentCount() == 0) {
            return this;
        }
        IPath iPath2 = this.entry.append(iPath);
        if (iPath2 == this.entry) {
            return this;
        }
        return new ZipPath(this.file, iPath2);
    }

    public IPath append(String string) {
        IPath iPath = this.entry.append(string);
        if (iPath == this.entry) {
            return this;
        }
        return new ZipPath(this.file, iPath);
    }

    public String getDevice() {
        return JAR_DEVICE;
    }

    public String getFileExtension() {
        return this.entry.getFileExtension();
    }

    public boolean hasTrailingSeparator() {
        return this.entry.hasTrailingSeparator();
    }

    public boolean isAbsolute() {
        return this.file.isAbsolute();
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean isPrefixOf(IPath iPath) {
        if (iPath instanceof ZipPath) {
            ZipPath zipPath = (ZipPath)iPath;
            if (this.file.equals(zipPath.file)) {
                return this.entry.isPrefixOf(zipPath.entry);
            }
        }
        return false;
    }

    public boolean isRoot() {
        return false;
    }

    public boolean isUNC() {
        return this.file.isUNC();
    }

    public boolean isValidPath(String string) {
        throw new UnsupportedOperationException("TODO");
    }

    public boolean isValidSegment(String string) {
        return this.file.isValidSegment(string);
    }

    public String lastSegment() {
        return this.entry.lastSegment();
    }

    public IPath makeAbsolute() {
        IPath iPath = this.file.makeAbsolute();
        if (iPath == this.file) {
            return this;
        }
        return new ZipPath(iPath, this.entry);
    }

    public IPath makeRelative() {
        throw new UnsupportedOperationException("TODO");
    }

    public IPath makeUNC(boolean bl) {
        throw new UnsupportedOperationException("TODO");
    }

    public int matchingFirstSegments(IPath iPath) {
        throw new UnsupportedOperationException("TODO");
    }

    public IPath removeFileExtension() {
        IPath iPath = this.entry.removeFileExtension();
        if (iPath == this.entry) {
            return this;
        }
        return new ZipPath(this.file, iPath);
    }

    public IPath removeFirstSegments(int n) {
        throw new UnsupportedOperationException("TODO");
    }

    public IPath removeLastSegments(int n) {
        throw new UnsupportedOperationException("TODO");
    }

    public IPath removeTrailingSeparator() {
        IPath iPath = this.entry.removeTrailingSeparator();
        if (iPath == this.entry) {
            return this;
        }
        return new ZipPath(this.file, iPath);
    }

    public String segment(int n) {
        return null;
    }

    public int segmentCount() {
        return 0;
    }

    public String[] segments() {
        return null;
    }

    public IPath setDevice(String string) {
        throw new UnsupportedOperationException("TODO");
    }

    public File toFile() {
        throw new UnsupportedOperationException("TODO");
    }

    public String toOSString() {
        return this.toPortableString();
    }

    public String toPortableString() {
        StringBuffer stringBuffer = new StringBuffer(JAR_DEVICE);
        stringBuffer.append(this.file.toPortableString());
        stringBuffer.append('!');
        if (!this.entry.isAbsolute()) {
            stringBuffer.append('/');
        }
        stringBuffer.append(this.entry.toPortableString());
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toPortableString();
    }

    public IPath uptoSegment(int n) {
        throw new UnsupportedOperationException("TODO");
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ZipPath) {
            ZipPath zipPath = (ZipPath)object;
            return this.file.equals(zipPath.file) && this.entry.equals(zipPath.entry);
        }
        return false;
    }

    public int hashCode() {
        return (this.file.hashCode() << 12) + this.entry.hashCode();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

