/*
 * Decompiled with CFR 0.152.
 */
package com.spket.buffer;

import com.spket.buffer.ZipPath;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;

public class ZipEntryStorage
extends PlatformObject
implements IStorage {
    private ZipPath fPath;

    public ZipEntryStorage(ZipPath zipPath) {
        this.fPath = zipPath;
    }

    public ZipEntryStorage(String string, String string2) {
        this.fPath = new ZipPath(string, string2);
    }

    public InputStream getContents() throws CoreException {
        try {
            ZipFile zipFile = new ZipFile(this.fPath.getFileName());
            ZipEntry zipEntry = zipFile.getEntry(this.fPath.getEntryName());
            if (zipEntry == null) {
                String string = "No entry '" + this.fPath.getEntryName() + "' in file '" + this.fPath.getFileName() + "'";
                throw new CoreException((IStatus)new Status(4, "com.spket.ui", 4, string, null));
            }
            return zipFile.getInputStream(zipEntry);
        }
        catch (IOException iOException) {
            throw new CoreException((IStatus)new Status(4, "com.spket.ui", 4, iOException.getLocalizedMessage(), null));
        }
    }

    public IPath getFullPath() {
        return this.fPath;
    }

    public String getName() {
        return this.fPath.lastSegment();
    }

    public boolean isReadOnly() {
        return true;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ZipEntryStorage) {
            return this.fPath.equals(((ZipEntryStorage)((Object)object)).fPath);
        }
        return false;
    }
}

