/*
 * Decompiled with CFR 0.152.
 */
package com.spket.widget;

import com.spket.widget.Colors;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class TransparentImage {
    private int fWidth;
    private int fHeight;
    private List rgbs = new ArrayList();
    private Image fImage;
    private Color fBackground;

    public static int rgb(Color color) {
        return (color.getRed() & 0xFF) << 16 | (color.getGreen() & 0xFF) << 8 | color.getBlue() & 0xFF;
    }

    public static int rgb(RGB rGB) {
        return (rGB.red & 0xFF) << 16 | (rGB.green & 0xFF) << 8 | rGB.blue & 0xFF;
    }

    public TransparentImage(int n, int n2) {
        this.fWidth = n;
        this.fHeight = n2;
    }

    public void dispose() {
        if (this.fImage != null) {
            this.fImage.dispose();
            this.fImage = null;
        }
        if (this.fBackground != null) {
            this.fBackground.dispose();
            this.fBackground = null;
        }
        if (this.rgbs != null) {
            this.rgbs.clear();
            this.rgbs = null;
        }
    }

    public void addColor(Color color) {
        if (color != null) {
            this.addColor(TransparentImage.rgb(color));
        }
    }

    public void addColor(RGB rGB) {
        if (rGB != null) {
            this.addColor(TransparentImage.rgb(rGB));
        }
    }

    public void addColor(int n) {
        Integer n2;
        if (n < 0) {
            return;
        }
        if (this.fImage != null) {
            SWT.error((int)5);
        }
        if (!this.rgbs.contains(n2 = new Integer(n))) {
            this.rgbs.add(n2);
        }
    }

    public void addColor(Colors.NamedColor namedColor) {
        if (namedColor == null) {
            return;
        }
        this.addColor(namedColor.getValue());
    }

    public GC createGC(Display display) {
        if (this.fImage == null) {
            this.fImage = new Image((Device)display, this.fWidth, this.fHeight);
            int n = this.getBackground();
            this.fBackground = new Color((Device)display, n >> 16 & 0xFF, n >> 8 & 0xFF, n & 0xFF);
        }
        GC gC = new GC((Drawable)this.fImage);
        gC.setBackground(this.fBackground);
        return gC;
    }

    public ImageData getImageData() {
        if (this.fImage == null || this.fImage.isDisposed()) {
            return null;
        }
        RGB[] rGBArray = this.getColors();
        int n = (int)Math.ceil(Math.log(rGBArray.length) / Math.log(2.0));
        n = n <= 1 ? 1 : (n <= 2 ? 2 : (n <= 4 ? 4 : (n <= 8 ? 8 : (n <= 16 ? 16 : (n <= 24 ? 24 : 32)))));
        PaletteData paletteData = new PaletteData(rGBArray);
        ImageData imageData = new ImageData(this.fWidth, this.fHeight, n, paletteData);
        imageData.transparentPixel = 0;
        ImageData imageData2 = this.fImage.getImageData();
        int[] nArray = new int[this.fWidth];
        try {
            for (int i = 0; i < this.fHeight; ++i) {
                imageData2.getPixels(0, i, this.fWidth, nArray, 0);
                for (int j = 0; j < this.fWidth; ++j) {
                    int n2;
                    RGB rGB = imageData2.palette.getRGB(nArray[j]);
                    nArray[j] = n2 = paletteData.getPixel(rGB);
                }
                imageData.setPixels(0, i, this.fWidth, nArray, 0);
            }
        }
        catch (Throwable throwable) {
            imageData = null;
        }
        return imageData;
    }

    protected int getBackground() {
        int n = Colors.getCount();
        for (int i = 0; i < n; ++i) {
            Integer n2 = new Integer(Colors.getRGBByIndex(i));
            if (this.rgbs.contains(n2)) continue;
            return n2;
        }
        return 0xD3D3D3;
    }

    protected RGB[] getColors() {
        int n = this.getBackground();
        RGB[] rGBArray = new RGB[this.rgbs.size() + 1];
        rGBArray[0] = new RGB(n >> 16 & 0xFF, n >> 8 & 0xFF, n & 0xFF);
        for (int i = 0; i < this.rgbs.size(); ++i) {
            int n2 = (Integer)this.rgbs.get(i);
            rGBArray[i + 1] = new RGB(n2 >> 16 & 0xFF, n2 >> 8 & 0xFF, n2 & 0xFF);
        }
        return rGBArray;
    }
}

