/*
 * Decompiled with CFR 0.152.
 */
package com.spket.widget;

import com.spket.util.StringUtils;
import com.spket.widget.CItem;
import com.spket.widget.ListWithPreivew;
import com.spket.widget.UIUtils;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;

public class SymbolList
extends ListWithPreivew {
    protected static final int MIN_COLUMNS = 3;
    public static final Symbol CUSTOM_ITEM = new Symbol(null, '\u0000');
    private Font symbolFont = UIUtils.getFont("font.symbol");
    private int fBigItemSize;

    public SymbolList(Composite composite, int n) {
        super(composite, n);
    }

    public void addItem(String string, char c) {
        CItem cItem = new CItem();
        cItem.fData = new Symbol(string, c);
        this.addItem(cItem);
    }

    public void addItem(Symbol symbol) {
        CItem cItem = new CItem();
        cItem.fData = new Symbol(symbol.fontName, symbol.value);
        this.addItem(cItem);
    }

    public void addCustomItem(String string) {
        CItem cItem = new CItem();
        cItem.fData = CUSTOM_ITEM;
        cItem.text = string;
        this.addItem(cItem);
    }

    public void setSelection(Symbol symbol) {
        int n = -1;
        if (symbol == CUSTOM_ITEM) {
            for (int i = 0; i < this.fItemCount; ++i) {
                if (symbol != this.fItems[i].getData()) continue;
                n = i;
                break;
            }
        } else if (symbol != null) {
            for (int i = 0; i < this.fItemCount; ++i) {
                if (!symbol.equals(this.fItems[i].getData())) continue;
                n = i;
                break;
            }
        }
        this.setSelection(n);
    }

    public void setFont(Font font) {
        this.fBigItemSize = 0;
        super.setFont(font);
    }

    protected int getBigItemSize() {
        if (this.fBigItemSize == 0) {
            GC gC = new GC((Drawable)this);
            gC.setFont(this.symbolFont);
            this.fBigItemSize = gC.stringExtent((String)"gM").y | 1;
            gC.dispose();
        }
        return this.fBigItemSize;
    }

    protected int getMinimumColumns() {
        return 3;
    }

    protected boolean isNormal(CItem cItem) {
        Symbol symbol = (Symbol)cItem.fData;
        return symbol != null && symbol.value > '\u0000';
    }

    protected String calcToolTipText(int n) {
        CItem cItem = this.getItem(n);
        if (cItem != null && this.isNormal(cItem)) {
            Symbol symbol = (Symbol)cItem.fData;
            String string = "#x" + Integer.toHexString(symbol.value).toUpperCase() + ';';
            if (symbol.fontName != null) {
                string = string + " (" + symbol.fontName + ")";
            }
            return string;
        }
        return null;
    }

    protected void drawItem(GC gC, int n) {
        CItem cItem = this.getItem(n);
        if (cItem == null) {
            return;
        }
        Rectangle rectangle = cItem.bounds;
        int n2 = rectangle.x;
        int n3 = rectangle.y;
        int n4 = rectangle.width;
        int n5 = rectangle.height;
        if (this.isSeparator(cItem)) {
            this.drawSeparator(gC, n2, n3 += n5 / 2, n4, n5);
        } else if (this.isNormal(cItem)) {
            Symbol symbol = (Symbol)cItem.fData;
            String string = String.valueOf(symbol.value);
            n2 += 3;
            n3 += 3;
            n4 -= 7;
            n5 -= 7;
            Font font = null;
            Font font2 = gC.getFont();
            if (symbol.fontName != null) {
                FontData[] fontDataArray;
                int n6 = 9;
                if (font2 != null && (fontDataArray = font2.getFontData()) != null && fontDataArray.length > 0 && fontDataArray[0] != null) {
                    n6 = fontDataArray[0].getHeight();
                }
                font = new Font((Device)this.getDisplay(), symbol.fontName, n6, 0);
                gC.setFont(font);
            }
            gC.drawString(string, n2, n3, true);
            gC.setFont(font2);
            if (font != null) {
                font.dispose();
            }
        } else {
            String string = cItem.text;
            if (string != null) {
                Point point = gC.stringExtent(string);
                gC.drawString(string, n2 += (n4 - point.x) / 2, n3 += (n5 - point.y) / 2, true);
            }
        }
    }

    protected void drawPreview(GC gC) {
        if (this.fPreivewRect == null) {
            return;
        }
        CItem cItem = this.getItem(this.fMouseOverIndex);
        if (cItem == null || !this.isNormal(cItem)) {
            cItem = this.getItem(this.fSelectedIndex);
        }
        if (cItem != null && this.isNormal(cItem)) {
            Symbol symbol = (Symbol)cItem.fData;
            String string = String.valueOf(symbol.value);
            Font font = null;
            Font font2 = gC.getFont();
            if (symbol.fontName != null) {
                font = new Font((Device)this.getDisplay(), symbol.fontName, 24, 0);
                gC.setFont(font);
            } else {
                gC.setFont(this.symbolFont);
            }
            gC.drawString(string, this.fPreivewRect.x + 3, this.fPreivewRect.y + 3, true);
            gC.drawRectangle(this.fPreivewRect.x, this.fPreivewRect.y, this.fPreivewRect.width - 1, this.fPreivewRect.height - 1);
            gC.setFont(font2);
            if (font != null) {
                font.dispose();
            }
        }
    }

    public static final class Symbol {
        private String fontName;
        private char value;

        public Symbol(String string, char c) {
            this.fontName = string;
            this.value = c;
        }

        public String getFontName() {
            return this.fontName;
        }

        public char getValue() {
            return this.value;
        }

        public boolean equals(Object object) {
            if (object instanceof Symbol) {
                Symbol symbol = (Symbol)object;
                if (this.value == symbol.value) {
                    return StringUtils.equals((Object)this.fontName, (Object)symbol.fontName);
                }
            }
            return false;
        }

        public int hashCode() {
            int n = this.value;
            if (this.fontName != null) {
                n += this.fontName.hashCode();
            }
            return n;
        }
    }
}

