/*
 * Decompiled with CFR 0.152.
 */
package com.spket.widget;

import com.spket.util.StringUtils;
import com.spket.widget.Dialog;
import com.spket.widget.Messages;
import com.spket.widget.SymbolList;
import com.spket.widget.UIUtils;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SymbolDialog
extends Dialog {
    protected static String[] fontNames;
    protected static final int[][] UNICODE_RANGES;
    protected static String[] UNICODE_RANGE_NAMES;
    protected Combo fFontList;
    protected Combo fRangeList;
    protected Composite fCanvas;
    protected Text fCodeField;
    protected org.eclipse.swt.graphics.Font fFont;
    protected Font jFont;
    protected int fItemSize = 24;
    protected int fColumnCount = 16;
    protected int fRowCount = 6;
    protected int fOffset;
    protected boolean fIsMouseDown;
    protected int fSelectedIndex = -1;
    protected int fFontIndex = -1;
    protected int fRangeIndex = -1;

    public SymbolDialog(Shell shell) {
        super(shell);
    }

    public SymbolList.Symbol getSymbol() {
        if (this.fSelectedIndex > 0) {
            String string = null;
            if (fontNames != null && this.fFontIndex >= 0 && this.fFontIndex < fontNames.length) {
                string = fontNames[this.fFontIndex];
            }
            char c = (char)(this.fSelectedIndex & 0xFFFF);
            return new SymbolList.Symbol(string, c);
        }
        return null;
    }

    protected void configureShell(Shell shell) {
        shell.setText(Messages.getString("dlg.symbol.title"));
        super.configureShell(shell);
    }

    protected Control createDialogArea(Composite composite) {
        if (fontNames == null) {
            SymbolDialog.initFontNames(composite.getDisplay());
        }
        if (UNICODE_RANGE_NAMES == null) {
            SymbolDialog.initRangeNames();
        }
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        composite2.setLayout((Layout)gridLayout);
        Composite composite3 = new Composite(composite2, 0);
        gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 2;
        composite3.setLayout((Layout)gridLayout);
        Label label = new Label(composite3, 0);
        label.setText(Messages.getString("dlg.symbol.font.label"));
        this.fFontList = new Combo(composite3, 8);
        composite3 = new Composite(composite2, 0);
        gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 2;
        composite3.setLayout((Layout)gridLayout);
        composite3.setLayoutData((Object)new GridData(128));
        label = new Label(composite3, 0);
        label.setText(Messages.getString("dlg.symbol.range.label"));
        this.fRangeList = new Combo(composite3, 8);
        if (fontNames != null && fontNames.length > 0) {
            this.fFontList.setItems(fontNames);
            this.fFontList.select(0);
            this.fFontList.setVisibleItemCount(Math.max(5, Math.min(20, fontNames.length >> 1)));
        }
        this.fRangeList.setItems(UNICODE_RANGE_NAMES);
        this.fRangeList.select(0);
        this.fRangeList.setVisibleItemCount(20);
        this.fCanvas = new Composite(composite2, 1311232);
        GC gC = new GC((Drawable)this.fCanvas);
        gC.setFont(UIUtils.getFont("font.symbol"));
        this.fItemSize = gC.stringExtent((String)"gM").y + 4;
        if (this.fItemSize <= 0) {
            this.fItemSize = 24;
        }
        gC.dispose();
        ScrollBar scrollBar = this.fCanvas.getVerticalBar();
        scrollBar.setValues(0, 0, 4096, 6, 1, 6);
        GridData gridData = new GridData();
        gridData.widthHint = this.fColumnCount * this.fItemSize + 1;
        gridData.heightHint = this.fRowCount * this.fItemSize + 1;
        gridData.horizontalSpan = 2;
        this.fCanvas.setLayoutData((Object)gridData);
        composite3 = new Composite(composite2, 0);
        gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 2;
        composite3.setLayout((Layout)gridLayout);
        label = new Label(composite3, 0);
        label.setText(Messages.getString("dlg.symbol.code.label"));
        this.fCodeField = new Text(composite3, 2052);
        this.onFontChanged();
        this.installListeners();
        return composite2;
    }

    protected void installListeners() {
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 5: {
                        SymbolDialog.this.onMouseMove(event);
                        break;
                    }
                    case 9: {
                        SymbolDialog.this.onPaint(event);
                        break;
                    }
                    case 3: {
                        SymbolDialog.this.onMouseDown(event);
                        break;
                    }
                    case 4: {
                        SymbolDialog.this.onMouseUp(event);
                        break;
                    }
                    case 12: {
                        SymbolDialog.this.onDispose();
                    }
                }
            }
        };
        this.fCanvas.addListener(9, listener);
        this.fCanvas.addListener(5, listener);
        this.fCanvas.addListener(3, listener);
        this.fCanvas.addListener(4, listener);
        this.fCanvas.addListener(12, listener);
        this.fCanvas.addListener(1, listener);
        Listener listener2 = new Listener(){

            public void handleEvent(Event event) {
                if (event.type == 31) {
                    event.doit = true;
                    if (event.widget == SymbolDialog.this.fCodeField) {
                        SymbolDialog.this.onInputChanged(event);
                    } else if (event.detail == 4 && event.widget != SymbolDialog.this.fCanvas) {
                        event.doit = false;
                    }
                } else if (event.widget == SymbolDialog.this.fFontList) {
                    SymbolDialog.this.onFontChanged();
                } else if (event.widget == SymbolDialog.this.fRangeList) {
                    SymbolDialog.this.onRangeChanged();
                } else {
                    SymbolDialog.this.onScroll();
                }
            }
        };
        this.fFontList.addListener(13, listener2);
        this.fFontList.addListener(31, listener2);
        this.fRangeList.addListener(13, listener2);
        this.fRangeList.addListener(31, listener2);
        this.fCodeField.addListener(31, listener2);
        this.fCanvas.addListener(31, listener2);
        ScrollBar scrollBar = this.fCanvas.getVerticalBar();
        scrollBar.addListener(13, listener2);
    }

    protected void onDispose() {
        if (this.fFont != null) {
            this.fFont.dispose();
            this.fFont = null;
        }
        this.jFont = null;
    }

    protected void onPaint(Event event) {
        int n;
        int n2;
        int n3;
        GC gC = event.gc;
        Display display = this.fCanvas.getDisplay();
        Rectangle rectangle = this.fCanvas.getClientArea();
        Rectangle rectangle2 = gC.getClipping();
        gC.setFont(this.fFont == null ? UIUtils.getFont("font.symbol") : this.fFont);
        int n4 = this.fOffset;
        for (n3 = 0; n3 < this.fRowCount; ++n3) {
            for (n2 = 0; n2 < this.fColumnCount; ++n2) {
                this.drawItem(gC, n4);
                ++n4;
            }
        }
        gC.setClipping(rectangle2);
        gC.setForeground(display.getSystemColor(2));
        n3 = rectangle.x;
        n2 = rectangle.y;
        int n5 = n3 + this.fColumnCount * this.fItemSize;
        for (n = 0; n <= this.fRowCount; ++n) {
            gC.drawLine(n3, n2, n5, n2);
            n2 += this.fItemSize;
        }
        n3 = rectangle.x;
        n2 = rectangle.y;
        n = n2 + this.fRowCount * this.fItemSize;
        for (int i = 0; i <= this.fColumnCount; ++i) {
            gC.drawLine(n3, n2, n3, n);
            n3 += this.fItemSize;
        }
    }

    protected void onMouseMove(Event event) {
        if (!this.fIsMouseDown) {
            return;
        }
        Rectangle rectangle = this.fCanvas.getClientArea();
        if (!rectangle.contains(event.x, event.y)) {
            return;
        }
        int n = this.getIndexAtPoint(event.x, event.y);
        if (n != this.fSelectedIndex) {
            int n2 = this.fSelectedIndex;
            this.setSelection(n);
            if (n2 != -1) {
                this.drawItem(n2);
            }
            if (n != -1) {
                this.drawItem(n);
            }
        }
    }

    protected int getIndexAtPoint(int n, int n2) {
        int n3 = -1;
        Rectangle rectangle = this.fCanvas.getClientArea();
        if (rectangle.contains(n, n2)) {
            int n4 = n2 / this.fItemSize;
            int n5 = n / this.fItemSize;
            n3 = this.fOffset + n4 * this.fColumnCount + n5;
        }
        return n3;
    }

    protected void onMouseUp(Event event) {
        this.fIsMouseDown = false;
    }

    protected void onMouseDown(Event event) {
        this.fIsMouseDown = true;
        int n = this.getIndexAtPoint(event.x, event.y);
        if (n != this.fSelectedIndex && n != -1) {
            int n2 = this.fSelectedIndex;
            this.setSelection(n);
            if (n2 != n && n2 != -1) {
                this.drawItem(n2);
            }
            if (n != -1) {
                this.drawItem(n);
            }
        }
    }

    protected void drawItem(GC gC, int n) {
        int n2 = 0;
        int n3 = 0;
        char c = (char)(n & 0xFFFF);
        int n4 = n - this.fOffset;
        n3 = (n4 >> 4) * this.fItemSize + 1;
        n2 = (n4 & 0xF) * this.fItemSize + 1;
        gC.setClipping(n2, n3, this.fItemSize - 1, this.fItemSize - 1);
        Display display = this.fCanvas.getDisplay();
        if (n == this.fSelectedIndex) {
            gC.setBackground(display.getSystemColor(26));
            gC.setForeground(display.getSystemColor(27));
        } else {
            gC.setBackground(display.getSystemColor(1));
            gC.setForeground(display.getSystemColor(2));
        }
        gC.fillRectangle(n2, n3, this.fItemSize - 1, this.fItemSize - 1);
        if (this.jFont != null && this.jFont.canDisplay(c)) {
            gC.drawString(String.valueOf(c), n2, n3, true);
        }
        if (n == this.fSelectedIndex) {
            gC.drawFocus(n2, n3, this.fItemSize - 1, this.fItemSize - 1);
        }
    }

    protected void drawItem(int n) {
        if (n < 0 || n > 65535) {
            return;
        }
        GC gC = new GC((Drawable)this.fCanvas);
        gC.setFont(this.fFont == null ? UIUtils.getFont("font.symbol") : this.fFont);
        this.drawItem(gC, n);
        gC.dispose();
    }

    protected void onFontChanged() {
        int n = this.fFontList.getSelectionIndex();
        if (n == this.fFontIndex) {
            return;
        }
        this.fFontIndex = n;
        org.eclipse.swt.graphics.Font font = this.fFont;
        String string = null;
        if (fontNames != null && n >= 0 && n < fontNames.length) {
            string = fontNames[n];
        }
        if (StringUtils.isEmpty(string)) {
            this.fFont = null;
            this.jFont = null;
        } else {
            this.fFont = new org.eclipse.swt.graphics.Font((Device)this.fCanvas.getDisplay(), string, 24, 0);
            this.jFont = new Font(string, 0, 24);
        }
        if (this.fCanvas != null) {
            this.fCanvas.redraw();
        }
        if (font != null) {
            font.dispose();
        }
    }

    protected void onRangeChanged() {
        int n = this.fRangeList.getSelectionIndex();
        if (n == this.fRangeIndex) {
            return;
        }
        if (n < 0) {
            n = 0;
        } else if (n >= UNICODE_RANGES.length) {
            n = UNICODE_RANGES.length - 1;
        }
        n = UNICODE_RANGES[n][0];
        this.fOffset = n >= 65440 ? 65440 : n & 0xFFF0;
        this.setSelection(n);
        ScrollBar scrollBar = this.fCanvas.getVerticalBar();
        scrollBar.setSelection(this.fOffset >> 4);
        this.fCanvas.redraw();
    }

    protected void onInputChanged(Event event) {
        if (event.detail == 4) {
            event.doit = false;
            String string = this.fCodeField.getText();
            if (!StringUtils.isEmpty((String)string)) {
                int n = -1;
                try {
                    n = Integer.parseInt(string, 16);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (n >= 0 && n <= 65535) {
                    this.fOffset = n >= 65440 ? 65440 : n & 0xFFF0;
                    this.setSelection(n);
                    ScrollBar scrollBar = this.fCanvas.getVerticalBar();
                    scrollBar.setSelection(this.fOffset >> 4);
                    this.fCanvas.redraw();
                }
            }
        }
    }

    protected void onScroll() {
        ScrollBar scrollBar = this.fCanvas.getVerticalBar();
        int n = scrollBar.getSelection();
        int n2 = this.fOffset;
        this.fOffset = n << 4;
        if (this.fSelectedIndex == -1) {
            this.setSelection(this.fOffset);
        } else {
            this.setSelection(this.fSelectedIndex + this.fOffset - n2);
        }
        this.fCanvas.redraw();
    }

    protected void setSelection(int n) {
        this.fSelectedIndex = n;
        this.fCodeField.setText(Integer.toHexString(n).toUpperCase());
    }

    protected static void initFontNames(Display display) {
        String[] stringArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        if (stringArray != null && stringArray.length > 0) {
            if (display == null) {
                display = UIUtils.getDisplay();
            }
            HashSet<String> hashSet = new HashSet<String>(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                hashSet.add(stringArray[i]);
            }
            FontData[] fontDataArray = display.getFontList(null, true);
            if (fontDataArray != null && fontDataArray.length > 0) {
                ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
                for (int i = 0; i < fontDataArray.length; ++i) {
                    String string = fontDataArray[i].getName();
                    if (!hashSet.remove(string)) continue;
                    arrayList.add(string);
                }
                if (arrayList.size() > 0) {
                    fontNames = new String[arrayList.size()];
                    arrayList.toArray(fontNames);
                    Arrays.sort(fontNames, Collator.getInstance());
                }
            }
        }
        if (fontNames == null) {
            fontNames = StringUtils.EMPTY_STRINGS;
        }
    }

    protected static void initRangeNames() {
        String[] stringArray;
        UNICODE_RANGE_NAMES = new String[UNICODE_RANGES.length];
        String string = Messages.getString("unicode.range.desc", null);
        int n = 0;
        if (string != null && (stringArray = StringUtils.split((String)string, (char)',')) != null) {
            n = Math.min(UNICODE_RANGE_NAMES.length, stringArray.length);
            for (int i = 0; i < n; ++i) {
                SymbolDialog.UNICODE_RANGE_NAMES[i] = stringArray[i].trim();
            }
        }
        if (n < UNICODE_RANGE_NAMES.length) {
            for (int i = n; i < UNICODE_RANGE_NAMES.length; ++i) {
                int[] nArray = UNICODE_RANGES[i];
                SymbolDialog.UNICODE_RANGE_NAMES[i] = Messages.getString("dlg.symbol.range.name") + nArray[0] + " - " + nArray[1];
            }
        }
    }

    static {
        UNICODE_RANGES = new int[][]{{0, 127}, {128, 255}, {256, 383}, {384, 591}, {592, 687}, {688, 767}, {768, 879}, {880, 1023}, {1024, 1279}, {1280, 1327}, {1328, 1423}, {1424, 1535}, {1536, 1791}, {1792, 1871}, {1920, 1983}, {2304, 2431}, {2432, 2559}, {2560, 2687}, {2688, 2815}, {2816, 2943}, {2944, 3071}, {3072, 3199}, {3200, 3327}, {3328, 3455}, {3456, 3583}, {3584, 3711}, {3712, 3839}, {3840, 4095}, {4096, 4255}, {4256, 4351}, {4352, 4607}, {4608, 4991}, {5024, 5119}, {5120, 5759}, {5760, 5791}, {5792, 5887}, {5888, 5919}, {5920, 5951}, {5952, 5983}, {5984, 6015}, {6016, 6143}, {6144, 6319}, {6400, 6479}, {6480, 6527}, {6624, 6655}, {7424, 7551}, {7680, 7935}, {7936, 8191}, {8192, 8303}, {8304, 8351}, {8352, 8399}, {8400, 8447}, {8448, 8527}, {8528, 8591}, {8592, 8703}, {8704, 8959}, {8960, 9215}, {9216, 9279}, {9280, 9311}, {9312, 9471}, {9472, 9599}, {9600, 9631}, {9632, 9727}, {9728, 9983}, {9984, 10175}, {10176, 10223}, {10224, 10239}, {10240, 10495}, {10496, 10623}, {10624, 10751}, {10752, 11007}, {11008, 11263}, {11904, 12031}, {12032, 12255}, {12272, 12287}, {12288, 12351}, {12352, 12447}, {12448, 12543}, {12544, 12591}, {12592, 12687}, {12688, 12703}, {12704, 12735}, {12784, 12799}, {12800, 13055}, {13056, 13311}, {13312, 19903}, {19904, 19967}, {19968, 40959}, {40960, 42127}, {42128, 42191}, {44032, 55215}, {55296, 56191}, {56192, 56319}, {56320, 57343}, {57344, 63743}, {63744, 64255}, {64256, 64335}, {64336, 65023}, {65024, 65039}, {65056, 65071}, {65072, 65103}, {65104, 65135}, {65136, 65279}, {65280, 65519}, {65520, 65535}};
    }
}

