/*
 * Decompiled with CFR 0.152.
 */
package com.spket.widget;

import com.spket.widget.ListItem;
import com.spket.widget.UIUtils;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;

public class PropertyList
extends Composite {
    public static final int OffsetChanged = 4001;
    private static final int LEFT_BORDER = 14;
    private int fOffset;
    private int fSelectedIndex = -1;
    private boolean fHighLighting;
    private int fHighLightingColumn;
    private int fLeftColumnX = -1;
    private boolean fAdjustColumnWidth;
    private boolean fNeedRestCursor;
    private boolean fMouseDown;
    protected int fMouseOverIndex = -1;
    protected int fMouseOverColumn = -1;
    private boolean fFirstTime;
    private Font fBoldFont;
    private Color fGridColor;
    private Color fGrayColor;
    private Color fSelectionColor;
    private Color fSelectionTextColor;
    private boolean fDirty;
    protected boolean fLayouted;
    private int fItemHeight = 15;
    private int fItemCount;
    private ListItem fRoot = new ListItem();
    private ListItem[] fItems = ListItem.EMPTY_ITEMS;

    static int checkStyle(int n) {
        n = (n & 0x800000) != 0 ? 0x800000 : ((n & 0x800) != 0 ? 2048 : 0);
        n = n | 0x100000 | 0x40000 | 0x200;
        return n;
    }

    public PropertyList(Composite composite, int n) {
        super(composite, PropertyList.checkStyle(n));
        this.init();
    }

    protected void init() {
        Display display = this.getDisplay();
        this.fGrayColor = display.getSystemColor(16);
        this.fGridColor = display.getSystemColor(19);
        this.fSelectionColor = display.getSystemColor(26);
        this.fSelectionTextColor = display.getSystemColor(27);
        this.setBackground(display.getSystemColor(1));
        this.calcItemHeight();
        this.installListeners();
    }

    protected void calcItemHeight() {
        GC gC = new GC((Drawable)this);
        int n = gC.stringExtent((String)"gM").y + 4;
        gC.dispose();
        this.fDirty = n != this.fItemHeight;
        this.fItemHeight = n;
    }

    protected void installListeners() {
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 5: {
                        PropertyList.this.onMouseMove(event);
                        break;
                    }
                    case 9: {
                        PropertyList.this.onPaint(event);
                        break;
                    }
                    case 3: {
                        PropertyList.this.onMouseDown(event);
                        break;
                    }
                    case 4: {
                        PropertyList.this.onMouseUp(event);
                        break;
                    }
                    case 7: {
                        PropertyList.this.onMouseExit(event);
                        break;
                    }
                    case 1: {
                        PropertyList.this.onKeyDown(event);
                        break;
                    }
                    case 31: {
                        PropertyList.this.onTraverse(event);
                        break;
                    }
                    case 11: {
                        PropertyList.this.onResize(event);
                        break;
                    }
                    case 12: {
                        PropertyList.this.onDispose();
                        break;
                    }
                    case 8: {
                        PropertyList.this.onMouseDoubleClick(event);
                    }
                }
            }
        };
        this.addListener(9, listener);
        this.addListener(5, listener);
        this.addListener(3, listener);
        this.addListener(4, listener);
        this.addListener(7, listener);
        this.addListener(8, listener);
        this.addListener(1, listener);
        this.addListener(31, listener);
        this.addListener(11, listener);
        this.addListener(12, listener);
        ScrollBar scrollBar = this.getVerticalBar();
        if (scrollBar != null) {
            scrollBar.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    PropertyList.this.onScroll(event);
                }
            });
        }
    }

    public void addItem(ListItem listItem) {
        this.fDirty = true;
        this.fRoot.addItem(listItem);
    }

    public void removeAll() {
        if (this.fRoot.getItemCount() > 0) {
            this.fDirty = true;
            this.fRoot.removeAll();
        }
    }

    public ListItem getItem(int n) {
        if (n < 0 || n >= this.fItemCount) {
            return null;
        }
        return this.fItems[n];
    }

    public ListItem[] getItems() {
        if (this.fRoot != null) {
            return this.fRoot.getItems();
        }
        return ListItem.EMPTY_ITEMS;
    }

    public void setFont(Font font) {
        if (this.fBoldFont != null) {
            this.fBoldFont.dispose();
            this.fBoldFont = null;
        }
        super.setFont(font);
        this.calcItemHeight();
        this.redraw();
    }

    public void setHighLighting(boolean bl) {
        if (bl == this.fHighLighting) {
            return;
        }
        this.checkWidget();
        this.fHighLighting = bl;
        if (this.fSelectedIndex != -1) {
            this.redrawItem(this.fSelectedIndex);
        }
    }

    public void setHighLighting(int n) {
        if (this.fHighLightingColumn != n) {
            this.fHighLightingColumn = n;
            if (this.fSelectedIndex != -1) {
                this.checkWidget();
                this.redrawItem(this.fSelectedIndex);
            }
        }
    }

    public Rectangle getBounds(int n) {
        if (n < this.fOffset || n >= this.fItemCount) {
            return null;
        }
        Rectangle rectangle = this.getClientArea();
        int n2 = (n - this.fOffset) * this.fItemHeight;
        if (n2 <= rectangle.height) {
            return new Rectangle(rectangle.x, rectangle.y + n2, rectangle.width, this.fItemHeight);
        }
        return null;
    }

    public Rectangle getBounds(int n, int n2) {
        Rectangle rectangle = this.getBounds(n);
        if (rectangle != null) {
            int n3 = this.getAdjustColumnX(rectangle.x, rectangle.width);
            if (n2 == 0) {
                rectangle.x += 15;
                rectangle.width = n3 - rectangle.x;
            } else {
                rectangle.width += rectangle.x;
                rectangle.x = n3 + 2;
                rectangle.width = Math.max(0, rectangle.width - rectangle.x);
            }
        }
        return rectangle;
    }

    public Rectangle getCellBounds(int n, int n2) {
        Rectangle rectangle = this.getBounds(n);
        if (rectangle != null) {
            int n3 = this.getAdjustColumnX(rectangle.x, rectangle.width);
            if (n2 == 0) {
                rectangle.x += 15;
                rectangle.width = n3 - rectangle.x;
            } else {
                ListItem listItem = this.getItem(n);
                rectangle.width += rectangle.x;
                rectangle.x = n3 + 4;
                if (listItem.isOwnerDraw()) {
                    rectangle.x += listItem.getWidth() + 2;
                }
                rectangle.width = Math.max(0, rectangle.width - rectangle.x);
            }
            rectangle.y += 2;
            rectangle.height -= 2;
        }
        return rectangle;
    }

    public int getColumnIndex(int n) {
        Rectangle rectangle = this.getClientArea();
        int n2 = this.getAdjustColumnX(rectangle.x, rectangle.width);
        if (n <= 14 || n >= n2) {
            return 1;
        }
        return 0;
    }

    public int getOffset() {
        return this.fOffset;
    }

    public int getSelectionIndex() {
        return this.fSelectedIndex;
    }

    public void setSelection(int n) {
        if (n == this.fSelectedIndex) {
            return;
        }
        this.checkWidget();
        int n2 = this.fItemCount;
        if (this.fSelectedIndex != n) {
            int n3 = this.fSelectedIndex;
            this.fSelectedIndex = n >= 0 && n < n2 ? n : -1;
            Rectangle rectangle = this.getClientArea();
            Rectangle rectangle2 = this.getBounds(n);
            if (rectangle2 != null && rectangle2.y + rectangle2.height <= rectangle.y + rectangle.height) {
                if (n3 != -1) {
                    this.redrawItem(n3);
                }
                if (this.fSelectedIndex != -1) {
                    this.redrawItem(this.fSelectedIndex);
                }
            }
        }
    }

    public void setSelection(int n, int n2) {
        if (this.fDirty) {
            this.layoutItems();
        }
        if (n != -1) {
            if (n >= this.fItemCount) {
                n = this.fItemCount - 1;
            }
            this.fOffset = Math.max(0, n - n2);
            Rectangle rectangle = this.getClientArea();
            int n3 = rectangle.height / this.fItemHeight;
            if (this.fOffset + n3 > this.fItemCount) {
                this.fOffset = this.fItemCount - n3;
            } else if (this.fOffset < n) {
                int n4 = n - this.fOffset;
                if (n4 >= n3) {
                    this.fOffset += n4 - n3 + 1;
                }
            } else {
                this.fOffset = n;
            }
            if (this.fOffset < 0) {
                this.fOffset = 0;
            }
        } else {
            this.fOffset = 0;
        }
        this.fSelectedIndex = n;
        this.layout(true);
        this.redraw();
    }

    public void setSelection(ListItem listItem, int n) {
        if (this.fDirty) {
            this.layoutItems();
        }
        int n2 = -1;
        for (int i = 0; i < this.fItemCount; ++i) {
            if (this.fItems[i] != listItem) continue;
            n2 = i;
            break;
        }
        this.setSelection(n2, n);
    }

    protected void showItem(int n) {
        Rectangle rectangle;
        int n2 = this.fItemCount;
        if (n < 0 || n >= n2) {
            return;
        }
        int n3 = this.fOffset;
        if (n < n3) {
            n3 = n;
        } else {
            rectangle = this.getClientArea();
            int n4 = rectangle.height / this.fItemHeight;
            if (n >= n3 + n4) {
                n3 = n - n4 + 1;
            }
        }
        if (n3 != this.fOffset) {
            this.fOffset = n3;
            this.layout(true);
            rectangle = new Event();
            rectangle.detail = n3;
            this.notifyListeners(4001, (Event)rectangle);
            this.redraw();
        }
    }

    protected void setSelection(int n, boolean bl) {
        if (n != this.fSelectedIndex) {
            int n2 = this.fSelectedIndex;
            this.setSelection(n);
            if (bl) {
                Event event = new Event();
                event.detail = n2;
                event.data = this.getItem(n);
                this.notifyListeners(13, event);
            }
        }
    }

    protected void onPaint(Event event) {
        this.layout(false);
        GC gC = event.gc;
        Rectangle rectangle = this.getClientArea();
        int n = this.fItemHeight * (this.fItemCount - this.fOffset);
        if (n < rectangle.height) {
            gC.fillRectangle(rectangle.x, rectangle.y + n, rectangle.width, rectangle.height - n);
        }
        if (rectangle.height >= this.fItemHeight) {
            this.drawItems(gC, rectangle);
        }
    }

    protected void redrawItem(int n) {
        ListItem listItem = this.getItem(n);
        if (listItem == null) {
            return;
        }
        Rectangle rectangle = this.getBounds(n);
        if (rectangle == null) {
            return;
        }
        this.redraw(rectangle.x, rectangle.y, rectangle.width, this.fItemHeight, false);
    }

    protected void drawSign(GC gC, int n, int n2, int n3, boolean bl) {
        Rectangle rectangle = this.getSignRectangle(n, n2, n3);
        if (n3 > 0) {
            Color color = gC.getBackground();
            gC.setBackground(this.fSelectionTextColor);
            gC.fillRectangle(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
            gC.setBackground(color);
        }
        gC.drawRectangle(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
        int n4 = 4;
        int n5 = rectangle.x + (rectangle.width - n4) / 2;
        int n6 = n5 + n4 / 2;
        int n7 = rectangle.y + (rectangle.height - n4) / 2;
        int n8 = n7 + n4 / 2;
        gC.drawLine(n5, n8, n5 + n4, n8);
        if (!bl) {
            gC.drawLine(n6, n7, n6, n7 + n4);
        }
    }

    protected void drawItem(GC gC, int n, ListItem listItem, Rectangle rectangle) {
        int n2;
        String string;
        Color color = gC.getBackground();
        gC.setBackground(this.fGridColor);
        if (listItem.isCategory()) {
            gC.fillRectangle(rectangle.x, rectangle.y + 1, rectangle.width, rectangle.height);
        } else {
            gC.fillRectangle(rectangle.x, rectangle.y + 1, 14, rectangle.height);
        }
        gC.setBackground(color);
        if (listItem.isCategory()) {
            string = listItem.getText();
            if (string != null && string.length() > 0) {
                n2 = rectangle.x + 14 + this.getTextIndent(listItem.getLevel());
                Color color2 = gC.getForeground();
                Font font = gC.getFont();
                gC.setFont(this.getBoldFont(gC));
                gC.setForeground(this.fGrayColor);
                gC.drawString(string, n2, rectangle.y + 1, true);
                gC.setForeground(color2);
                if (this.fHighLighting && n == this.fSelectedIndex) {
                    n2 = Math.max(n2 - 3, rectangle.x - 14 + 1);
                    int n3 = gC.stringExtent((String)string).x + (n2 - (rectangle.x + 14)) + 4;
                    gC.drawFocus(n2, rectangle.y + 1, n3, this.fItemHeight - 1);
                }
                gC.setFont(font);
            }
        } else {
            this.drawListItem(gC, listItem, rectangle, n);
        }
        if (listItem.getItemCount() > 0) {
            this.drawSign(gC, rectangle.x, rectangle.y, listItem.getLevel(), listItem.isExpanded());
        }
        string = gC.getForeground();
        gC.setForeground(this.fGridColor);
        if (n == this.fOffset) {
            gC.drawLine(rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y);
        }
        if (!listItem.isCategory()) {
            n2 = rectangle.x + 14;
            int n4 = rectangle.y + rectangle.height;
            int n5 = this.getAdjustColumnX(rectangle.x, rectangle.width);
            if (n5 > n2) {
                gC.drawLine(n5, rectangle.y, n5, n4);
            }
            gC.drawLine(n2, n4, n2 + rectangle.width, n4);
        }
        gC.setForeground((Color)string);
    }

    protected void drawListItem(GC gC, ListItem listItem, Rectangle rectangle, int n) {
        String string;
        int n2 = rectangle.x + 14;
        int n3 = rectangle.y + 1;
        int n4 = rectangle.width - 14;
        int n5 = this.getAdjustColumnX(rectangle.x, rectangle.width) - n2;
        n5 = Math.max(0, n5);
        int n6 = Math.max(0, n4 - n5);
        Color color = null;
        if (n == this.fSelectedIndex) {
            color = gC.getBackground();
            if (this.fHighLightingColumn != 1) {
                if (n6 > 0) {
                    gC.fillRectangle(n2 + n5, n3, n6, rectangle.height);
                }
            } else if (n5 > 0) {
                gC.fillRectangle(n2, n3, n5, rectangle.height);
            }
            if (this.fHighLighting) {
                gC.setBackground(this.fSelectionColor);
            } else {
                gC.setBackground(this.fGridColor);
            }
            if (this.fHighLightingColumn != 1) {
                if (n5 > 0) {
                    gC.fillRectangle(n2, n3, n5, rectangle.height);
                }
            } else if (n6 > 0) {
                gC.fillRectangle(n2 + n5, n3, n6, rectangle.height);
            }
            gC.setBackground(color);
        } else {
            gC.fillRectangle(n2, n3, n4, rectangle.height);
        }
        Rectangle rectangle2 = gC.getClipping();
        if (n5 > 0) {
            gC.setClipping(n2, n3, n5, this.fItemHeight - 1);
            string = listItem.getText();
            if (n == this.fSelectedIndex && this.fHighLightingColumn != 1) {
                if (string != null) {
                    if (this.fHighLighting) {
                        color = gC.getForeground();
                        gC.setForeground(this.fSelectionTextColor);
                    }
                    gC.drawString(string, n2 + this.getTextIndent(listItem.getLevel()), n3 + 1, true);
                    if (this.fHighLighting) {
                        gC.setForeground(color);
                    }
                }
            } else if (string != null) {
                if (listItem.isReadOnly()) {
                    color = gC.getForeground();
                    gC.setForeground(this.fGrayColor);
                }
                gC.drawString(string, n2 + this.getTextIndent(listItem.getLevel()), n3 + 1, true);
                if (listItem.isReadOnly()) {
                    gC.setForeground(color);
                }
            }
            n2 += n5;
        }
        if (n6 > 0) {
            int n7;
            gC.setClipping(n2, n3, n6, this.fItemHeight - 1);
            if (listItem.isOwnerDraw() && (n7 = listItem.getWidth()) > 0) {
                listItem.draw(gC, n2 + 2, n3, n7, this.fItemHeight - 1);
                n2 += n7 + 2;
            }
            n2 += 4;
            string = listItem.getText(1);
            if (string != null) {
                Font font = null;
                if (listItem.isBold()) {
                    font = gC.getFont();
                    gC.setFont(this.getBoldFont(gC));
                }
                if (n == this.fSelectedIndex && this.fHighLightingColumn == 1) {
                    if (this.fHighLighting) {
                        color = gC.getForeground();
                        gC.setForeground(this.fSelectionTextColor);
                    }
                    gC.drawString(string, n2, n3 + 1, true);
                    if (this.fHighLighting) {
                        gC.setForeground(color);
                    }
                } else {
                    if (listItem.isReadOnly()) {
                        color = gC.getForeground();
                        gC.setForeground(this.fGrayColor);
                    }
                    gC.drawString(string, n2, n3 + 1, true);
                    if (listItem.isReadOnly()) {
                        gC.setForeground(color);
                    }
                }
                if (listItem.isBold()) {
                    gC.setFont(font);
                }
            }
        }
        gC.setClipping(rectangle2);
    }

    protected int getIndent(int n) {
        if (n > 1) {
            return (n - 1) * 14;
        }
        return 0;
    }

    protected int getTextIndent(int n) {
        int n2 = this.getIndent(n) + 1;
        if (n <= 1) {
            n2 += 2;
        }
        return n2;
    }

    protected Font getBoldFont(GC gC) {
        if (this.fBoldFont == null) {
            this.fBoldFont = UIUtils.getFont(this.getDisplay(), gC.getFont(), 1, -1);
        }
        return this.fBoldFont;
    }

    protected void drawItems(GC gC, Rectangle rectangle) {
        int n;
        int n2 = rectangle.y + rectangle.height;
        Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y, rectangle.width, this.fItemHeight);
        if (this.fLeftColumnX == -1 && (n = (rectangle.width - 14) / 2) > 0) {
            this.fLeftColumnX = n + 14 + rectangle.x;
        }
        for (n = this.fOffset; n < this.fItemCount; ++n) {
            this.drawItem(gC, n, this.fItems[n], rectangle2);
            rectangle2.y += this.fItemHeight;
            if (rectangle2.y > n2) break;
        }
    }

    protected int getIndexAtPoint(int n, int n2) {
        Rectangle rectangle = this.getClientArea();
        int n3 = this.fOffset + (n2 - rectangle.y) / this.fItemHeight;
        if (n3 < this.fItemCount) {
            return n3;
        }
        return -1;
    }

    protected void adjustColumnPosition(boolean bl) {
        int n;
        int n2 = bl ? -3 : 3;
        Rectangle rectangle = this.getClientArea();
        int n3 = this.getAdjustColumnX(rectangle.x, rectangle.width);
        if (n3 != (n = this.getAdjustColumnX(rectangle.x, rectangle.width, n3 + n2))) {
            this.fLeftColumnX = n;
            this.redraw();
        }
    }

    protected boolean isAdjustColumnPosition(int n, int n2) {
        if (this.fItemCount == 0) {
            return false;
        }
        Rectangle rectangle = this.getClientArea();
        if (!rectangle.contains(n, n2)) {
            return false;
        }
        return Math.abs(n - this.getAdjustColumnX(rectangle.x, rectangle.width)) < 2;
    }

    protected int getAdjustColumnX(int n, int n2) {
        return this.getAdjustColumnX(n, n2, this.fLeftColumnX);
    }

    protected int getAdjustColumnX(int n, int n2, int n3) {
        return Math.max(Math.min(n3, n2 + n - 14), 14);
    }

    protected boolean isSignPosition(int n, int n2, int n3) {
        ListItem listItem = this.getItem(n);
        if (listItem != null && listItem.getItemCount() > 0) {
            Rectangle rectangle = this.getClientArea();
            int n4 = (n - this.fOffset) * this.fItemHeight + rectangle.y;
            rectangle = this.getSignRectangle(rectangle.x, n4, listItem.getLevel());
            return rectangle.contains(n2, n3);
        }
        return false;
    }

    protected Rectangle getSignRectangle(int n, int n2, int n3) {
        Rectangle rectangle = new Rectangle(0, 0, 9, 9);
        n += this.getIndent(n3);
        rectangle.x = n += (14 - rectangle.width) / 2;
        rectangle.y = n2 += (this.fItemHeight - rectangle.height) / 2;
        return rectangle;
    }

    protected void onMouseDown(Event event) {
        this.fMouseDown = true;
        this.fAdjustColumnWidth = this.isAdjustColumnPosition(event.x, event.y);
        if (this.fAdjustColumnWidth) {
            event.detail = 1;
            this.fFirstTime = true;
        } else {
            int n = this.getIndexAtPoint(event.x, event.y);
            if (n != -1) {
                if (this.isSignPosition(n, event.x, event.y)) {
                    this.switchState(n);
                }
                this.setSelection(n, true);
                this.showItem(this.fSelectedIndex);
            }
        }
    }

    protected void onMouseUp(Event event) {
        this.fMouseDown = false;
        if (this.fAdjustColumnWidth) {
            event.detail = 1;
            this.redraw();
        }
        this.fAdjustColumnWidth = false;
    }

    protected void onMouseDoubleClick(Event event) {
        ListItem listItem;
        int n;
        Rectangle rectangle = this.getClientArea();
        int n2 = this.getAdjustColumnX(rectangle.x, rectangle.width);
        if (this.isAdjustColumnPosition(event.x, event.y)) {
            event.detail = 1;
            int n3 = Math.max(0, rectangle.width - 14) / 2 + rectangle.x + 14;
            if (n3 != n2) {
                this.fLeftColumnX = n3;
                this.redraw();
            }
        } else if (event.x < n2 && (n = this.getIndexAtPoint(event.x, event.y)) != -1 && (listItem = this.getItem(n)) != null && listItem.getItemCount() > 0) {
            if (!this.isSignPosition(n, event.x, event.y)) {
                this.switchState(n);
            }
            event.detail = 1;
        }
    }

    protected void onMouseExit(Event event) {
        if (this.fNeedRestCursor) {
            this.setCursor(null);
        }
        this.fNeedRestCursor = false;
        if (this.fMouseOverIndex != -1 && this.getToolTipText() != null) {
            this.setToolTipText(null);
        }
        this.fMouseOverIndex = -1;
        this.fMouseOverColumn = -1;
    }

    protected void onMouseMove(Event event) {
        if (this.fMouseDown) {
            if (this.fAdjustColumnWidth) {
                Rectangle rectangle = this.getClientArea();
                int n = rectangle.x + 14 + 14;
                n = Math.max(event.x, n);
                if ((n = Math.min(n, rectangle.x + rectangle.width - 14)) != this.fLeftColumnX) {
                    GC gC = new GC((Drawable)this);
                    gC.setXORMode(true);
                    Color color = gC.getForeground();
                    gC.setForeground(gC.getBackground());
                    if (this.fFirstTime) {
                        this.fFirstTime = false;
                    } else {
                        gC.drawLine(this.fLeftColumnX, rectangle.y, this.fLeftColumnX, rectangle.y + rectangle.height);
                    }
                    gC.drawLine(n, rectangle.y, n, rectangle.y + rectangle.height);
                    gC.setForeground(color);
                    gC.dispose();
                    this.fLeftColumnX = n;
                }
            }
        } else if (this.isAdjustColumnPosition(event.x, event.y)) {
            this.fMouseOverColumn = -1;
            this.fNeedRestCursor = true;
            this.setCursor(this.getDisplay().getSystemCursor(9));
        } else {
            int n;
            if (this.fNeedRestCursor) {
                this.setCursor(null);
            }
            this.fNeedRestCursor = false;
            Rectangle rectangle = this.getClientArea();
            int n2 = this.getIndexAtPoint(event.x, event.y);
            int n3 = this.getAdjustColumnX(rectangle.x, rectangle.width);
            int n4 = n = event.x < n3 ? 0 : 1;
            if (n2 != this.fMouseOverIndex || this.fMouseOverColumn != n) {
                String string;
                this.fMouseOverIndex = n2;
                this.fMouseOverColumn = n;
                String string2 = null;
                ListItem listItem = null;
                if (n2 != -1) {
                    listItem = this.getItem(n2);
                }
                if (listItem != null && !listItem.isCategory() && (string = listItem.getText(this.fMouseOverColumn)) != null && string.length() > 0) {
                    GC gC = new GC((Drawable)this);
                    int n5 = gC.stringExtent((String)string).x;
                    int n6 = 0;
                    gC.dispose();
                    if (this.fMouseOverColumn == 0) {
                        n6 = n3 - rectangle.x - this.getTextIndent(listItem.getLevel()) - 14;
                    } else {
                        n6 = rectangle.width + rectangle.x - n3 - 2;
                        if (listItem.isOwnerDraw()) {
                            n6 -= listItem.getWidth() + 2;
                        }
                    }
                    if (n5 > n6) {
                        string2 = string;
                    }
                }
                if (string2 == null) {
                    if (this.getToolTipText() != null) {
                        this.setToolTipText(null);
                    }
                } else {
                    this.setToolTipText(string2);
                }
            }
        }
    }

    protected void onTraverse(Event event) {
        switch (event.detail) {
            case 8: 
            case 16: {
                event.doit = true;
            }
        }
    }

    protected void expend(int n) {
        this.switchState(n, true);
    }

    protected void collapse(int n) {
        this.switchState(n, false);
    }

    protected void switchState(int n) {
        ListItem listItem = this.getItem(n);
        if (listItem != null) {
            this.switchState(n, !listItem.isExpanded());
        }
    }

    protected void switchState(int n, boolean bl) {
        ListItem listItem = this.getItem(n);
        if (listItem != null && listItem.getItemCount() > 0 && listItem.isExpanded() != bl) {
            int n2 = this.fOffset;
            listItem.setExpanded(bl);
            this.fDirty = true;
            this.layout(true);
            if (n2 != this.fOffset) {
                this.redraw();
            } else {
                Rectangle rectangle = this.getBounds(n);
                if (rectangle == null) {
                    this.redraw();
                } else {
                    Rectangle rectangle2 = this.getClientArea();
                    this.redraw(rectangle2.x, rectangle.y, rectangle2.width, rectangle2.height + rectangle2.y - rectangle.y, false);
                }
            }
        }
    }

    protected void onKeyDown(Event event) {
        int n = this.fItemCount;
        if (n == 0) {
            return;
        }
        int n2 = this.fSelectedIndex;
        if (n2 != -1) {
            switch (event.character) {
                case '+': 
                case '=': {
                    this.expend(n2);
                    return;
                }
                case '-': 
                case '_': {
                    this.collapse(n2);
                    return;
                }
                case '\r': {
                    this.switchState(n2);
                    return;
                }
            }
        }
        switch (event.keyCode) {
            case 0x1000001: {
                n2 = Math.max(0, n2 - 1);
                this.setSelection(n2, true);
                this.showItem(this.fSelectedIndex);
                break;
            }
            case 0x1000003: {
                ListItem listItem;
                if ((event.stateMask & 0x40000) != 0) {
                    if (this.fItemCount > 0) {
                        this.adjustColumnPosition(true);
                    }
                    return;
                }
                if (n2 != -1 && (listItem = this.getItem(n2)) != null && listItem.isExpanded()) {
                    this.collapse(n2);
                    return;
                }
                n2 = Math.max(0, n2 - 1);
                this.setSelection(n2, true);
                this.showItem(this.fSelectedIndex);
                break;
            }
            case 0x1000002: {
                n2 = Math.min(n - 1, n2 + 1);
                this.setSelection(n2, true);
                this.showItem(this.fSelectedIndex);
                break;
            }
            case 0x1000004: {
                ListItem listItem;
                if ((event.stateMask & 0x40000) != 0) {
                    if (this.fItemCount > 0) {
                        this.adjustColumnPosition(false);
                    }
                    return;
                }
                if (n2 != -1 && (listItem = this.getItem(n2)) != null && listItem.getItemCount() > 0 && !listItem.isExpanded()) {
                    this.expend(n2);
                    return;
                }
                n2 = Math.min(n - 1, n2 + 1);
                this.setSelection(n2, true);
                this.showItem(this.fSelectedIndex);
                break;
            }
            case 0x1000007: {
                n2 = 0;
                this.setSelection(n2, true);
                this.showItem(this.fSelectedIndex);
                break;
            }
            case 0x1000008: {
                n2 = n - 1;
                this.setSelection(n2, true);
                this.showItem(this.fSelectedIndex);
                break;
            }
            case 0x1000005: {
                Rectangle rectangle = this.getClientArea();
                int n3 = rectangle.height / this.fItemHeight;
                n2 = Math.max(0, n2 - n3);
                this.setSelection(n2);
                n2 = this.fOffset;
                this.fOffset -= n3;
                this.layout(true);
                if (n2 == this.fOffset) break;
                this.redraw();
                break;
            }
            case 0x1000006: {
                Rectangle rectangle = this.getClientArea();
                int n4 = rectangle.height / this.fItemHeight;
                n2 = Math.min(n - 1, n2 + n4);
                this.setSelection(n2);
                n2 = this.fOffset;
                this.fOffset += n4;
                this.layout(true);
                if (n2 == this.fOffset) break;
                this.redraw();
            }
        }
    }

    protected void onResize(Event event) {
        this.layout(true);
        this.redraw();
    }

    protected void onScroll(Event event) {
        int n;
        ScrollBar scrollBar = this.getVerticalBar();
        if (scrollBar != null && scrollBar.isVisible() && this.fOffset != (n = scrollBar.getSelection())) {
            this.fOffset = n;
            this.redraw();
        }
    }

    protected void onDispose() {
        if (this.fBoldFont != null) {
            this.fBoldFont.dispose();
            this.fBoldFont = null;
        }
        this.fGridColor = null;
        this.fGrayColor = null;
        this.fSelectionColor = null;
        this.fSelectionTextColor = null;
        if (this.fRoot != null) {
            this.fRoot.removeAll();
            this.fRoot = null;
        }
        this.fItems = null;
    }

    public void layout(boolean bl) {
        if (this.needLayout() || bl) {
            this.doLayout();
            this.fLayouted = true;
        }
    }

    protected boolean needLayout() {
        return this.fDirty || !this.fLayouted;
    }

    protected void layoutItems() {
        int n;
        if (!this.fDirty) {
            return;
        }
        this.fDirty = false;
        int n2 = this.fRoot.getExpandedItemCount();
        if (n2 >= (n = this.fItems.length) || n > 256 && n > n2 * 2) {
            this.fItems = new ListItem[n2];
        } else {
            for (int i = n2; i < this.fItemCount; ++i) {
                this.fItems[i] = null;
            }
        }
        if (n2 > 0) {
            this.fRoot.fill(this.fItems, 0, 1);
        }
        this.fItemCount = n2;
    }

    protected void doLayout() {
        boolean bl;
        this.layoutItems();
        ScrollBar scrollBar = this.getVerticalBar();
        if (scrollBar == null) {
            return;
        }
        Rectangle rectangle = this.getClientArea();
        int n = this.fItemCount * this.fItemHeight;
        boolean bl2 = bl = rectangle.height < n;
        if (bl) {
            int n2 = rectangle.height / this.fItemHeight;
            int n3 = this.fItemCount - n2;
            if (this.fOffset > n3) {
                this.fOffset = n3;
            } else if (this.fOffset < 0) {
                this.fOffset = 0;
            }
            scrollBar.setValues(this.fOffset, scrollBar.getMinimum(), this.fItemCount, n2, 1, n2);
        } else {
            this.fOffset = 0;
        }
        if (bl != scrollBar.getVisible()) {
            scrollBar.setVisible(bl);
        }
    }
}

