/*
 * Decompiled with CFR 0.152.
 */
package com.spket.widget;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.swt.graphics.RGB;

public class Colors {
    public static final int V_BLACK = 0;
    public static final int V_SILVER = 0xC0C0C0;
    public static final int V_GRAY = 0x808080;
    public static final int V_WHITE = 0xFFFFFF;
    public static final int V_MAROON = 0x800000;
    public static final int V_RED = 0xFF0000;
    public static final int V_PURPLE = 0x800080;
    public static final int V_FUCHSIA = 0xFF00FF;
    public static final int V_GREEN = 32768;
    public static final int V_LIME = 65280;
    public static final int V_OLIVE = 0x808000;
    public static final int V_YELLOW = 0xFFFF00;
    public static final int V_NAVY = 128;
    public static final int V_BLUE = 255;
    public static final int V_TEAL = 32896;
    public static final int V_AQUA = 65535;
    public static final int V_DARKBLUE = 139;
    public static final int V_MEDIUMBLUE = 205;
    public static final int V_DARKGREEN = 25600;
    public static final int V_DARKCYAN = 35723;
    public static final int V_DEEPSKYBLUE = 49151;
    public static final int V_DARKTURQUOISE = 52945;
    public static final int V_MEDIUMSPRINGGREEN = 64154;
    public static final int V_SPRINGGREEN = 65407;
    public static final int V_CYAN = 65535;
    public static final int V_MIDNIGHTBLUE = 1644912;
    public static final int V_DODGERBLUE = 2003199;
    public static final int V_LIGHTSEAGREEN = 2142890;
    public static final int V_FORESTGREEN = 0x228B22;
    public static final int V_SEAGREEN = 3050327;
    public static final int V_DARKSLATEGREY = 0x2F4F4F;
    public static final int V_DARKSLATEGRAY = 0x2F4F4F;
    public static final int V_LIMEGREEN = 3329330;
    public static final int V_MEDIUMSEAGREEN = 3978097;
    public static final int V_TURQUOISE = 4251856;
    public static final int V_ROYALBLUE = 4286945;
    public static final int V_STEELBLUE = 4620980;
    public static final int V_DARKSLATEBLUE = 4734347;
    public static final int V_MEDIUMTURQUOISE = 4772300;
    public static final int V_INDIGO = 4915330;
    public static final int V_DARKOLIVEGREEN = 5597999;
    public static final int V_CADETBLUE = 6266528;
    public static final int V_CORNFLOWERBLUE = 6591981;
    public static final int V_MEDIUMAQUAMARINE = 6737322;
    public static final int V_DIMGRAY = 0x696969;
    public static final int V_DIMGREY = 0x696969;
    public static final int V_SLATEBLUE = 6970061;
    public static final int V_OLIVEDRAB = 7048739;
    public static final int V_SLATEGRAY = 7372944;
    public static final int V_SLATEGREY = 7372944;
    public static final int V_LIGHTSLATEGRAY = 0x778899;
    public static final int V_LIGHTSLATEGREY = 0x778899;
    public static final int V_MEDIUMSLATEBLUE = 8087790;
    public static final int V_LAWNGREEN = 8190976;
    public static final int V_CHARTREUSE = 0x7FFF00;
    public static final int V_AQUAMARINE = 8388564;
    public static final int V_GREY = 0x808080;
    public static final int V_SKYBLUE = 8900331;
    public static final int V_LIGHTSKYBLUE = 8900346;
    public static final int V_BLUEVIOLET = 9055202;
    public static final int V_DARKRED = 0x8B0000;
    public static final int V_DARKMAGENTA = 0x8B008B;
    public static final int V_SADDLEBROWN = 9127187;
    public static final int V_DARKSEAGREEN = 9419919;
    public static final int V_LIGHTGREEN = 0x90EE90;
    public static final int V_MEDIUMPURPLE = 9662683;
    public static final int V_DARKVIOLET = 9699539;
    public static final int V_PALEGREEN = 10025880;
    public static final int V_DARKORCHID = 10040012;
    public static final int V_YELLOWGREEN = 10145074;
    public static final int V_SIENNA = 10506797;
    public static final int V_BROWN = 0xA52A2A;
    public static final int V_DARKGRAY = 0xA9A9A9;
    public static final int V_DARKGREY = 0xA9A9A9;
    public static final int V_LIGHTBLUE = 11393254;
    public static final int V_GREENYELLOW = 11403055;
    public static final int V_PALETURQUOISE = 0xAFEEEE;
    public static final int V_LIGHTSTEELBLUE = 11584734;
    public static final int V_POWDERBLUE = 11591910;
    public static final int V_FIREBRICK = 0xB22222;
    public static final int V_DARKGOLDENROD = 12092939;
    public static final int V_MEDIUMORCHID = 12211667;
    public static final int V_ROSYBROWN = 12357519;
    public static final int V_DARKKHAKI = 12433259;
    public static final int V_MEDIUMVIOLETRED = 13047173;
    public static final int V_INDIANRED = 0xCD5C5C;
    public static final int V_PERU = 13468991;
    public static final int V_CHOCOLATE = 13789470;
    public static final int V_TAN = 13808780;
    public static final int V_LIGHTGREY = 0xD3D3D3;
    public static final int V_LIGHTGRAY = 0xD3D3D3;
    public static final int V_THISTLE = 14204888;
    public static final int V_ORCHID = 14315734;
    public static final int V_GOLDENROD = 14329120;
    public static final int V_PALEVIOLETRED = 14381203;
    public static final int V_CRIMSON = 14423100;
    public static final int V_GAINSBORO = 0xDCDCDC;
    public static final int V_PLUM = 0xDDA0DD;
    public static final int V_BURLYWOOD = 14596231;
    public static final int V_LIGHTCYAN = 0xE0FFFF;
    public static final int V_LAVENDER = 15132410;
    public static final int V_DARKSALMON = 15308410;
    public static final int V_VIOLET = 0xEE82EE;
    public static final int V_PALEGOLDENROD = 0xEEE8AA;
    public static final int V_LIGHTCORAL = 0xF08080;
    public static final int V_KHAKI = 15787660;
    public static final int V_ALICEBLUE = 0xF0F8FF;
    public static final int V_HONEYDEW = 0xF0FFF0;
    public static final int V_AZURE = 0xF0FFFF;
    public static final int V_SANDYBROWN = 16032864;
    public static final int V_WHEAT = 16113331;
    public static final int V_BEIGE = 16119260;
    public static final int V_WHITESMOKE = 0xF5F5F5;
    public static final int V_MINTCREAM = 0xF5FFFA;
    public static final int V_GHOSTWHITE = 0xF8F8FF;
    public static final int V_SALMON = 16416882;
    public static final int V_ANTIQUEWHITE = 16444375;
    public static final int V_LINEN = 16445670;
    public static final int V_LIGHTGOLDENRODYELLOW = 16448210;
    public static final int V_OLDLACE = 16643558;
    public static final int V_MAGENTA = 0xFF00FF;
    public static final int V_DEEPPINK = 16716947;
    public static final int V_ORANGERED = 16729344;
    public static final int V_TOMATO = 16737095;
    public static final int V_HOTPINK = 16738740;
    public static final int V_CORAL = 16744272;
    public static final int V_DARKORANGE = 16747520;
    public static final int V_LIGHTSALMON = 16752762;
    public static final int V_ORANGE = 16753920;
    public static final int V_LIGHTPINK = 16758465;
    public static final int V_PINK = 16761035;
    public static final int V_GOLD = 16766720;
    public static final int V_PEACHPUFF = 16767673;
    public static final int V_NAVAJOWHITE = 16768685;
    public static final int V_MOCCASIN = 16770229;
    public static final int V_BISQUE = 16770244;
    public static final int V_MISTYROSE = 16770273;
    public static final int V_BLANCHEDALMOND = 16772045;
    public static final int V_PAPAYAWHIP = 16773077;
    public static final int V_LAVENDERBLUSH = 0xFFF0F5;
    public static final int V_SEASHELL = 0xFFF5EE;
    public static final int V_CORNSILK = 16775388;
    public static final int V_LEMONCHIFFON = 16775885;
    public static final int V_FLORALWHITE = 0xFFFAF0;
    public static final int V_SNOW = 0xFFFAFA;
    public static final int V_LIGHTYELLOW = 0xFFFFE0;
    public static final int V_IVORY = 0xFFFFF0;
    private static final NamedColor[] colors = new NamedColor[]{new NamedColor("black", 0), new NamedColor("silver", 0xC0C0C0), new NamedColor("gray", 0x808080), new NamedColor("white", 0xFFFFFF), new NamedColor("maroon", 0x800000), new NamedColor("red", 0xFF0000), new NamedColor("purple", 0x800080), new NamedColor("fuchsia", 0xFF00FF), new NamedColor("green", 32768), new NamedColor("lime", 65280), new NamedColor("olive", 0x808000), new NamedColor("yellow", 0xFFFF00), new NamedColor("navy", 128), new NamedColor("blue", 255), new NamedColor("teal", 32896), new NamedColor("aqua", 65535), new NamedColor("darkblue", 139), new NamedColor("mediumblue", 205), new NamedColor("darkgreen", 25600), new NamedColor("darkcyan", 35723), new NamedColor("deepskyblue", 49151), new NamedColor("darkturquoise", 52945), new NamedColor("mediumspringgreen", 64154), new NamedColor("springgreen", 65407), new NamedColor("cyan", 65535), new NamedColor("midnightblue", 1644912), new NamedColor("dodgerblue", 2003199), new NamedColor("lightseagreen", 2142890), new NamedColor("forestgreen", 0x228B22), new NamedColor("seagreen", 3050327), new NamedColor("darkslategrey", 0x2F4F4F), new NamedColor("darkslategray", 0x2F4F4F), new NamedColor("limegreen", 3329330), new NamedColor("mediumseagreen", 3978097), new NamedColor("turquoise", 4251856), new NamedColor("royalblue", 4286945), new NamedColor("steelblue", 4620980), new NamedColor("darkslateblue", 4734347), new NamedColor("mediumturquoise", 4772300), new NamedColor("indigo", 4915330), new NamedColor("darkolivegreen", 5597999), new NamedColor("cadetblue", 6266528), new NamedColor("cornflowerblue", 6591981), new NamedColor("mediumaquamarine", 6737322), new NamedColor("dimgray", 0x696969), new NamedColor("dimgrey", 0x696969), new NamedColor("slateblue", 6970061), new NamedColor("olivedrab", 7048739), new NamedColor("slategray", 7372944), new NamedColor("slategrey", 7372944), new NamedColor("lightslategray", 0x778899), new NamedColor("lightslategrey", 0x778899), new NamedColor("mediumslateblue", 8087790), new NamedColor("lawngreen", 8190976), new NamedColor("chartreuse", 0x7FFF00), new NamedColor("aquamarine", 8388564), new NamedColor("grey", 0x808080), new NamedColor("skyblue", 8900331), new NamedColor("lightskyblue", 8900346), new NamedColor("blueviolet", 9055202), new NamedColor("darkred", 0x8B0000), new NamedColor("darkmagenta", 0x8B008B), new NamedColor("saddlebrown", 9127187), new NamedColor("darkseagreen", 9419919), new NamedColor("lightgreen", 0x90EE90), new NamedColor("mediumpurple", 9662683), new NamedColor("darkviolet", 9699539), new NamedColor("palegreen", 10025880), new NamedColor("darkorchid", 10040012), new NamedColor("yellowgreen", 10145074), new NamedColor("sienna", 10506797), new NamedColor("brown", 0xA52A2A), new NamedColor("darkgray", 0xA9A9A9), new NamedColor("darkgrey", 0xA9A9A9), new NamedColor("lightblue", 11393254), new NamedColor("greenyellow", 11403055), new NamedColor("paleturquoise", 0xAFEEEE), new NamedColor("lightsteelblue", 11584734), new NamedColor("powderblue", 11591910), new NamedColor("firebrick", 0xB22222), new NamedColor("darkgoldenrod", 12092939), new NamedColor("mediumorchid", 12211667), new NamedColor("rosybrown", 12357519), new NamedColor("darkkhaki", 12433259), new NamedColor("mediumvioletred", 13047173), new NamedColor("indianred", 0xCD5C5C), new NamedColor("peru", 13468991), new NamedColor("chocolate", 13789470), new NamedColor("tan", 13808780), new NamedColor("lightgrey", 0xD3D3D3), new NamedColor("lightgray", 0xD3D3D3), new NamedColor("thistle", 14204888), new NamedColor("orchid", 14315734), new NamedColor("goldenrod", 14329120), new NamedColor("palevioletred", 14381203), new NamedColor("crimson", 14423100), new NamedColor("gainsboro", 0xDCDCDC), new NamedColor("plum", 0xDDA0DD), new NamedColor("burlywood", 14596231), new NamedColor("lightcyan", 0xE0FFFF), new NamedColor("lavender", 15132410), new NamedColor("darksalmon", 15308410), new NamedColor("violet", 0xEE82EE), new NamedColor("palegoldenrod", 0xEEE8AA), new NamedColor("lightcoral", 0xF08080), new NamedColor("khaki", 15787660), new NamedColor("aliceblue", 0xF0F8FF), new NamedColor("honeydew", 0xF0FFF0), new NamedColor("azure", 0xF0FFFF), new NamedColor("sandybrown", 16032864), new NamedColor("wheat", 16113331), new NamedColor("beige", 16119260), new NamedColor("whitesmoke", 0xF5F5F5), new NamedColor("mintcream", 0xF5FFFA), new NamedColor("ghostwhite", 0xF8F8FF), new NamedColor("salmon", 16416882), new NamedColor("antiquewhite", 16444375), new NamedColor("linen", 16445670), new NamedColor("lightgoldenrodyellow", 16448210), new NamedColor("oldlace", 16643558), new NamedColor("magenta", 0xFF00FF), new NamedColor("deeppink", 16716947), new NamedColor("orangered", 16729344), new NamedColor("tomato", 16737095), new NamedColor("hotpink", 16738740), new NamedColor("coral", 16744272), new NamedColor("darkorange", 16747520), new NamedColor("lightsalmon", 16752762), new NamedColor("orange", 16753920), new NamedColor("lightpink", 16758465), new NamedColor("pink", 16761035), new NamedColor("gold", 16766720), new NamedColor("peachpuff", 16767673), new NamedColor("navajowhite", 16768685), new NamedColor("moccasin", 16770229), new NamedColor("bisque", 16770244), new NamedColor("mistyrose", 16770273), new NamedColor("blanchedalmond", 16772045), new NamedColor("papayawhip", 16773077), new NamedColor("lavenderblush", 0xFFF0F5), new NamedColor("seashell", 0xFFF5EE), new NamedColor("cornsilk", 16775388), new NamedColor("lemonchiffon", 16775885), new NamedColor("floralwhite", 0xFFFAF0), new NamedColor("snow", 0xFFFAFA), new NamedColor("lightyellow", 0xFFFFE0), new NamedColor("ivory", 0xFFFFF0)};
    private static final Map colorMap = new HashMap(colors.length);
    private static final Map valueMap = new HashMap(colors.length);
    private static final int COLOR_MASK = 0x1000000;
    private static final double FACTOR = 0.7;

    public static NamedColor[] getColors() {
        return colors;
    }

    public static String toHexString(int n) {
        n = 0x1000000 | n & 0xFFFFFF;
        return "#" + Integer.toHexString(n).substring(1);
    }

    public static String toHexString(RGB rGB) {
        if (rGB == null) {
            return null;
        }
        return Colors.toHexString(Colors.rgb(rGB.red, rGB.green, rGB.blue));
    }

    public static String toHexString(int n, int n2, int n3) {
        return Colors.toHexString(Colors.rgb(n, n2, n3));
    }

    public static int rgb(int n, int n2, int n3) {
        return (n & 0xFF) << 16 | (n2 & 0xFF) << 8 | n3 & 0xFF;
    }

    public static int rgb(Color color) {
        if (color != null) {
            return color.getRGB() & 0xFFFFFF;
        }
        return -1;
    }

    public static int rgb(org.eclipse.swt.graphics.Color color) {
        if (color != null) {
            return Colors.rgb(color.getRed(), color.getGreen(), color.getGreen());
        }
        return -1;
    }

    public static int rgb(RGB rGB) {
        if (rGB != null) {
            return Colors.rgb(rGB.red, rGB.green, rGB.blue);
        }
        return -1;
    }

    public static int rgb(String string) {
        int n;
        block14: {
            n = -1;
            if (string != null && string.length() > 0) {
                if (string.charAt(0) == '#') {
                    try {
                        n = Integer.parseInt(string.substring(1), 16);
                    }
                    catch (NumberFormatException numberFormatException) {
                        n = -1;
                    }
                } else {
                    NamedColor namedColor = (NamedColor)colorMap.get(string);
                    if (namedColor == null) {
                        try {
                            n = Integer.parseInt(string, 16);
                        }
                        catch (NumberFormatException numberFormatException) {
                            if (!string.startsWith("rgb")) break block14;
                            StringTokenizer stringTokenizer = new StringTokenizer(string, "(), ");
                            int n2 = 0;
                            n = 0;
                            int[] nArray = new int[]{16, 8, 0};
                            try {
                                while (stringTokenizer.hasMoreTokens()) {
                                    String string2 = stringTokenizer.nextToken();
                                    int n3 = 0;
                                    if (n2 > 0) {
                                        n3 = string2.endsWith("%") ? Integer.parseInt(string2.substring(0, string2.length() - 1)) * 255 / 100 & 0xFF : Integer.parseInt(string2) & 0xFF;
                                        n |= n3 << nArray[n2 - 1];
                                    }
                                    if (n2 <= 2) {
                                        ++n2;
                                        continue;
                                    }
                                    break;
                                }
                            }
                            catch (NumberFormatException numberFormatException2) {
                                n = -1;
                            }
                        }
                    } else {
                        n = namedColor.value;
                    }
                }
            }
        }
        return n;
    }

    public static RGB getRGB(int n) {
        if (n < 0) {
            return null;
        }
        return new RGB(n >> 16 & 0xFF, n >> 8 & 0xFF, n & 0xFF);
    }

    public static RGB getRGB(String string) {
        int n = Colors.rgb(string);
        if (n < 0) {
            return null;
        }
        return new RGB(n >> 16 & 0xFF, n >> 8 & 0xFF, n & 0xFF);
    }

    public static NamedColor getColorByIndex(int n) {
        if (n < 0 || n >= colors.length) {
            return null;
        }
        return colors[n];
    }

    public static NamedColor getColor(int n) {
        if (n != -1) {
            return (NamedColor)valueMap.get(new Integer(n));
        }
        return null;
    }

    public static NamedColor getColor(String string) {
        if (string != null) {
            int n;
            NamedColor namedColor = (NamedColor)colorMap.get(string);
            if (namedColor == null && (n = Colors.rgb(string)) != -1) {
                namedColor = (NamedColor)valueMap.get(new Integer(n));
            }
            return namedColor;
        }
        return null;
    }

    public static String getColorNameByIndex(int n) {
        if (n < 0 || n >= colors.length) {
            n = 0;
        }
        return colors[n].name;
    }

    public static int getCount() {
        return colors.length;
    }

    public static int getRGBByIndex(int n) {
        if (n < 0 || n >= colors.length) {
            n = 0;
        }
        return colors[n].value;
    }

    public static String getColorNameByValue(int n) {
        Object v = valueMap.get(new Integer(n));
        return v != null ? ((NamedColor)v).name : null;
    }

    public static String darker(String string) {
        if (string == null || string.length() == 0) {
            return Colors.getColorNameByValue(0);
        }
        int n = 0;
        NamedColor namedColor = (NamedColor)colorMap.get(string);
        if (namedColor != null) {
            n = namedColor.value;
            namedColor = (NamedColor)colorMap.get("dark" + string);
            if (namedColor != null) {
                return namedColor.name;
            }
        } else {
            try {
                n = Integer.decode(string);
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    n = Integer.valueOf(string, 16);
                }
                catch (NumberFormatException numberFormatException2) {
                    n = 0;
                }
            }
        }
        if (n > 0) {
            string = Colors.toHexString((int)((double)(n >> 16 & 0xFF) * 0.7), (int)((double)(n >> 8 & 0xFF) * 0.7), (int)((double)(n & 0xFF) * 0.7));
        }
        return string;
    }

    public static String darkerByIndex(int n) {
        if (n <= 0 || n >= colors.length) {
            return Colors.getColorNameByValue(0);
        }
        String string = colors[n].name;
        return Colors.darker(string);
    }

    public static String brighter(String string) {
        if (string == null || string.length() == 0) {
            return Colors.getColorNameByValue(0);
        }
        int n = -1;
        NamedColor namedColor = (NamedColor)colorMap.get(string = string.toLowerCase());
        if (namedColor != null) {
            n = namedColor.value;
            namedColor = (NamedColor)colorMap.get("light" + string);
            if (namedColor != null) {
                return namedColor.name;
            }
        } else {
            try {
                n = Integer.decode(string);
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    n = Integer.valueOf(string, 16);
                }
                catch (NumberFormatException numberFormatException2) {
                    n = -1;
                }
            }
        }
        if (n != -1) {
            if (n == 0) {
                string = Colors.getColorNameByValue(0xA9A9A9);
            } else {
                int n2 = n >> 16 & 0xFF;
                int n3 = n >> 8 & 0xFF;
                int n4 = n & 0xFF;
                int n5 = 3;
                if (n2 > 0 && n2 < n5) {
                    n2 = n5;
                }
                if (n3 > 0 && n3 < n5) {
                    n3 = n5;
                }
                if (n4 > 0 && n4 < n5) {
                    n4 = n5;
                }
                string = Colors.toHexString(Math.min((int)((double)n2 / 0.7), 255), Math.min((int)((double)n3 / 0.7), 255), Math.min((int)((double)n4 / 0.7), 255));
            }
        }
        return string;
    }

    public static String toString(RGB rGB) {
        if (rGB == null) {
            return null;
        }
        int n = (rGB.red & 0xFF) << 16 | (rGB.green & 0xFF) << 8 | rGB.blue & 0xFF;
        String string = Colors.getColorNameByValue(n);
        if (string == null) {
            string = Colors.toHexString(n);
        }
        return string;
    }

    public static String toString(int n) {
        String string = Colors.getColorNameByValue(n);
        if (string == null) {
            string = Colors.toHexString(n);
        }
        return string;
    }

    static {
        for (int i = 0; i < colors.length; ++i) {
            colorMap.put(colors[i].name, colors[i]);
            valueMap.put(new Integer(colors[i].value), colors[i]);
        }
    }

    public static class NamedColor {
        private String name;
        private int value;

        public NamedColor(String string, int n) {
            this.name = string;
            this.value = n;
        }

        public String getName() {
            return this.name;
        }

        public RGB getRGB() {
            return Colors.getRGB(this.value);
        }

        public int getValue() {
            return this.value;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof NamedColor) {
                NamedColor namedColor = (NamedColor)object;
                if (namedColor.value == this.value) {
                    if (this.name == namedColor.name) {
                        return true;
                    }
                    if (this.name != null) {
                        return this.name.equals(namedColor.name);
                    }
                }
            }
            return false;
        }

        public int hashCode() {
            return this.value;
        }
    }
}

