/*
 * Decompiled with CFR 0.152.
 */
package com.spket.widget;

import com.spket.widget.CItem;
import com.spket.widget.CList;
import com.spket.widget.Colors;
import com.spket.widget.Messages;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;

public class ColorList
extends CList {
    public static final Colors.NamedColor DEFAULT_ITEM = new Colors.NamedColor(null, 0);
    public static final Colors.NamedColor CUSTOM_ITEM = new Colors.NamedColor(null, 0);
    protected static final int SEPARATOR = 1;
    protected static final int SPAN_ALL = 2;
    protected static final int MIN_COLUMNS = 3;
    protected static final int ITEM_SIZE = 12;

    public ColorList(Composite composite, int n) {
        super(composite, n);
    }

    public void addDefaultItems() {
        Colors.NamedColor[] namedColorArray = Colors.getColors();
        this.ensureCapacity(namedColorArray.length + 2);
        this.setColumnCount(16);
        this.setShowToolTip(true);
        this.addDefaultItem(Messages.getString("color.auto.text"));
        this.addSeparator();
        for (int i = 0; i < namedColorArray.length; ++i) {
            this.addItem(namedColorArray[i]);
        }
        this.addSeparator();
        this.addCustomItem(Messages.getString("color.custom.text"));
    }

    public void addSeparator() {
        CItem cItem = new CItem();
        cItem.type = 1;
        this.addItem(cItem);
    }

    public void addDefaultItem(String string) {
        CItem cItem = new CItem(string);
        cItem.setData(DEFAULT_ITEM);
        cItem.type = 2;
        this.addItem(cItem);
    }

    public void addCustomItem(String string) {
        CItem cItem = new CItem(string);
        cItem.setData(CUSTOM_ITEM);
        cItem.type = 2;
        this.addItem(cItem);
    }

    public void addItem(int n) {
        CItem cItem = new CItem();
        Colors.NamedColor namedColor = new Colors.NamedColor(null, n);
        cItem.setData(namedColor);
        this.addItem(cItem);
    }

    public void addItem(Colors.NamedColor namedColor) {
        CItem cItem = new CItem();
        cItem.setData(namedColor);
        this.addItem(cItem);
    }

    public void setSelection(RGB rGB) {
        if (rGB == null) {
            this.setSelection(DEFAULT_ITEM);
        } else {
            this.setSelection(new Colors.NamedColor(null, Colors.rgb(rGB)));
        }
    }

    public void setSelection(Colors.NamedColor namedColor) {
        int n = -1;
        if (namedColor != null) {
            CItem cItem = null;
            for (int i = 0; i < this.fItemCount; ++i) {
                cItem = this.fItems[i];
                if (this.isSeparator(cItem) || cItem.getData() == null || !namedColor.equals(cItem.getData())) continue;
                n = i;
                break;
            }
        }
        if (n != this.fSelectedIndex) {
            this.setSelection(n);
        }
    }

    public Point computeSize(int n, int n2, boolean bl) {
        Point point = new Point(0, 0);
        int n3 = this.fColumnCount;
        if (n3 < 3) {
            n3 = 3;
        }
        int n4 = 18;
        int n5 = 7;
        point.x = n3 * n4;
        int n6 = 0;
        CItem cItem = null;
        CItem cItem2 = null;
        for (int i = 0; i < this.fItemCount; ++i) {
            cItem2 = cItem;
            cItem = this.fItems[i];
            if (!this.isNormal(cItem) && n6 != 0) {
                point.y = point.y + (this.isSeparator(cItem2) ? n5 : n4);
            }
            if (i >= this.fItemCount - 1) continue;
            if (this.isNormal(cItem)) {
                if (++n6 < this.fColumnCount) continue;
                n6 = 0;
                point.y += n4;
                continue;
            }
            n6 = 0;
            point.y = point.y + (this.isSeparator(cItem) ? n5 : n4);
        }
        if (cItem != null) {
            point.y = point.y + (this.isSeparator(cItem) ? n5 : n4);
        }
        point.x += 7;
        point.y += 7;
        return point;
    }

    protected void doLayout() {
        Rectangle rectangle = this.getClientArea();
        int n = 0;
        int n2 = rectangle.x + 3;
        int n3 = 18;
        int n4 = 7;
        CItem cItem = null;
        int n5 = n2;
        int n6 = rectangle.y + 3;
        int n7 = n3;
        int n8 = n3;
        for (int i = 0; i < this.fItemCount; ++i) {
            CItem cItem2 = cItem;
            cItem = this.fItems[i];
            if (!this.isNormal(cItem)) {
                n5 = n2;
                n7 = rectangle.width - 3 - 3;
                if (n != 0) {
                    n6 += this.isSeparator(cItem2) ? n4 : n3;
                }
                n8 = this.isSeparator(cItem) ? n4 : n3;
            }
            Rectangle rectangle2 = cItem.bounds;
            rectangle2.x = n5;
            rectangle2.y = n6;
            rectangle2.width = n7;
            rectangle2.height = n8;
            if (this.isNormal(cItem)) {
                if (++n < this.fColumnCount) {
                    n5 += n7;
                    continue;
                }
                n = 0;
                n5 = n2;
                n6 += n3;
                continue;
            }
            n = 0;
            n5 = n2;
            n6 += this.isSeparator(cItem) ? n4 : n3;
            n7 = n3;
            n8 = n3;
        }
    }

    protected void drawItem(GC gC, int n) {
        CItem cItem = this.getItem(n);
        if (cItem == null) {
            return;
        }
        Rectangle rectangle = cItem.bounds;
        int n2 = rectangle.x;
        int n3 = rectangle.y;
        int n4 = rectangle.width;
        int n5 = rectangle.height;
        Color color = null;
        if (this.isSeparator(cItem)) {
            this.drawSeparator(gC, n2, n3 += n5 / 2, n4, n5);
        } else if (this.isNormal(cItem)) {
            color = new Color((Device)this.getDisplay(), ((Colors.NamedColor)cItem.getData()).getRGB());
            gC.setBackground(color);
            gC.fillRectangle(n2 += 3, n3 += 3, n4 -= 7, n5 -= 7);
            gC.setBackground(this.fBgColor);
            gC.drawRectangle(n2, n3, n4, n4);
            color.dispose();
        } else {
            String string = cItem.getText();
            if (string != null) {
                Point point = gC.stringExtent(string);
                gC.drawString(string, n2 += (n4 - point.x) / 2, n3 += (n5 - point.y) / 2, true);
            }
        }
    }

    protected String calcToolTipText(int n) {
        String string = null;
        CItem cItem = this.getItem(n);
        if (cItem != null && this.isNormal(cItem)) {
            Colors.NamedColor namedColor = (Colors.NamedColor)cItem.getData();
            string = Colors.toHexString(namedColor.getValue());
            String string2 = namedColor.getName();
            if (string2 != null) {
                string = string2 + " (" + string + ")";
            }
        }
        return string;
    }

    protected int getMinimumColumns() {
        return 3;
    }

    protected boolean isSeparator(CItem cItem) {
        return (cItem.type & 1) != 0;
    }

    protected boolean isNormal(CItem cItem) {
        return (cItem.type & 3) == 0;
    }
}

