/*
 * Decompiled with CFR 0.152.
 */
package com.spket.palette;

import com.spket.palette.Palette;
import com.spket.palette.PaletteCategory;
import com.spket.palette.PaletteEntry;
import com.spket.palette.PaletteSnippet;
import com.spket.util.ImageProvider;
import com.spket.util.StringUtils;
import com.spket.util.Translator;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public class PaletteReader {
    static final String NS = "";
    private static final String T_SNIPPETS = "snippets";
    private static final String T_CATEGORY = "category";
    private static final String T_SNIPPET = "snippet";
    private static final String T_ELEMENT = "element";
    private static final String T_TEXT = "text";
    private static final String T_ATTRIBUTE = "attribute";
    private static final String A_ID = "id";
    private static final String A_REFID = "refid";
    private static final String A_NAME = "name";
    private static final String A_EMPTY = "empty";
    private static final String A_LABEL = "label";
    private static final String A_ICON = "icon";
    private static final String A_ESCAPE = "escape";
    private static final String A_DEFAULT = "default";
    private static final String A_DESC = "description";
    private static final String V_METHOD = "xml";
    private static final String V_INDENT = "yes";
    private static final String V_ENCODING = "UTF-8";

    public Palette read(InputStream inputStream, ResourceBundle resourceBundle, ImageProvider imageProvider) throws IOException {
        return this.read(new InputSource(inputStream), resourceBundle, imageProvider);
    }

    public Palette read(Reader reader, ResourceBundle resourceBundle, ImageProvider imageProvider) throws IOException {
        return this.read(new InputSource(reader), resourceBundle, imageProvider);
    }

    public Palette read(InputSource inputSource, ResourceBundle resourceBundle, ImageProvider imageProvider) throws IOException {
        XMLReader xMLReader = null;
        try {
            xMLReader = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
            PaletteHandler paletteHandler = new PaletteHandler(resourceBundle, imageProvider);
            xMLReader.setContentHandler(paletteHandler);
            xMLReader.parse(inputSource);
            return paletteHandler.getPalette();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IOException(parserConfigurationException.getMessage());
        }
        catch (SAXException sAXException) {
            Throwable throwable = sAXException.getCause();
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            if (throwable != null) {
                throw new IOException(throwable.getMessage());
            }
            throw new IOException(sAXException.getMessage());
        }
    }

    public void write(OutputStream outputStream, Palette palette) throws IOException {
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            SAXSource sAXSource = new SAXSource(new PaletteSerializer(palette), new InputSource());
            transformer.setOutputProperty("method", V_METHOD);
            transformer.setOutputProperty("indent", V_INDENT);
            transformer.transform(sAXSource, new StreamResult(outputStream));
            transformer.setOutputProperty("encoding", V_ENCODING);
        }
        catch (TransformerFactoryConfigurationError transformerFactoryConfigurationError) {
            Exception exception = transformerFactoryConfigurationError.getException();
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (exception != null) {
                throw new IOException(exception.getMessage());
            }
            throw new IOException(transformerFactoryConfigurationError.getMessage());
        }
        catch (TransformerException transformerException) {
            Throwable throwable = transformerException.getException();
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            if (throwable != null) {
                throw new IOException(throwable.getMessage());
            }
            throw new IOException(transformerException.getMessage());
        }
    }

    private static class PaletteHandler
    implements ContentHandler {
        private Palette palette;
        private PaletteCategory category;
        private PaletteSnippet snippet;
        private PaletteSnippet.Node node;
        private ImageProvider imageProvider;
        private StringBuffer content;
        private Translator translator;
        private int id;
        private Stack nodes = new Stack();

        public PaletteHandler(ResourceBundle resourceBundle, ImageProvider imageProvider) {
            this.imageProvider = imageProvider;
            this.translator = new Translator(resourceBundle);
        }

        public Palette getPalette() {
            return this.palette;
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (this.content != null) {
                this.content.append(cArray, n, n2);
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if (PaletteReader.T_TEXT.equals(string3)) {
                if (this.content.length() > 0) {
                    this.node.appendContent(this.translator.translate(this.content.toString()));
                }
                this.content = null;
            }
            if (PaletteReader.T_ELEMENT.equals(string3) || PaletteReader.T_TEXT.equals(string3)) {
                this.node = this.nodes.isEmpty() ? null : (PaletteSnippet.Node)this.nodes.pop();
            }
        }

        public void startDocument() throws SAXException {
            this.id = 0;
            this.content = null;
            this.category = null;
            this.snippet = null;
            this.node = null;
            this.palette = new Palette();
            this.nodes.clear();
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (PaletteReader.T_CATEGORY.equals(string3)) {
                this.category = new PaletteCategory();
                this.palette.addCategory(this.category);
                this.readEntry(this.category, attributes);
            } else if (PaletteReader.T_SNIPPET.equals(string3)) {
                if (this.category == null) {
                    throw new SAXException("snippet should not in this place!");
                }
                this.snippet = new PaletteSnippet();
                this.readEntry(this.snippet, attributes);
                this.snippet.setId(StringUtils.makeNullIfEmpty((String)attributes.getValue(PaletteReader.A_ID)));
                if (this.snippet.getId() != null) {
                    this.palette.put(this.snippet.getId(), this.snippet);
                }
                this.category.addSnippet(this.snippet);
            } else if (PaletteReader.T_ATTRIBUTE.equals(string3)) {
                if (this.node == null) {
                    throw new SAXException("attribute should not in this place!");
                }
                String string4 = StringUtils.makeNullIfEmpty((String)attributes.getValue(PaletteReader.A_NAME));
                if (string4 == null) {
                    throw new SAXException("name is required!");
                }
                this.node.addAttribute(this.id++, string4, attributes.getValue(PaletteReader.A_DEFAULT), attributes.getValue(PaletteReader.A_DESC));
            } else if (PaletteReader.T_ELEMENT.equals(string3)) {
                if (this.snippet == null && this.node == null) {
                    throw new SAXException("wrong place!");
                }
                String string5 = StringUtils.makeNullIfEmpty((String)attributes.getValue(PaletteReader.A_NAME));
                boolean bl = StringUtils.toBoolean((String)attributes.getValue(PaletteReader.A_EMPTY));
                PaletteSnippet.Element element = new PaletteSnippet.Element(string5);
                element.setEmptyTag(bl);
                element.setRefId(StringUtils.makeNullIfEmpty((String)attributes.getValue(PaletteReader.A_REFID)));
                if (this.node != null) {
                    this.node.addChild(element);
                    this.nodes.push(this.node);
                } else {
                    this.snippet.setNode(element);
                }
                this.node = element;
            } else if (PaletteReader.T_TEXT.equals(string3)) {
                if (this.snippet == null && this.node == null) {
                    throw new SAXException("wrong place!");
                }
                PaletteSnippet.Text text = new PaletteSnippet.Text();
                text.setEscape(StringUtils.toBoolean((String)attributes.getValue(PaletteReader.A_ESCAPE), (boolean)false));
                if (this.node != null) {
                    this.node.addChild(text);
                    this.nodes.push(this.node);
                } else {
                    this.snippet.setNode(text);
                }
                this.node = text;
                this.content = new StringBuffer();
            }
        }

        private void readEntry(PaletteEntry paletteEntry, Attributes attributes) throws SAXException {
            String string = this.translator.translate(attributes.getValue(PaletteReader.A_LABEL));
            if (string == null) {
                throw new SAXException("label is missing");
            }
            paletteEntry.setLabel(string);
            String string2 = attributes.getValue(PaletteReader.A_ICON);
            if (string2 != null) {
                paletteEntry.setIconURL(string2);
                if (this.imageProvider != null) {
                    paletteEntry.setIcon(this.imageProvider.getImage(string2));
                }
            }
            paletteEntry.setDescription(this.translator.translate(attributes.getValue(PaletteReader.A_DESC)));
        }

        public void endDocument() throws SAXException {
        }

        public void endPrefixMapping(String string) throws SAXException {
        }

        public void startPrefixMapping(String string, String string2) throws SAXException {
        }

        public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        }

        public void processingInstruction(String string, String string2) throws SAXException {
        }

        public void setDocumentLocator(Locator locator) {
        }

        public void skippedEntity(String string) throws SAXException {
        }
    }

    private static class PaletteSerializer
    implements XMLReader {
        private Palette palette;
        private ContentHandler handler;
        private AttributesImpl atts = new AttributesImpl();

        public PaletteSerializer(Palette palette) {
            this.palette = palette;
        }

        public ContentHandler getContentHandler() {
            return this.handler;
        }

        public void setContentHandler(ContentHandler contentHandler) {
            this.handler = contentHandler;
        }

        public void parse(String string) throws IOException, SAXException {
            this.serialize();
        }

        public void parse(InputSource inputSource) throws IOException, SAXException {
            this.serialize();
        }

        protected void serialize() throws SAXException {
            this.handler.startDocument();
            this.handler.startElement(PaletteReader.NS, PaletteReader.T_SNIPPETS, PaletteReader.T_SNIPPETS, this.atts);
            List list = this.palette.getCategories();
            if (list.size() > 0) {
                for (int i = 0; i < list.size(); ++i) {
                    PaletteCategory paletteCategory = (PaletteCategory)list.get(i);
                    this.atts.clear();
                    this.setEntry(paletteCategory);
                    this.handler.startElement(PaletteReader.NS, PaletteReader.T_CATEGORY, PaletteReader.T_CATEGORY, this.atts);
                    Iterator iterator = paletteCategory.getSnippets().iterator();
                    while (iterator.hasNext()) {
                        this.processSnippet((PaletteSnippet)iterator.next());
                    }
                    this.handler.endElement(PaletteReader.NS, PaletteReader.T_CATEGORY, PaletteReader.T_CATEGORY);
                }
            }
            this.handler.endElement(PaletteReader.NS, PaletteReader.T_SNIPPETS, PaletteReader.T_SNIPPETS);
            this.handler.endDocument();
        }

        protected void setEntry(PaletteEntry paletteEntry) {
            this.atts.addAttribute(PaletteReader.NS, PaletteReader.A_LABEL, PaletteReader.A_LABEL, null, paletteEntry.getLabel());
            if (paletteEntry.getDescription() != null) {
                this.atts.addAttribute(PaletteReader.NS, PaletteReader.A_DESC, PaletteReader.A_DESC, null, paletteEntry.getDescription());
            }
            if (paletteEntry.getIconURL() != null) {
                this.atts.addAttribute(PaletteReader.NS, PaletteReader.A_ICON, PaletteReader.A_ICON, null, paletteEntry.getIconURL());
            }
        }

        protected void processSnippet(PaletteSnippet paletteSnippet) throws SAXException {
            this.atts.clear();
            this.setEntry(paletteSnippet);
            if (paletteSnippet.getId() != null) {
                this.atts.addAttribute(PaletteReader.NS, PaletteReader.A_ID, PaletteReader.A_ID, null, paletteSnippet.getId());
            }
            this.handler.startElement(PaletteReader.NS, PaletteReader.T_SNIPPET, PaletteReader.T_SNIPPET, this.atts);
            if (paletteSnippet.getNode() != null) {
                this.process(paletteSnippet.getNode());
            }
            this.handler.endElement(PaletteReader.NS, PaletteReader.T_SNIPPET, PaletteReader.T_SNIPPET);
        }

        protected void process(PaletteSnippet.Node node) throws SAXException {
            int n = node.getType();
            if (1 != n && 2 == n) {
                this.atts.clear();
                PaletteSnippet.Text text = (PaletteSnippet.Text)node;
                if (text.isEscape()) {
                    this.atts.addAttribute(PaletteReader.NS, PaletteReader.A_ESCAPE, PaletteReader.A_ESCAPE, null, Boolean.TRUE.toString());
                }
                this.handler.startElement(PaletteReader.NS, PaletteReader.T_TEXT, PaletteReader.T_TEXT, this.atts);
                String string = text.getContent();
                if (string != null) {
                    this.handler.characters(string.toCharArray(), 0, string.length());
                }
                this.handler.endElement(PaletteReader.NS, PaletteReader.T_TEXT, PaletteReader.T_TEXT);
            }
        }

        public DTDHandler getDTDHandler() {
            return null;
        }

        public EntityResolver getEntityResolver() {
            return null;
        }

        public ErrorHandler getErrorHandler() {
            return null;
        }

        public boolean getFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
            return false;
        }

        public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
            return null;
        }

        public void setDTDHandler(DTDHandler dTDHandler) {
        }

        public void setEntityResolver(EntityResolver entityResolver) {
        }

        public void setErrorHandler(ErrorHandler errorHandler) {
        }

        public void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        }

        public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        }
    }
}

