/*
 * Decompiled with CFR 0.152.
 */
package com.spket.ui.theme;

import com.spket.ui.theme.TabbedPaneEvent;
import com.spket.ui.theme.TabbedPaneListener;
import com.spket.widget.CItem;
import com.spket.widget.UIUtils;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.presentations.util.IPresentablePartList;
import org.eclipse.ui.presentations.IPresentablePart;
import org.eclipse.ui.themes.ITheme;

public class TabbedPane
extends Composite
implements IPresentablePartList {
    public static final int CLOSE = 1;
    public static final int DROPMENU = 2;
    protected static final int SIGN_SIZE = 7;
    protected static final int BUTTON_GAP = 4;
    protected static final int BUTTON_SIZE = 12;
    protected static final int IMAGE_SIZE = 16;
    protected static final int MIN_TAB_WIDTH = 3;
    protected static final CItem[] EMPTY_ITEMS = new CItem[0];
    protected static final int F_PAST_THRESHOLD = 1;
    protected static final int F_MOUSE_DOWN = 2;
    protected static final int F_SHELL_ACTIVED = 4;
    protected static final int F_DIRTY = 8;
    private int tabHeight;
    private int titleHeight;
    private Color titleColor;
    private Color titleBgStart;
    private Color titleBgEnd;
    private Color titleInActiveColor;
    private Color titleInActiveBgStart;
    private Color titleInActiveBgEnd;
    protected Color borderColor;
    protected Color borderDarkColor;
    protected Color borderLightColor;
    protected Color tabBackgroundColor;
    protected int tabPosition;
    protected boolean showTitle;
    private int fMouseOverIndex = -1;
    private int fMouseDownIndex = -1;
    private Point fMousePoint = new Point(0, 0);
    protected CItem[] tabs;
    protected CItem[] buttons = EMPTY_ITEMS;
    protected IPresentablePart current;
    protected List parts = new ArrayList(4);
    private List listeners = new ArrayList(1);
    private int flags;
    private int state = 2;
    private int activeState = 0;
    private IPropertyListener partPropertyChangeListener = new IPropertyListener(){

        public void propertyChanged(Object object, int n) {
            if (object instanceof IPresentablePart) {
                TabbedPane.this.onPropertyChanged((IPresentablePart)object, n);
            }
        }
    };
    private Listener shellListener = new Listener(){

        public void handleEvent(Event event) {
            TabbedPane.this.shellActive(event.type == 26);
        }
    };

    public TabbedPane(Composite composite, int n) {
        super(composite, n | 0x40000 | 0x100000);
        this.setLayout(new PaneLayout());
        this.showTitle = true;
        this.tabPosition = 1024;
        this.setFlag(8, true);
        this.setFlag(4, this.getDisplay().getActiveShell() == this.getShell());
        this.updateTheme(false);
        this.addListeners();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.resetHeight(true);
    }

    protected int getButtonIndex(int n, int n2) {
        for (int i = 0; i < this.buttons.length; ++i) {
            Rectangle rectangle = this.buttons[i].getBounds(false);
            if (!rectangle.contains(n, n2)) continue;
            return i;
        }
        return -1;
    }

    protected int getTabIndex(int n, int n2) {
        if (this.isTabVisible() && !this.isDisposed()) {
            if (this.tabs == null) {
                GC gC = new GC((Drawable)this);
                this.doLayout(gC);
                gC.dispose();
            }
            for (int i = 0; i < this.tabs.length; ++i) {
                Rectangle rectangle = this.tabs[i].getBounds(false);
                if (!rectangle.contains(n, n2)) continue;
                return i;
            }
        }
        return -1;
    }

    protected Rectangle getTabBounds(int n) {
        if (n < 0 || this.tabs == null || n >= this.tabs.length) {
            return null;
        }
        return this.tabs[n].getBounds(true);
    }

    public Rectangle getTabBounds(int n, int n2) {
        return this.getTabBounds(this.getTabIndex(n, n2));
    }

    public int getTabPosition() {
        return this.tabPosition;
    }

    public void setTabPosition(int n) {
        if (this.tabPosition == n) {
            return;
        }
        this.tabPosition = n;
        this.revalidate();
    }

    public void setSelection(int n) {
        if (n < 0 || n >= this.parts.size()) {
            return;
        }
        IPresentablePart iPresentablePart = this.getPart(n);
        if (iPresentablePart == this.current) {
            this.showPart(iPresentablePart);
        } else {
            this.select(iPresentablePart);
        }
    }

    protected void setSelection(int n, boolean bl) {
        int n2 = -1;
        if (this.current != null) {
            n2 = this.parts.indexOf(this.current);
        }
        this.setSelection(n);
        if (bl && n != n2 && n != -1) {
            IPresentablePart iPresentablePart = this.getPart(n);
            this.fireEvent(8, iPresentablePart);
        }
    }

    public IPresentablePart getPart(int n) {
        if (n >= 0 && n < this.parts.size()) {
            return (IPresentablePart)this.parts.get(n);
        }
        return null;
    }

    public IPresentablePart[] getPartList() {
        IPresentablePart[] iPresentablePartArray = new IPresentablePart[this.parts.size()];
        this.parts.toArray(iPresentablePartArray);
        return iPresentablePartArray;
    }

    public Point getPaneMenuLocation() {
        Point point = new Point(0, 0);
        for (int i = 0; i < this.buttons.length; ++i) {
            if (this.buttons[i].getType() != 2) continue;
            Rectangle rectangle = this.buttons[i].getBounds(false);
            point.x = rectangle.x;
            point.y = rectangle.y + rectangle.height + 1;
            break;
        }
        return this.toDisplay(point);
    }

    public Point getSystemMenuLocation() {
        Rectangle rectangle = this.getPartArea();
        return this.toDisplay(new Point(rectangle.x, rectangle.y));
    }

    public void addListener(TabbedPaneListener tabbedPaneListener) {
        this.listeners.add(tabbedPaneListener);
    }

    public void removeListener(TabbedPaneListener tabbedPaneListener) {
        this.listeners.remove(tabbedPaneListener);
    }

    protected void fireEvent(int n) {
        this.fireEvent(new TabbedPaneEvent(n));
    }

    protected void fireEvent(int n, IPresentablePart iPresentablePart) {
        this.fireEvent(new TabbedPaneEvent(n, iPresentablePart, 0, 0));
    }

    protected void fireEvent(int n, IPresentablePart iPresentablePart, int n2, int n3) {
        this.fireEvent(new TabbedPaneEvent(n, iPresentablePart, n2, n3));
    }

    protected final void fireEvent(TabbedPaneEvent tabbedPaneEvent) {
        if (this.listeners.size() > 0) {
            TabbedPaneListener[] tabbedPaneListenerArray = new TabbedPaneListener[this.listeners.size()];
            this.listeners.toArray(tabbedPaneListenerArray);
            for (int i = 0; i < tabbedPaneListenerArray.length; ++i) {
                tabbedPaneListenerArray[i].handleEvent(tabbedPaneEvent);
            }
        }
    }

    public void add(IPresentablePart iPresentablePart) {
        this.insert(iPresentablePart, this.size());
    }

    public void insert(IPresentablePart iPresentablePart, int n) {
        n = Math.min(n, this.size());
        iPresentablePart.addPropertyListener(this.partPropertyChangeListener);
        this.parts.add(n, iPresentablePart);
        this.revalidate();
    }

    public void move(IPresentablePart iPresentablePart, int n) {
        int n2 = this.parts.indexOf(iPresentablePart);
        if (n == n2) {
            return;
        }
        if (n2 != -1) {
            this.remove(iPresentablePart);
        }
        this.insert(iPresentablePart, n);
        if (this.current == iPresentablePart) {
            this.showPart(this.current);
        }
    }

    public void remove(IPresentablePart iPresentablePart) {
        if (iPresentablePart == this.current) {
            this.select(null);
        }
        this.parts.remove(iPresentablePart);
        iPresentablePart.removePropertyListener(this.partPropertyChangeListener);
        this.revalidate();
    }

    public void select(IPresentablePart iPresentablePart) {
        if (iPresentablePart != null) {
            iPresentablePart.setVisible(true);
        }
        if (iPresentablePart == this.current) {
            if (iPresentablePart != null) {
                Control control = iPresentablePart.getControl();
                if (control == null) {
                    return;
                }
                if (control.isDisposed() || control.isVisible()) {
                    return;
                }
            }
            this.showPart(this.current);
            this.redraw();
        } else {
            if (this.current != null) {
                this.current.setVisible(false);
            }
            this.current = iPresentablePart;
            this.resetButtons();
            this.revalidate();
        }
    }

    public int size() {
        return this.parts.size();
    }

    public void setState(int n) {
        if (this.state == n) {
            return;
        }
        this.state = n;
    }

    public void setActive(int n) {
        if (this.activeState == n) {
            return;
        }
        this.activeState = n;
        this.redrawTitle();
    }

    protected Rectangle getPartArea() {
        Rectangle rectangle = this.getClientArea();
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        if (this.tabPosition != 128 && this.showTitle) {
            n2 += this.getTitleHeight();
        }
        if (this.showTitle) {
            n4 -= this.getTitleHeight();
        }
        if (this.isTabVisible()) {
            if (this.tabPosition == 128) {
                n2 += this.getTabHeight();
            }
            n4 -= this.getTabHeight();
        }
        if (n3 < 0) {
            n3 = 0;
        }
        if (n4 < 0) {
            n4 = 0;
        }
        return new Rectangle(n, n2, n3, n4);
    }

    protected boolean alwaysShowTab() {
        return false;
    }

    public boolean isTabVisible() {
        int n = this.parts.size();
        return n > 0 && (this.alwaysShowTab() || n > 1);
    }

    protected void resetHeight(boolean bl) {
        int n = this.tabHeight;
        GC gC = new GC((Drawable)this);
        Point point = gC.stringExtent("gM");
        gC.dispose();
        this.titleHeight = Math.max(12, point.y) + 5;
        this.tabHeight = Math.max(this.titleHeight, 18) + 5;
        if (bl) {
            if (this.tabHeight == n) {
                this.redraw();
            } else {
                this.revalidate();
            }
        }
    }

    protected void updateTheme(boolean bl) {
        this.disposeResources();
        Display display = this.getDisplay();
        ITheme iTheme = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme();
        ColorRegistry colorRegistry = iTheme.getColorRegistry();
        this.titleColor = colorRegistry.get("org.eclipse.ui.workbench.ACTIVE_TAB_TEXT_COLOR");
        this.titleBgStart = colorRegistry.get("org.eclipse.ui.workbench.ACTIVE_TAB_BG_START");
        this.titleBgEnd = colorRegistry.get("org.eclipse.ui.workbench.ACTIVE_TAB_BG_END");
        this.titleInActiveColor = colorRegistry.get("org.eclipse.ui.workbench.INACTIVE_TAB_TEXT_COLOR");
        this.titleInActiveBgStart = colorRegistry.get("org.eclipse.ui.workbench.INACTIVE_TAB_BG_START");
        this.titleInActiveBgEnd = colorRegistry.get("org.eclipse.ui.workbench.INACTIVE_TAB_BG_END");
        this.borderColor = display.getSystemColor(18);
        this.borderDarkColor = display.getSystemColor(17);
        this.borderLightColor = display.getSystemColor(20);
        this.tabBackgroundColor = new Color((Device)display, UIUtils.getLighterColor(display.getSystemColor(19), 0.5));
        this.resetHeight(bl);
    }

    protected void redrawTitle() {
        if (this.showTitle && !this.isDisposed()) {
            Rectangle rectangle = this.getClientArea();
            int n = rectangle.y;
            int n2 = this.getTitleHeight();
            if (this.tabPosition == 128) {
                n = rectangle.y + rectangle.height - n2 - 2;
                ++n2;
            }
            this.redraw(rectangle.x, n, rectangle.width, n2, false);
        }
    }

    protected void setMouseOverIndex(int n) {
        if (this.fMouseOverIndex != n) {
            int n2 = this.fMouseOverIndex;
            this.fMouseOverIndex = n;
            this.redrawButtons(n2, this.fMouseOverIndex);
        }
    }

    protected void setMouseDownIndex(int n) {
        if (this.fMouseDownIndex != n) {
            int n2 = this.fMouseDownIndex;
            this.fMouseDownIndex = n;
            this.redrawButtons(n2, this.fMouseDownIndex);
        }
    }

    protected void redrawButtons(int n, int n2) {
        if (this.buttons.length == 0) {
            return;
        }
        Rectangle rectangle = this.getClientArea();
        if (rectangle.width <= 0 || rectangle.height <= 0) {
            return;
        }
        Rectangle rectangle2 = null;
        if (n != -1) {
            rectangle2 = this.buttons[n].getBounds(true);
        }
        if (n2 != -1) {
            rectangle2 = rectangle2 == null ? this.buttons[n2].getBounds(true) : UIUtils.union(this.buttons[n2].getBounds(false), rectangle2);
        }
        if (rectangle2 != null) {
            UIUtils.expand(rectangle2, 2, 2);
            rectangle2.intersect(rectangle);
            this.redraw(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, false);
        }
    }

    protected void revalidate() {
        this.tabs = null;
        this.setFlag(8, true);
        if (!this.isDisposed()) {
            this.layout(true);
            this.redraw();
        }
    }

    protected int getTabHeight() {
        return this.tabHeight;
    }

    protected int getTitleHeight() {
        return this.titleHeight;
    }

    protected void showPart(IPresentablePart iPresentablePart) {
        Control control;
        if (iPresentablePart == null) {
            return;
        }
        boolean bl = false;
        Rectangle rectangle = this.getPartArea();
        Control control2 = iPresentablePart.getToolBar();
        if (UIUtils.okToUse((Widget)control2)) {
            control = control2.computeSize(rectangle.width, -1);
            if (control.y > rectangle.height) {
                control2.setBounds(0, 0, 0, 0);
                rectangle.height = 0;
            } else {
                bl = true;
                Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y, rectangle.width, control.y);
                rectangle2 = Geometry.toDisplay((Control)this, (Rectangle)rectangle2);
                rectangle2 = Geometry.toControl((Control)control2.getParent(), (Rectangle)rectangle2);
                control2.setBounds(rectangle2);
                rectangle.y += control.y;
                rectangle.height -= control.y;
                if (rectangle.height < 0) {
                    rectangle.height = 0;
                }
            }
        }
        if (UIUtils.okToUse((Widget)(control = iPresentablePart.getControl()))) {
            rectangle = Geometry.toDisplay((Control)this, (Rectangle)rectangle);
            rectangle = Geometry.toControl((Control)control.getParent(), (Rectangle)rectangle);
            ++rectangle.x;
            rectangle.width -= 2;
            if (bl) {
                ++rectangle.y;
                rectangle.height -= 3;
            } else {
                rectangle.y += 2;
                rectangle.height -= 4;
            }
            if (rectangle.width < 0) {
                rectangle.width = 0;
            }
            if (rectangle.height < 0) {
                rectangle.height = 0;
            }
            iPresentablePart.setBounds(rectangle);
        }
    }

    protected void addListeners() {
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 9: {
                        TabbedPane.this.onPaint(event);
                        break;
                    }
                    case 5: {
                        TabbedPane.this.onMouseMove(event);
                        break;
                    }
                    case 3: {
                        TabbedPane.this.onMouseDown(event);
                        break;
                    }
                    case 4: {
                        TabbedPane.this.onMouseUp(event);
                        break;
                    }
                    case 7: {
                        TabbedPane.this.onMouseExit(event);
                        break;
                    }
                    case 8: {
                        TabbedPane.this.onMouseDoubleClick(event);
                        break;
                    }
                    case 11: {
                        TabbedPane.this.onResize(event);
                        break;
                    }
                    case 10: {
                        TabbedPane.this.onMove(event);
                        break;
                    }
                    case 35: {
                        TabbedPane.this.onMenuDetect(event);
                        break;
                    }
                    case 27: {
                        TabbedPane.this.onDeactivate(event);
                        break;
                    }
                    case 12: {
                        TabbedPane.this.onDispose();
                    }
                }
            }
        };
        this.addListener(9, listener);
        this.addListener(5, listener);
        this.addListener(3, listener);
        this.addListener(4, listener);
        this.addListener(7, listener);
        this.addListener(8, listener);
        this.addListener(11, listener);
        this.addListener(10, listener);
        this.addListener(35, listener);
        this.addListener(27, listener);
        this.addListener(12, listener);
        Shell shell = this.getShell();
        shell.addListener(26, this.shellListener);
        shell.addListener(27, this.shellListener);
    }

    protected void onMouseDown(Event event) {
        this.setFlag(1, false);
        if (UIUtils.isLeftMouseButton(event)) {
            this.setFlag(2, true);
        }
        this.fMousePoint.x = event.x;
        this.fMousePoint.y = event.y;
        int n = this.getButtonIndex(event.x, event.y);
        this.setMouseDownIndex(n);
        this.setMouseOverIndex(n);
        if (n == -1) {
            n = this.getTabIndex(event.x, event.y);
            if (n != -1) {
                this.setSelection(n, true);
            }
            this.fireEvent(9);
        }
    }

    protected void onMouseUp(Event event) {
        this.setFlag(2, false);
        int n = this.fMouseDownIndex;
        this.setMouseDownIndex(-1);
        this.setMouseOverIndex(this.getButtonIndex(event.x, event.y));
        if (n != -1 && n == this.fMouseOverIndex && UIUtils.isLeftMouseButton(event)) {
            CItem cItem = this.buttons[n];
            switch (cItem.getType()) {
                case 2: {
                    this.onMenuButtonClicked(event);
                    break;
                }
                case 1: {
                    this.onCloseButtonClicked(event);
                }
            }
        }
    }

    protected void onMenuButtonClicked(Event event) {
        Point point = this.getPaneMenuLocation();
        this.fireEvent(1, this.current, point.x, point.y);
    }

    protected void onCloseButtonClicked(Event event) {
        if (this.current != null) {
            this.fireEvent(6, this.current);
        }
    }

    protected void onMouseMove(Event event) {
        int n = event.x;
        int n2 = event.y;
        this.setMouseOverIndex(this.getButtonIndex(n, n2));
        if (this.getFlag(2)) {
            if (this.fMouseDownIndex == -1) {
                boolean bl = this.getFlag(1);
                if (this.movedPastThreshold(n, n2) && !bl) {
                    IPresentablePart iPresentablePart = this.getPart(this.getTabIndex(this.fMousePoint.x, this.fMousePoint.y));
                    Point point = this.toDisplay(this.fMousePoint);
                    this.fireEvent(10, iPresentablePart, point.x, point.y);
                }
            }
        } else {
            String string;
            String string2 = this.getToolTipText();
            if (!(string2 == (string = this.getToolTipAt(event.x, event.y)) || string2 != null && string != null && string2.equals(string))) {
                this.setToolTipText(string);
            }
        }
    }

    protected void onMouseExit(Event event) {
        this.setMouseDownIndex(-1);
        this.setMouseOverIndex(-1);
    }

    protected void onMouseDoubleClick(Event event) {
        this.setMouseOverIndex(this.getButtonIndex(event.x, event.y));
        if (this.fMouseOverIndex == -1) {
            this.setFlag(2, false);
            this.fireEvent(4);
        }
    }

    protected boolean movedPastThreshold(int n, int n2) {
        if (this.getFlag(1)) {
            return true;
        }
        int n3 = this.fMousePoint.x - n;
        int n4 = this.fMousePoint.y - n2;
        if (Math.sqrt(n3 * n3 + n4 * n4) > 5.0) {
            this.setFlag(1, true);
            return true;
        }
        return false;
    }

    protected void onMenuDetect(Event event) {
        Point point = this.toControl(event.x, event.y);
        IPresentablePart iPresentablePart = this.getPart(this.getTabIndex(point.x, point.y));
        this.fireEvent(12, iPresentablePart, event.x, event.y);
    }

    protected void onDeactivate(Event event) {
        this.setMouseDownIndex(-1);
        this.setMouseOverIndex(-1);
    }

    protected void onMove(Event event) {
        this.showPart(this.current);
    }

    protected void onResize(Event event) {
        this.tabs = null;
        this.setFlag(8, true);
        this.redraw();
    }

    protected String getTitle() {
        return this.current != null ? this.current.getTitle() : "";
    }

    protected String getToolTipAt(int n, int n2) {
        int n3 = this.getButtonIndex(n, n2);
        if (n3 != -1) {
            return this.buttons[n3].getText();
        }
        n3 = this.getTabIndex(n, n2);
        IPresentablePart iPresentablePart = this.getPart(n3);
        if (iPresentablePart != null) {
            String string = iPresentablePart.getTitleToolTip();
            if (string == null || string.length() == 0) {
                string = this.tabs != null && this.tabs[n3].getType() != 0 ? iPresentablePart.getName() : null;
            }
            return string;
        }
        return null;
    }

    protected void disposeResources() {
        if (this.tabBackgroundColor != null) {
            this.tabBackgroundColor.dispose();
            this.tabBackgroundColor = null;
        }
    }

    protected void onDispose() {
        Object object;
        if (this.listeners != null) {
            this.listeners.clear();
        }
        if (this.shellListener != null) {
            object = this.getShell();
            if (UIUtils.okToUse((Widget)object)) {
                object.removeListener(26, this.shellListener);
                object.removeListener(27, this.shellListener);
            }
            this.shellListener = null;
        }
        if (this.parts.size() > 0) {
            object = this.parts.iterator();
            while (object.hasNext()) {
                IPresentablePart iPresentablePart = (IPresentablePart)object.next();
                iPresentablePart.removePropertyListener(this.partPropertyChangeListener);
            }
            this.parts.clear();
        }
        this.disposeResources();
        this.tabs = null;
        this.buttons = null;
    }

    protected void onPropertyChanged(IPresentablePart iPresentablePart, int n) {
        if (iPresentablePart != this.current) {
            return;
        }
        if (n == 770) {
            this.resetButtons();
        }
        this.revalidate();
    }

    protected void onPaint(Event event) {
        Rectangle rectangle = this.getClientArea();
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        if (rectangle.width <= 0 || rectangle.height <= 0) {
            return;
        }
        GC gC = event.gc;
        this.doLayout(gC);
        Color color = gC.getForeground();
        if (this.parts.size() > 0) {
            Color color2 = gC.getBackground();
            if (this.showTitle) {
                if (this.tabPosition == 128) {
                    n2 = n2 + n4 - this.getTitleHeight();
                }
                this.paintTitle(gC, n, n2, n3, this.getTitleHeight());
            }
            if (this.isTabVisible()) {
                n2 = this.tabPosition == 128 ? rectangle.y : rectangle.y + n4 - this.getTabHeight();
                this.paintTabs(gC, n, n2, n3, this.getTabHeight(), color2, color);
            }
            gC.setBackground(color2);
            rectangle = this.getPartArea();
            boolean bl = false;
            if (rectangle.width > 0 && rectangle.height > 0) {
                Control control;
                gC.fillRectangle(rectangle);
                if (this.current != null && UIUtils.okToUse((Widget)(control = this.current.getToolBar()))) {
                    Point point = control.getSize();
                    if (point.y < rectangle.height) {
                        bl = true;
                        rectangle.y += point.y;
                        rectangle.height -= point.y;
                    }
                }
                if (!bl) {
                    ++rectangle.y;
                    --rectangle.height;
                }
                if (rectangle.width > 1 && rectangle.height > 2) {
                    gC.setForeground(this.borderColor);
                    gC.drawRectangle(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 2);
                }
            }
            this.paintButtons(gC, n, n4);
        } else {
            this.drawEmptyArea(gC, n, n2, n3, n4);
        }
        gC.setForeground(color);
    }

    protected void drawEmptyArea(GC gC, int n, int n2, int n3, int n4) {
        gC.fillRectangle(n, n2, n3, n4);
        if (n3 > 1 && n4 > 1) {
            gC.setForeground(this.borderColor);
            gC.drawRectangle(n, n2, n3 - 1, n4 - 1);
        }
    }

    protected boolean isFocused() {
        return this.activeState == 1 && this.getFlag(4);
    }

    protected boolean getFlag(int n) {
        return (this.flags & n) != 0;
    }

    protected void setFlag(int n, boolean bl) {
        this.flags = bl ? (this.flags |= n) : (this.flags &= ~n);
    }

    protected void shellActive(boolean bl) {
        if (this.getFlag(4) != bl) {
            this.setFlag(4, bl);
            if (!this.isDisposed()) {
                this.redraw();
            }
        }
    }

    protected void paintTitle(GC gC, int n, int n2, int n3, int n4) {
        if (n3 > 2) {
            if (this.isFocused()) {
                gC.setForeground(this.titleBgStart);
                gC.setBackground(this.titleBgEnd);
                gC.fillGradientRectangle(n, n2, n3, n4, true);
            } else {
                gC.setForeground(this.titleInActiveBgStart);
                gC.setBackground(this.titleInActiveBgEnd);
                gC.fillGradientRectangle(n, n2, n3, n4, true);
                gC.setForeground(this.borderColor);
                int n5 = n + n3 - 2;
                int n6 = n2 + n4 - 2;
                gC.drawLine(n + 1, n2, n5, n2);
                gC.drawLine(n + 1, n6 + 1, n5, n6 + 1);
                gC.drawLine(n, n2 + 1, n, n6);
                gC.drawLine(n5 + 1, n2 + 1, n5 + 1, n6);
            }
            String string = this.getTitle();
            if (string != null && (string = UIUtils.shortenText(gC, string, n3 - 6 - this.buttons.length * 16)).length() > 0) {
                gC.setForeground(this.isFocused() ? this.titleColor : this.titleInActiveColor);
                gC.drawString(string, n + 5, n2 + 2, true);
            }
        }
    }

    protected void paintButtons(GC gC, int n, int n2) {
        if (!this.isButtonVisible()) {
            return;
        }
        boolean bl = this.isButtonOverTab(n2);
        Color color = bl ? this.getForeground() : (this.isFocused() ? this.titleColor : this.titleInActiveColor);
        Color color2 = !bl && this.isFocused() ? this.titleColor : this.borderColor;
        Color color3 = this.titleInActiveColor;
        for (int i = this.buttons.length - 1; i >= 0; --i) {
            Rectangle rectangle = this.buttons[i].getBounds(false);
            if (rectangle.x + rectangle.width < n) break;
            this.paintButton(gC, i, this.buttons[i], color);
            boolean bl2 = false;
            boolean bl3 = this.getFlag(2);
            if (bl3) {
                bl2 = i == this.fMouseDownIndex && this.fMouseDownIndex == this.fMouseOverIndex;
            } else {
                boolean bl4 = bl2 = i == this.fMouseOverIndex;
            }
            if (!bl2) continue;
            if (bl3) {
                UIUtils.drawBorder(gC, rectangle.x - 1, rectangle.y - 1, rectangle.width + 2, rectangle.height + 2, color3, color2);
                continue;
            }
            UIUtils.drawBorder(gC, rectangle.x - 1, rectangle.y - 1, rectangle.width + 2, rectangle.height + 2, color2, color3);
        }
    }

    protected void paintButton(GC gC, int n, CItem cItem, Color color) {
        int n2 = cItem.getType();
        Rectangle rectangle = cItem.getBounds(false);
        if (n2 == 1) {
            gC.setForeground(color);
            int n3 = (rectangle.width - 7) / 2;
            int n4 = rectangle.x + n3;
            int n5 = rectangle.y + n3 + 1;
            int n6 = n4 + 7;
            int n7 = n5 + 7;
            gC.drawLine(n4, n5, n6, n7);
            gC.drawLine(n4, n7, n6, n5);
            gC.drawLine(++n4, n5, ++n6, n7);
            gC.drawLine(n4, n7, n6, n5);
        } else {
            gC.setBackground(color);
            int n8 = 3;
            int[] nArray = new int[]{0, 0, n8, n8 + 1, 7, 0};
            n8 = (rectangle.width - 7) / 2;
            int n9 = 0;
            do {
                int n10 = n9++;
                nArray[n10] = nArray[n10] + (rectangle.x + n8 + 1);
                int n11 = n9++;
                nArray[n11] = nArray[n11] + (rectangle.y + rectangle.height - 7);
            } while (n9 < nArray.length);
            gC.fillPolygon(nArray);
        }
    }

    protected boolean paintTab(GC gC, int n, int n2, int n3, int n4, int n5, Color color, Color color2) {
        int n6;
        CItem cItem;
        boolean bl = true;
        int n7 = n4 - 2;
        if (this.tabPosition == 128) {
            ++n2;
        }
        if (this.current == (cItem = this.tabs[n5]).getData()) {
            int n8 = n;
            gC.setBackground(color);
            gC.fillRectangle(n8, n2, n3, n7);
            gC.setForeground(this.borderDarkColor);
            int n9 = n2 + n7;
            n6 = n8 + n3;
            if (this.tabPosition != 128) {
                gC.drawLine(n8, n9, n6, n9);
            }
            gC.drawLine(n6, n2, n6, n9);
            gC.setForeground(this.borderLightColor);
            gC.drawLine(n8, n2, n8, n9);
            if (this.tabPosition == 128) {
                gC.drawLine(n8, n2, n6, n2);
            }
        } else {
            gC.setForeground(this.borderDarkColor);
            gC.drawLine(n + n3, n2 + 3, n + n3, n2 + n7 - 2);
        }
        n += 2;
        n2 += 2;
        String string = cItem.getText();
        Image image = cItem.getImage();
        int n10 = n6 = image != null ? 16 : 2;
        if (n3 > n6) {
            if (image != null) {
                Rectangle rectangle = image.getBounds();
                gC.drawImage(image, 0, 0, rectangle.width, rectangle.height, n, n2 + 1, 16, 16);
                n += 16;
            }
            n += 2;
            if (string != null) {
                String string2;
                int n11 = 4;
                if (image != null) {
                    n11 += 2;
                }
                bl = (string2 = UIUtils.shortenText(gC, string, n3 - n6 - n11)) != string;
                gC.setForeground(this.current == cItem.getData() ? color2 : this.borderDarkColor);
                gC.drawString(string2, n, n2 + 2, true);
            }
        }
        return bl;
    }

    protected void paintTabs(GC gC, int n, int n2, int n3, int n4, Color color, Color color2) {
        gC.setBackground(this.tabBackgroundColor);
        gC.fillRectangle(n, n2, n3, n4);
        if (this.tabPosition == 128) {
            gC.setForeground(color);
            gC.drawLine(n, n2 + n4 - 1, n + n3, n2 + n4 - 1);
        } else {
            gC.setForeground(this.borderDarkColor);
            gC.drawLine(n, n2, n + n3, n2);
        }
        Rectangle rectangle = gC.getClipping();
        for (int i = 0; i < this.parts.size(); ++i) {
            Rectangle rectangle2 = this.tabs[i].getBounds(false);
            if (rectangle2 == null || rectangle2.width == 0) continue;
            gC.setClipping(rectangle2.x, n2, rectangle2.width + 1, n4);
            boolean bl = this.paintTab(gC, rectangle2.x, n2, rectangle2.width, n4, i, color, color2);
            if (!bl) continue;
            this.tabs[i].setType(1);
        }
        gC.setClipping(rectangle);
    }

    protected void doLayout(GC gC) {
        if (!this.getFlag(8)) {
            return;
        }
        this.setFlag(8, false);
        Rectangle rectangle = this.getClientArea();
        this.layoutButtons(gC, rectangle);
        if (this.isTabVisible()) {
            this.layoutTabs(gC, rectangle);
            return;
        }
    }

    protected void resetButtons() {
        this.setFlag(8, true);
        ArrayList<CItem> arrayList = new ArrayList<CItem>(2);
        if (this.current != null) {
            CItem cItem;
            if (this.current.getMenu() != null) {
                cItem = new CItem(2);
                cItem.setText("Menu");
                arrayList.add(cItem);
            }
            if (this.current.isCloseable()) {
                cItem = new CItem(1);
                cItem.setText("Close");
                arrayList.add(cItem);
            }
        }
        if (arrayList.size() > 0) {
            this.buttons = new CItem[arrayList.size()];
            arrayList.toArray(this.buttons);
        } else {
            this.buttons = EMPTY_ITEMS;
        }
    }

    protected void layoutButtons(GC gC, Rectangle rectangle) {
        if (!this.isButtonVisible()) {
            return;
        }
        int n = rectangle.x + rectangle.width - 4;
        int n2 = this.getButtonLocation(rectangle);
        for (int i = this.buttons.length - 1; i >= 0; --i) {
            CItem cItem = this.buttons[i];
            Rectangle rectangle2 = cItem.getBounds(false);
            rectangle2.y = n2;
            rectangle2.x = n - 12;
            rectangle2.height = 12;
            rectangle2.width = 12;
            n -= 16;
        }
    }

    protected boolean isButtonVisible() {
        return this.showTitle || this.isTabVisible();
    }

    protected Point getMinimumSize() {
        int n;
        int n2;
        if (this.isTabVisible()) {
            n2 = this.parts.size() * 24 + 4;
            n = this.getTabHeight();
        } else {
            n2 = 28;
            n = this.getTitleHeight();
        }
        if (this.buttons.length > 0) {
            n2 += this.buttons.length * 16;
        }
        return new Point(n2, n);
    }

    protected boolean isButtonOverTab(int n) {
        return !this.showTitle || this.isTabVisible() && n < this.getTabHeight() + this.getTitleHeight();
    }

    protected int getButtonLocation(Rectangle rectangle) {
        int n;
        if (this.isButtonOverTab(rectangle.height)) {
            n = rectangle.y - 12 - 4;
            n = this.tabPosition == 128 ? (n += this.getTabHeight()) : (n += rectangle.height);
        } else {
            n = rectangle.y + (this.getTitleHeight() - 12) / 2;
            if (this.tabPosition == 128) {
                n = n + rectangle.height - this.getTitleHeight();
            }
        }
        return n;
    }

    protected void layoutTabs(GC gC, Rectangle rectangle) {
        int n;
        int n2;
        int n3;
        Rectangle rectangle2;
        int n4;
        int n5 = this.parts.size();
        this.tabs = new CItem[n5];
        for (n4 = 0; n4 < n5; ++n4) {
            this.tabs[n4] = this.createItem(this.getPart(n4));
            rectangle2 = this.tabs[n4].getBounds(false);
            String string = this.tabs[n4].getText();
            if (string != null) {
                rectangle2.width = gC.stringExtent((String)string).x;
            }
            if (this.tabs[n4].getImage() != null) {
                rectangle2.width += 18;
            }
            rectangle2.width += 6;
        }
        n4 = 0;
        int n6 = n3 = this.getTabWidth(rectangle);
        int n7 = n6 / n5;
        while (n7 > n4) {
            n2 = n5;
            n6 = n3;
            for (n = 0; n < n5; ++n) {
                rectangle2 = this.tabs[n].getBounds(false);
                if (rectangle2.width >= n7) continue;
                n6 -= rectangle2.width;
                --n2;
            }
            n4 = n7;
            if (n2 <= 0) continue;
            n7 = n6 / n2;
        }
        n2 = rectangle.x + 4;
        if (n7 < 3) {
            n7 = 0;
        }
        n = 0;
        int n8 = this.getTabHeight();
        n = this.tabPosition == 128 ? rectangle.y : rectangle.y + rectangle.height - n8;
        for (int i = 0; i < n5; ++i) {
            rectangle2 = this.tabs[i].getBounds(false);
            rectangle2.x = n2;
            rectangle2.y = n;
            rectangle2.height = n8;
            if (rectangle2.width > n7) {
                rectangle2.width = n7;
            }
            n2 += rectangle2.width;
        }
    }

    protected int getTabWidth(Rectangle rectangle) {
        int n = rectangle.width - 8;
        if (n > 0 && this.buttons.length > 0 && this.isButtonOverTab(rectangle.height)) {
            n -= this.buttons.length * 16;
        }
        if (n < 0) {
            n = 0;
        }
        return n;
    }

    protected CItem createItem(IPresentablePart iPresentablePart) {
        CItem cItem = new CItem(iPresentablePart.getName());
        cItem.setImage(iPresentablePart.getTitleImage());
        cItem.setData(iPresentablePart);
        return cItem;
    }

    private final class PaneLayout
    extends Layout {
        private PaneLayout() {
        }

        protected Point computeSize(Composite composite, int n, int n2, boolean bl) {
            Point point = TabbedPane.this.getMinimumSize();
            if (n != -1) {
                point.x = n;
            }
            if (n2 != -1) {
                point.y = n2;
            }
            return point;
        }

        protected void layout(Composite composite, boolean bl) {
            TabbedPane.this.showPart(TabbedPane.this.current);
        }
    }
}

