/*
 * Decompiled with CFR 0.152.
 */
package com.spket.mime.editors;

import com.spket.as.internal.compiler.parser.BufferedScanner;
import com.spket.buffer.DocumentBuffer;
import com.spket.buffer.IBuffer;
import com.spket.js.internal.text.JSContentAssistProcessor;
import com.spket.js.model.Context;
import com.spket.js.model.ILexerContext;
import com.spket.js.model.ILexerProvider;
import com.spket.js.model.JSObject;
import com.spket.js.parser.ScriptManager;
import com.spket.mime.text.LexerProvider;
import com.spket.ui.internal.UIPlugin;
import com.spket.xml.PositionInfo;
import com.spket.xml.XMLDocument;
import com.spket.xml.XMLModelParser;
import com.spket.xml.XMLUtils;
import com.spket.xml.grammars.GrammarManager;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistEvent;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.editors.text.ILocationProvider;

public class CodeAssistAction
extends AbstractHandler {
    static /* synthetic */ Class class$org$eclipse$jface$text$ITextOperationTarget;

    public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        Control control = Display.getCurrent().getFocusControl();
        if (control == null || !control.isEnabled() || (control.getStyle() & 8) != 0) {
            return null;
        }
        if (!(control instanceof StyledText)) {
            return null;
        }
        StyledText styledText = (StyledText)control;
        if (!styledText.getEditable()) {
            return null;
        }
        IWorkbenchPage iWorkbenchPage = UIPlugin.getActivePage();
        if (iWorkbenchPage == null) {
            return null;
        }
        IEditorPart iEditorPart = iWorkbenchPage.getActiveEditor();
        ITextViewer iTextViewer = this.getTextViewer(iEditorPart);
        if (iTextViewer == null || iTextViewer.getTextWidget() != control) {
            return null;
        }
        IDocument iDocument = iTextViewer.getDocument();
        if (iDocument == null) {
            return null;
        }
        Point point = iTextViewer.getSelectedRange();
        if (point == null || point.x < 0) {
            return null;
        }
        int n = point.x;
        char[] cArray = null;
        try {
            point = this.getSourceRange(iDocument, n);
            if (point != null) {
                cArray = iDocument.get(point.x, point.y).toCharArray();
            }
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
        if (cArray == null) {
            return null;
        }
        LexerContext lexerContext = new LexerContext(iEditorPart.getEditorInput(), cArray, point.x);
        JSContentAssistProcessor jSContentAssistProcessor = new JSContentAssistProcessor((ILexerContext)lexerContext);
        ICompletionProposal[] iCompletionProposalArray = jSContentAssistProcessor.computeCompletionProposals(iTextViewer, n);
        if (iCompletionProposalArray != null && iCompletionProposalArray.length > 0) {
            JSContentAssistant jSContentAssistant = new JSContentAssistant(new ContentAssistProcessor(iCompletionProposalArray));
            jSContentAssistant.install(iTextViewer);
            jSContentAssistant.addCompletionListener(new CompletionListener(jSContentAssistant));
            jSContentAssistant.showPossibleCompletions();
        } else {
            control.getDisplay().beep();
        }
        return null;
    }

    protected ITextViewer getTextViewer(IEditorPart iEditorPart) {
        if (iEditorPart != null) {
            Object object = iEditorPart.getAdapter(class$org$eclipse$jface$text$ITextOperationTarget == null ? (class$org$eclipse$jface$text$ITextOperationTarget = CodeAssistAction.class$("org.eclipse.jface.text.ITextOperationTarget")) : class$org$eclipse$jface$text$ITextOperationTarget);
            if (object instanceof ITextViewer) {
                return (ITextViewer)object;
            }
            IWorkbenchPartSite iWorkbenchPartSite = iEditorPart.getSite();
            if (iWorkbenchPartSite != null && (object = iWorkbenchPartSite.getSelectionProvider()) instanceof ITextViewer) {
                return (ITextViewer)object;
            }
        }
        return null;
    }

    protected Point getSourceRange(IDocument iDocument, int n) throws BadLocationException {
        int n2 = iDocument.getLength();
        if (n2 > 0) {
            for (int i = 0; i < n2; ++i) {
                char c = iDocument.getChar(i);
                if (c == '<') {
                    XMLModelParser xMLModelParser = new XMLModelParser(GrammarManager.getSymbolTable());
                    DocumentBuffer documentBuffer = new DocumentBuffer(null, iDocument);
                    xMLModelParser.parse((IBuffer)documentBuffer);
                    XMLDocument xMLDocument = xMLModelParser.getDocument();
                    if (xMLDocument != null) {
                        PositionInfo positionInfo = new PositionInfo();
                        XMLUtils.findNode((XMLDocument)xMLDocument, (int)n, (PositionInfo)positionInfo);
                        return LexerProvider.getSourceRange(positionInfo.nodeType, positionInfo.node, (IBuffer)documentBuffer);
                    }
                    return null;
                }
                if (Character.isWhitespace(c)) continue;
                return new Point(0, n2);
            }
        }
        return new Point(0, 0);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static final class LexerContext
    implements ILexerContext,
    ILexerProvider {
        private IPath fPath;
        private IEditorInput fInput;
        private int fOffset;
        private char[] fSource;
        private Context fContext;
        private BufferedScanner fLexer;

        public LexerContext(IEditorInput iEditorInput, char[] cArray, int n) {
            this.fInput = iEditorInput;
            this.fSource = cArray;
            this.fOffset = n;
        }

        public IPath getPath() {
            if (this.fPath == null) {
                if (this.fInput instanceof IStorageEditorInput) {
                    try {
                        this.fPath = ((IStorageEditorInput)this.fInput).getStorage().getFullPath();
                    }
                    catch (CoreException coreException) {}
                } else if (this.fInput instanceof IPathEditorInput) {
                    this.fPath = ((IPathEditorInput)this.fInput).getPath();
                } else if (this.fInput instanceof ILocationProvider) {
                    this.fPath = ((ILocationProvider)this.fInput).getPath((Object)this.fInput);
                }
            }
            return this.fPath;
        }

        public Context getContext() {
            if (this.fContext == null) {
                this.fContext = Context.getContext((IEditorInput)this.fInput);
                if (this.fContext != null && !this.fContext.isInitialized()) {
                    this.fContext.initialize();
                }
            }
            return this.fContext;
        }

        public ScriptManager getManager() {
            int n = Context.JS_1_6;
            ScriptManager scriptManager = null;
            Context context = this.getContext();
            if (context != null) {
                scriptManager = context.getManager();
                if (scriptManager != null) {
                    return scriptManager;
                }
                n = context.getSourceLevel();
            }
            return ScriptManager.getManager((int)n);
        }

        public BufferedScanner[] getScripts() {
            return null;
        }

        public JSObject getGlobalForEdit() {
            Context context = this.getContext();
            if (context == null) {
                return null;
            }
            return context.getGlobalForEdit();
        }

        public BufferedScanner getLexer() {
            if (this.fLexer == null && this.fSource != null) {
                int n = Context.JS_1_6;
                Context context = this.getContext();
                if (context != null) {
                    n = context.getSourceLevel();
                }
                this.fLexer = new BufferedScanner(n);
                this.fLexer.setSource(this.fSource);
                this.fLexer.setSourceOffset(this.fOffset);
                this.fSource = null;
            }
            return this.fLexer;
        }

        public String[] getIncludes() {
            return null;
        }

        public JSObject getThisScope(JSObject jSObject) {
            return jSObject;
        }

        public ILexerProvider getLexerProvider(int n) {
            return this;
        }
    }

    private static final class JSContentAssistant
    extends ContentAssistant {
        private IContentAssistProcessor fProcessor;

        public JSContentAssistant(IContentAssistProcessor iContentAssistProcessor) {
            this.fProcessor = iContentAssistProcessor;
        }

        public IContentAssistProcessor getContentAssistProcessor(String string) {
            return this.fProcessor;
        }
    }

    private static final class CompletionListener
    implements ICompletionListener {
        private ContentAssistant fContentAssistant;

        public CompletionListener(ContentAssistant contentAssistant) {
            this.fContentAssistant = contentAssistant;
        }

        public void assistSessionEnded(ContentAssistEvent contentAssistEvent) {
            if (this.fContentAssistant != null) {
                ContentAssistant contentAssistant = this.fContentAssistant;
                this.fContentAssistant = null;
                contentAssistant.removeCompletionListener((ICompletionListener)this);
                Display.getCurrent().asyncExec(new Runnable(this, contentAssistant){
                    private final /* synthetic */ ContentAssistant val$assist;
                    private final /* synthetic */ CompletionListener this$0;
                    {
                        this.this$0 = completionListener;
                        this.val$assist = contentAssistant;
                    }

                    public void run() {
                        this.val$assist.uninstall();
                    }
                });
            }
        }

        public void assistSessionStarted(ContentAssistEvent contentAssistEvent) {
        }

        public void selectionChanged(ICompletionProposal iCompletionProposal, boolean bl) {
        }
    }

    private static final class ContentAssistProcessor
    implements IContentAssistProcessor {
        private ICompletionProposal[] fProposals;

        public ContentAssistProcessor(ICompletionProposal[] iCompletionProposalArray) {
            this.fProposals = iCompletionProposalArray;
        }

        public ICompletionProposal[] computeCompletionProposals(ITextViewer iTextViewer, int n) {
            return this.fProposals;
        }

        public IContextInformation[] computeContextInformation(ITextViewer iTextViewer, int n) {
            return null;
        }

        public char[] getCompletionProposalAutoActivationCharacters() {
            return null;
        }

        public char[] getContextInformationAutoActivationCharacters() {
            return null;
        }

        public IContextInformationValidator getContextInformationValidator() {
            return null;
        }

        public String getErrorMessage() {
            return null;
        }
    }
}

