/*
 * Decompiled with CFR 0.152.
 */
package com.spket.as.internal.compiler.util;

import com.spket.as.core.compiler.CharOperation;
import com.spket.as.internal.compiler.lookup.ReferenceBinding;

public final class HashtableOfType {
    public char[][] keyTable;
    public ReferenceBinding[] valueTable;
    public int elementSize = 0;
    int threshold;

    public HashtableOfType() {
        this(3);
    }

    public HashtableOfType(int n) {
        this.threshold = n;
        int n2 = (int)((float)n * 1.75f);
        if (this.threshold == n2) {
            ++n2;
        }
        this.keyTable = new char[n2][];
        this.valueTable = new ReferenceBinding[n2];
    }

    public boolean containsKey(char[] cArray) {
        char[] cArray2;
        int n = CharOperation.hashCode(cArray) % this.valueTable.length;
        int n2 = cArray.length;
        while ((cArray2 = this.keyTable[n]) != null) {
            if (cArray2.length == n2 && CharOperation.equals(cArray2, cArray)) {
                return true;
            }
            n = (n + 1) % this.keyTable.length;
        }
        return false;
    }

    public ReferenceBinding get(char[] cArray) {
        char[] cArray2;
        int n = CharOperation.hashCode(cArray) % this.valueTable.length;
        int n2 = cArray.length;
        while ((cArray2 = this.keyTable[n]) != null) {
            if (cArray2.length == n2 && CharOperation.equals(cArray2, cArray)) {
                return this.valueTable[n];
            }
            n = (n + 1) % this.keyTable.length;
        }
        return null;
    }

    public ReferenceBinding put(char[] cArray, ReferenceBinding referenceBinding) {
        char[] cArray2;
        int n = CharOperation.hashCode(cArray) % this.valueTable.length;
        int n2 = cArray.length;
        while ((cArray2 = this.keyTable[n]) != null) {
            if (cArray2.length == n2 && CharOperation.equals(cArray2, cArray)) {
                this.valueTable[n] = referenceBinding;
                return this.valueTable[n];
            }
            n = (n + 1) % this.keyTable.length;
        }
        this.keyTable[n] = cArray;
        this.valueTable[n] = referenceBinding;
        if (++this.elementSize > this.threshold) {
            this.rehash();
        }
        return referenceBinding;
    }

    private void rehash() {
        HashtableOfType hashtableOfType = new HashtableOfType(this.elementSize < 100 ? 100 : this.elementSize * 2);
        int n = this.keyTable.length;
        while (--n >= 0) {
            char[] cArray = this.keyTable[n];
            if (cArray == null) continue;
            hashtableOfType.put(cArray, this.valueTable[n]);
        }
        this.keyTable = hashtableOfType.keyTable;
        this.valueTable = hashtableOfType.valueTable;
        this.threshold = hashtableOfType.threshold;
    }

    public int size() {
        return this.elementSize;
    }

    public String toString() {
        String string = "";
        int n = this.valueTable.length;
        for (int i = 0; i < n; ++i) {
            ReferenceBinding referenceBinding = this.valueTable[i];
            if (referenceBinding == null) continue;
            string = string + referenceBinding.toString() + "\n";
        }
        return string;
    }
}

