/*
 * Decompiled with CFR 0.152.
 */
package com.spket.as.internal.compiler.parser;

import com.spket.as.internal.compiler.ast.ASTNode;
import com.spket.as.internal.compiler.ast.CompilationUnitDeclaration;
import com.spket.as.internal.compiler.ast.ImportStatement;
import com.spket.as.internal.compiler.ast.PackageDeclaration;
import com.spket.as.internal.compiler.ast.TypeDeclaration;
import com.spket.as.internal.compiler.parser.Parser;
import com.spket.as.internal.compiler.parser.RecoveredElement;
import com.spket.as.internal.compiler.parser.RecoveredPackage;
import com.spket.as.internal.compiler.parser.RecoveredStatement;
import com.spket.as.internal.compiler.parser.RecoveredType;

public class RecoveredUnit
extends RecoveredElement {
    public CompilationUnitDeclaration unitDeclaration;
    public int stmtCount;
    public RecoveredStatement[] statements;

    public RecoveredUnit(CompilationUnitDeclaration compilationUnitDeclaration, int n, Parser parser) {
        super(null, n, parser);
        this.unitDeclaration = compilationUnitDeclaration;
        this.statements = new RecoveredStatement[1];
    }

    public RecoveredElement add(PackageDeclaration packageDeclaration, int n) {
        this.ensureCapacity();
        RecoveredPackage recoveredPackage = new RecoveredPackage(packageDeclaration, (RecoveredElement)this, n);
        this.statements[this.stmtCount++] = recoveredPackage;
        if (packageDeclaration.declarationSourceEnd == 0) {
            return recoveredPackage;
        }
        return this;
    }

    public RecoveredElement add(ImportStatement importStatement, int n) {
        return this;
    }

    public RecoveredElement add(TypeDeclaration typeDeclaration, int n) {
        return this;
    }

    public ASTNode parseTree() {
        return this.unitDeclaration;
    }

    public int sourceEnd() {
        return this.unitDeclaration.sourceEnd;
    }

    public String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer(this.tabString(n));
        stringBuffer.append("Recovered unit: [\n");
        this.unitDeclaration.print(n + 1, stringBuffer);
        stringBuffer.append(this.tabString(n + 1));
        stringBuffer.append("]");
        for (int i = 0; i < this.stmtCount; ++i) {
            stringBuffer.append("\n");
            stringBuffer.append(this.statements[i].toString(n + 1));
        }
        return stringBuffer.toString();
    }

    public CompilationUnitDeclaration updatedCompilationUnitDeclaration() {
        return this.unitDeclaration;
    }

    public void updateParseTree() {
        this.updatedCompilationUnitDeclaration();
    }

    public void updateSourceEndIfNecessary(int n, int n2) {
        if (this.unitDeclaration.sourceEnd == 0) {
            this.unitDeclaration.sourceEnd = n2;
        }
    }

    private void ensureCapacity() {
        if (this.stmtCount == this.statements.length) {
            this.statements = new RecoveredType[2 * this.stmtCount];
            System.arraycopy(this.statements, 0, this.statements, 0, this.stmtCount);
        }
    }
}

