/*
 * Decompiled with CFR 0.152.
 */
package com.spket.as.internal.compiler.parser;

import com.spket.as.internal.compiler.ast.ASTNode;
import com.spket.as.internal.compiler.ast.Block;
import com.spket.as.internal.compiler.ast.FunctionDeclaration;
import com.spket.as.internal.compiler.ast.ImportStatement;
import com.spket.as.internal.compiler.ast.PackageDeclaration;
import com.spket.as.internal.compiler.ast.Statement;
import com.spket.as.internal.compiler.ast.TypeDeclaration;
import com.spket.as.internal.compiler.ast.VariableBinding;
import com.spket.as.internal.compiler.parser.Parser;
import com.spket.as.internal.compiler.parser.RecoveredBlock;
import com.spket.as.internal.compiler.parser.RecoveredMethod;
import com.spket.as.internal.compiler.parser.RecoveredType;
import com.spket.as.internal.compiler.parser.Scanner;

public class RecoveredElement {
    public RecoveredElement parent;
    public int bracketBalance;
    public boolean foundOpeningBrace;
    protected Parser recoveringParser;

    public RecoveredElement(RecoveredElement recoveredElement, int n) {
        this(recoveredElement, n, null);
    }

    public RecoveredElement(RecoveredElement recoveredElement, int n, Parser parser) {
        this.parent = recoveredElement;
        this.bracketBalance = n;
        this.recoveringParser = parser;
    }

    public RecoveredElement add(PackageDeclaration packageDeclaration, int n) {
        if (this.parent == null) {
            return this;
        }
        this.updateSourceEndIfNecessary(this.previousAvailableLineEnd(packageDeclaration.declarationSourceStart - 1));
        return this.parent.add(packageDeclaration, n);
    }

    public RecoveredElement add(FunctionDeclaration functionDeclaration, int n) {
        if (this.parent == null) {
            return this;
        }
        this.updateSourceEndIfNecessary(this.previousAvailableLineEnd(functionDeclaration.declarationSourceStart - 1));
        return this.parent.add(functionDeclaration, n);
    }

    public RecoveredElement add(Block block, int n) {
        if (this.parent == null) {
            return this;
        }
        this.updateSourceEndIfNecessary(this.previousAvailableLineEnd(block.sourceStart - 1));
        return this.parent.add(block, n);
    }

    public RecoveredElement add(ImportStatement importStatement, int n) {
        if (this.parent == null) {
            return this;
        }
        this.updateSourceEndIfNecessary(this.previousAvailableLineEnd(importStatement.declarationSourceStart - 1));
        return this.parent.add(importStatement, n);
    }

    public RecoveredElement add(VariableBinding variableBinding, int n) {
        if (this.parent == null) {
            return this;
        }
        this.updateSourceEndIfNecessary(this.previousAvailableLineEnd(variableBinding.declarationSourceStart - 1));
        return this.parent.add(variableBinding, n);
    }

    public RecoveredElement add(Statement statement, int n) {
        if (this.parent == null) {
            return this;
        }
        this.updateSourceEndIfNecessary(this.previousAvailableLineEnd(statement.sourceStart - 1));
        return this.parent.add(statement, n);
    }

    public RecoveredElement add(TypeDeclaration typeDeclaration, int n) {
        if (this.parent == null) {
            return this;
        }
        this.updateSourceEndIfNecessary(this.previousAvailableLineEnd(typeDeclaration.declarationSourceStart - 1));
        return this.parent.add(typeDeclaration, n);
    }

    public int depth() {
        int n = 0;
        RecoveredElement recoveredElement = this;
        while ((recoveredElement = recoveredElement.parent) != null) {
            ++n;
        }
        return n;
    }

    public RecoveredMethod enclosingMethod() {
        RecoveredElement recoveredElement = this;
        while (recoveredElement != null) {
            if (recoveredElement instanceof RecoveredMethod) {
                return (RecoveredMethod)recoveredElement;
            }
            recoveredElement = recoveredElement.parent;
        }
        return null;
    }

    public RecoveredType enclosingType() {
        RecoveredElement recoveredElement = this;
        while (recoveredElement != null) {
            if (recoveredElement instanceof RecoveredType) {
                return (RecoveredType)recoveredElement;
            }
            recoveredElement = recoveredElement.parent;
        }
        return null;
    }

    public Parser parser() {
        RecoveredElement recoveredElement = this;
        while (recoveredElement != null) {
            if (recoveredElement.recoveringParser != null) {
                return recoveredElement.recoveringParser;
            }
            recoveredElement = recoveredElement.parent;
        }
        return null;
    }

    public ASTNode parseTree() {
        return null;
    }

    public void preserveEnclosingBlocks() {
        RecoveredElement recoveredElement = this;
        while (recoveredElement != null) {
            if (recoveredElement instanceof RecoveredBlock) {
                ((RecoveredBlock)recoveredElement).preserveContent = true;
            }
            if (recoveredElement instanceof RecoveredType) {
                ((RecoveredType)recoveredElement).preserveContent = true;
            }
            recoveredElement = recoveredElement.parent;
        }
    }

    public int previousAvailableLineEnd(int n) {
        Parser parser = this.parser();
        if (parser == null) {
            return n;
        }
        Scanner scanner = parser.scanner;
        if (scanner.lineEnds == null) {
            return n;
        }
        int n2 = scanner.getLineNumber(n);
        if (n2 < 2) {
            return n;
        }
        int n3 = scanner.lineEnds[n2 - 2];
        char[] cArray = scanner.source;
        for (int i = n3 + 1; i < n; ++i) {
            if (cArray[i] == ' ' || cArray[i] == '\t') continue;
            return n;
        }
        return n3;
    }

    public int sourceEnd() {
        return 0;
    }

    protected String tabString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = n; i > 0; --i) {
            stringBuffer.append("  ");
        }
        return stringBuffer.toString();
    }

    public RecoveredElement topElement() {
        RecoveredElement recoveredElement = this;
        while (recoveredElement.parent != null) {
            recoveredElement = recoveredElement.parent;
        }
        return recoveredElement;
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int n) {
        return super.toString();
    }

    public RecoveredType type() {
        RecoveredElement recoveredElement = this;
        while (recoveredElement != null) {
            if (recoveredElement instanceof RecoveredType) {
                return (RecoveredType)recoveredElement;
            }
            recoveredElement = recoveredElement.parent;
        }
        return null;
    }

    public void updateBodyStart(int n) {
        this.foundOpeningBrace = true;
    }

    public void updateFromParserState() {
    }

    public RecoveredElement updateOnClosingBrace(int n, int n2) {
        if (--this.bracketBalance <= 0 && this.parent != null) {
            this.updateSourceEndIfNecessary(n, n2);
            return this.parent;
        }
        return this;
    }

    public RecoveredElement updateOnOpeningBrace(int n, int n2) {
        if (this.bracketBalance++ == 0) {
            this.updateBodyStart(n2 + 1);
            return this;
        }
        return null;
    }

    public void updateParseTree() {
    }

    public void updateSourceEndIfNecessary(int n, int n2) {
    }

    public void updateSourceEndIfNecessary(int n) {
        this.updateSourceEndIfNecessary(n + 1, n);
    }
}

