/*
 * Decompiled with CFR 0.152.
 */
package com.spket.as.internal.compiler.ast;

import com.spket.as.core.compiler.IProblem;
import com.spket.as.internal.compiler.ASTVisitor;
import com.spket.as.internal.compiler.CompilationResult;
import com.spket.as.internal.compiler.ast.AttributeStatement;
import com.spket.as.internal.compiler.ast.Block;
import com.spket.as.internal.compiler.ast.Expression;
import com.spket.as.internal.compiler.ast.Javadoc;
import com.spket.as.internal.compiler.impl.ReferenceContext;
import com.spket.as.internal.compiler.lookup.ClassScope;
import com.spket.as.internal.compiler.lookup.Frame;
import com.spket.as.internal.compiler.problem.AbortType;
import com.spket.as.internal.compiler.problem.ProblemSeverities;

public class TypeDeclaration
extends AttributeStatement
implements ProblemSeverities,
ReferenceContext {
    public static final int CLASS_DECL = 0;
    public static final int INTERFACE_DECL = 1;
    public static final char[] ANONYMOUS_EMPTY_NAME = new char[0];
    public char[] name;
    public Expression superclass;
    public Expression[] superInterfaces;
    public boolean isInterface;
    public Block body;
    public Javadoc javadoc;
    public ClassScope frame;
    public int bodyStart;
    public int bodyEnd;
    public CompilationResult compilationResult;
    public TypeDeclaration enclosingType;
    public boolean ignoreFurtherInvestigation = false;

    public TypeDeclaration(CompilationResult compilationResult) {
        this.compilationResult = compilationResult;
    }

    public void abort(int n, IProblem iProblem) {
    }

    public CompilationResult compilationResult() {
        return this.compilationResult;
    }

    public boolean hasErrors() {
        return false;
    }

    public void tagAsHavingErrors() {
    }

    public StringBuffer print(int n, StringBuffer stringBuffer) {
        if (this.javadoc != null) {
            this.javadoc.print(n, stringBuffer);
        }
        TypeDeclaration.printIndent(n, stringBuffer);
        this.printHeader(0, stringBuffer);
        return this.printBody(n, stringBuffer);
    }

    public StringBuffer printBody(int n, StringBuffer stringBuffer) {
        if (this.body != null) {
            stringBuffer.append(" {\n");
            this.body.printBody(n, stringBuffer);
            stringBuffer.append('\n');
            return TypeDeclaration.printIndent(n, stringBuffer).append('}');
        }
        return stringBuffer.append(';');
    }

    public StringBuffer printHeader(int n, StringBuffer stringBuffer) {
        this.printAttribute(stringBuffer);
        switch (this.kind()) {
            case 0: {
                stringBuffer.append("class ");
                break;
            }
            case 1: {
                stringBuffer.append("interface ");
            }
        }
        stringBuffer.append(this.name);
        if (this.superclass != null) {
            stringBuffer.append(" extends ");
            this.superclass.print(0, stringBuffer);
        }
        if (this.superInterfaces != null && this.superInterfaces.length > 0) {
            switch (this.kind()) {
                case 0: {
                    stringBuffer.append(" implements ");
                    break;
                }
                case 1: {
                    stringBuffer.append(" extends ");
                }
            }
            for (int i = 0; i < this.superInterfaces.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(", ");
                }
                this.superInterfaces[i].print(0, stringBuffer);
            }
        }
        return stringBuffer;
    }

    public StringBuffer printStatement(int n, StringBuffer stringBuffer) {
        return this.print(n, stringBuffer);
    }

    public int kind() {
        return this.isInterface ? 1 : 0;
    }

    public void traverse(ASTVisitor aSTVisitor, Frame frame) {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        try {
            if (aSTVisitor.visit(this, frame)) {
                if (this.superclass != null) {
                    this.superclass.traverse(aSTVisitor, this.frame);
                }
                if (this.superInterfaces != null) {
                    int n = this.superInterfaces.length;
                    for (int i = 0; i < n; ++i) {
                        this.superInterfaces[i].traverse(aSTVisitor, this.frame);
                    }
                }
                if (this.body != null) {
                    this.body.traverseBody(aSTVisitor, this.frame);
                }
            }
            aSTVisitor.endVisit(this, frame);
        }
        catch (AbortType abortType) {
            // empty catch block
        }
    }
}

