/*
 * Decompiled with CFR 0.152.
 */
package com.spket.as.internal.compiler;

import com.spket.as.core.compiler.IProblem;
import com.spket.as.internal.compiler.env.ICompilationUnit;
import com.spket.as.internal.compiler.impl.ReferenceContext;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;

public class CompilationResult {
    public IProblem[] problems;
    public IProblem[] tasks;
    public int problemCount;
    public int taskCount;
    public ICompilationUnit compilationUnit;
    private Map problemsMap;
    private Map firstErrorsMap;
    private int maxProblemPerUnit;
    public char[][][] qualifiedReferences;
    public char[][] simpleNameReferences;
    public int[] lineSeparatorPositions;
    public Hashtable compiledTypes = new Hashtable(11);
    public int unitIndex;
    public int totalUnitsKnown;
    public boolean hasBeenAccepted = false;
    public char[] fileName;

    public CompilationResult(char[] cArray, int n, int n2, int n3) {
        this.fileName = cArray;
        this.unitIndex = n;
        this.totalUnitsKnown = n2;
        this.maxProblemPerUnit = n3;
    }

    public CompilationResult(ICompilationUnit iCompilationUnit, int n, int n2, int n3) {
        this.fileName = iCompilationUnit.getFileName();
        this.compilationUnit = iCompilationUnit;
        this.unitIndex = n;
        this.totalUnitsKnown = n2;
        this.maxProblemPerUnit = n3;
    }

    private int computePriority(IProblem iProblem) {
        ReferenceContext referenceContext;
        int n = 10000 - iProblem.getSourceLineNumber();
        if (n < 0) {
            n = 0;
        }
        if (iProblem.isError()) {
            n += 100000;
        }
        ReferenceContext referenceContext2 = referenceContext = this.problemsMap == null ? null : (ReferenceContext)this.problemsMap.get(iProblem);
        n = referenceContext != null ? (n += 40000) : (n += 40000);
        if (this.firstErrorsMap.containsKey(iProblem)) {
            n += 20000;
        }
        return n;
    }

    public IProblem[] getAllProblems() {
        int n;
        IProblem[] iProblemArray = this.getProblems();
        int n2 = iProblemArray != null ? iProblemArray.length : 0;
        IProblem[] iProblemArray2 = this.getTasks();
        int n3 = n = iProblemArray2 != null ? iProblemArray2.length : 0;
        if (n == 0) {
            return iProblemArray;
        }
        if (n2 == 0) {
            return iProblemArray2;
        }
        int n4 = n2 + n;
        IProblem[] iProblemArray3 = new IProblem[n4];
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        while (n6 + n7 < n4) {
            IProblem iProblem = null;
            IProblem iProblem2 = null;
            if (n6 < n) {
                iProblem = iProblemArray2[n6];
            }
            if (n7 < n2) {
                iProblem2 = iProblemArray[n7];
            }
            IProblem iProblem3 = null;
            if (iProblem2 != null) {
                if (iProblem != null) {
                    if (iProblem2.getSourceStart() < iProblem.getSourceStart()) {
                        iProblem3 = iProblem2;
                        ++n7;
                    } else {
                        iProblem3 = iProblem;
                        ++n6;
                    }
                } else {
                    iProblem3 = iProblem2;
                    ++n7;
                }
            } else if (iProblem != null) {
                iProblem3 = iProblem;
                ++n6;
            }
            iProblemArray3[n5++] = iProblem3;
        }
        return iProblemArray3;
    }

    public ICompilationUnit getCompilationUnit() {
        return this.compilationUnit;
    }

    public char[] getFileName() {
        return this.fileName;
    }

    public IProblem[] getErrors() {
        IProblem[] iProblemArray = this.getProblems();
        int n = 0;
        for (int i = 0; i < this.problemCount; ++i) {
            if (!iProblemArray[i].isError()) continue;
            ++n;
        }
        if (n == this.problemCount) {
            return iProblemArray;
        }
        IProblem[] iProblemArray2 = new IProblem[n];
        int n2 = 0;
        for (int i = 0; i < this.problemCount; ++i) {
            if (!iProblemArray[i].isError()) continue;
            iProblemArray2[n2++] = iProblemArray[i];
        }
        return iProblemArray2;
    }

    public IProblem[] getProblems() {
        if (this.problems != null) {
            if (this.problemCount != this.problems.length) {
                this.problems = new IProblem[this.problemCount];
                System.arraycopy(this.problems, 0, this.problems, 0, this.problemCount);
            }
            if (this.maxProblemPerUnit > 0 && this.problemCount > this.maxProblemPerUnit) {
                this.quickPrioritize(this.problems, 0, this.problemCount - 1);
                this.problemCount = this.maxProblemPerUnit;
                this.problems = new IProblem[this.problemCount];
                System.arraycopy(this.problems, 0, this.problems, 0, this.problemCount);
            }
            CompilationResult.quickSort(this.problems, 0, this.problems.length - 1);
        }
        return this.problems;
    }

    public IProblem[] getTasks() {
        if (this.tasks != null) {
            if (this.taskCount != this.tasks.length) {
                this.tasks = new IProblem[this.taskCount];
                System.arraycopy(this.tasks, 0, this.tasks, 0, this.taskCount);
            }
            CompilationResult.quickSort(this.tasks, 0, this.tasks.length - 1);
        }
        return this.tasks;
    }

    public boolean hasErrors() {
        if (this.problems != null) {
            for (int i = 0; i < this.problemCount; ++i) {
                if (!this.problems[i].isError()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasProblems() {
        return this.problemCount != 0;
    }

    public boolean hasSyntaxError() {
        if (this.problems != null) {
            for (int i = 0; i < this.problemCount; ++i) {
                IProblem iProblem = this.problems[i];
                if ((iProblem.getID() & 0x40000000) == 0 || !iProblem.isError()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasTasks() {
        return this.taskCount != 0;
    }

    public boolean hasWarnings() {
        if (this.problems != null) {
            for (int i = 0; i < this.problemCount; ++i) {
                if (!this.problems[i].isWarning()) continue;
                return true;
            }
        }
        return false;
    }

    private static void quickSort(IProblem[] iProblemArray, int n, int n2) {
        if (n >= n2) {
            return;
        }
        int n3 = n;
        int n4 = n2;
        int n5 = iProblemArray[(n + n2) / 2].getSourceStart();
        while (true) {
            if (iProblemArray[n].getSourceStart() < n5) {
                ++n;
                continue;
            }
            while (n5 < iProblemArray[n2].getSourceStart()) {
                --n2;
            }
            if (n <= n2) {
                IProblem iProblem = iProblemArray[n];
                iProblemArray[n] = iProblemArray[n2];
                iProblemArray[n2] = iProblem;
                ++n;
                --n2;
            }
            if (n > n2) break;
        }
        if (n3 < n2) {
            CompilationResult.quickSort(iProblemArray, n3, n2);
        }
        if (n < n4) {
            CompilationResult.quickSort(iProblemArray, n, n4);
        }
    }

    private void quickPrioritize(IProblem[] iProblemArray, int n, int n2) {
        if (n >= n2) {
            return;
        }
        int n3 = n;
        int n4 = n2;
        int n5 = this.computePriority(iProblemArray[(n + n2) / 2]);
        while (true) {
            if (this.computePriority(iProblemArray[n2]) < n5) {
                --n2;
                continue;
            }
            while (n5 < this.computePriority(iProblemArray[n])) {
                ++n;
            }
            if (n <= n2) {
                IProblem iProblem = iProblemArray[n];
                iProblemArray[n] = iProblemArray[n2];
                iProblemArray[n2] = iProblem;
                ++n;
                --n2;
            }
            if (n > n2) break;
        }
        if (n3 < n2) {
            this.quickPrioritize(iProblemArray, n3, n2);
        }
        if (n < n4) {
            this.quickPrioritize(iProblemArray, n, n4);
        }
    }

    public void record(IProblem iProblem, ReferenceContext referenceContext) {
        if (iProblem.getID() == 536871362) {
            this.recordTask(iProblem);
            return;
        }
        if (this.problemCount == 0) {
            this.problems = new IProblem[5];
        } else if (this.problemCount == this.problems.length) {
            this.problems = new IProblem[this.problemCount * 2];
            System.arraycopy(this.problems, 0, this.problems, 0, this.problemCount);
        }
        this.problems[this.problemCount++] = iProblem;
        if (referenceContext != null) {
            if (this.problemsMap == null) {
                this.problemsMap = new Hashtable(5);
            }
            if (this.firstErrorsMap == null) {
                this.firstErrorsMap = new Hashtable(5);
            }
            if (iProblem.isError() && !referenceContext.hasErrors()) {
                this.firstErrorsMap.put(iProblem, iProblem);
            }
            this.problemsMap.put(iProblem, referenceContext);
        }
    }

    private void recordTask(IProblem iProblem) {
        if (this.taskCount == 0) {
            this.tasks = new IProblem[5];
        } else if (this.taskCount == this.tasks.length) {
            this.tasks = new IProblem[this.taskCount * 2];
            System.arraycopy(this.tasks, 0, this.tasks, 0, this.taskCount);
        }
        this.tasks[this.taskCount++] = iProblem;
    }

    public CompilationResult tagAsAccepted() {
        this.hasBeenAccepted = true;
        this.problemsMap = null;
        return this;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.fileName != null) {
            stringBuffer.append("Filename : ").append(this.fileName).append('\n');
        }
        if (this.compiledTypes != null) {
            stringBuffer.append("COMPILED type(s)\t\n");
            Enumeration enumeration = this.compiledTypes.keys();
            while (enumeration.hasMoreElements()) {
                char[] cArray = (char[])enumeration.nextElement();
                stringBuffer.append("\t - ").append(cArray).append('\n');
            }
        } else {
            stringBuffer.append("No COMPILED type\n");
        }
        if (this.problems != null) {
            stringBuffer.append(this.problemCount).append(" PROBLEM(s) detected \n");
            for (int i = 0; i < this.problemCount; ++i) {
                stringBuffer.append("\t - ").append(this.problems[i]).append('\n');
            }
        } else {
            stringBuffer.append("No PROBLEM\n");
        }
        return stringBuffer.toString();
    }
}

