/*
 * Decompiled with CFR 0.152.
 */
package com.spket.util;

import java.io.File;
import java.util.ArrayList;

public final class StringUtils {
    public static final String EMPTY_STRING = "".intern();
    public static final char[] EMPTY_CHARS = new char[0];
    public static final char[][] NO_CHAR_CHAR = new char[0][];
    public static final Object[] EMPTY_ITEMS = new Object[0];
    public static final String[] EMPTY_STRINGS = new String[0];
    public static final char[] ENT_LT = "&lt;".toCharArray();
    public static final char[] ENT_AMP = "&amp;".toCharArray();
    public static final char[] ENT_QUOT = "&quot;".toCharArray();
    public static final char[] ENT_APOS = "&apos;".toCharArray();

    public static boolean isEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }

    public static String makeNullIfEmpty(String string) {
        if (string == null) {
            return null;
        }
        return (string = string.trim()).length() == 0 ? null : string;
    }

    public static String toString(String string) {
        return StringUtils.toString(string, EMPTY_STRING);
    }

    public static String toString(String string, String string2) {
        return string == null ? string2 : string.trim();
    }

    public static int toInt(String string) {
        return StringUtils.toInt(string, 0);
    }

    public static int toInt(String string, int n) {
        int n2 = n;
        if (string != null && (string = string.trim()).length() > 0) {
            try {
                n2 = Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n2;
    }

    public static long toLong(String string) {
        return StringUtils.toLong(string, 0L);
    }

    public static long toLong(String string, long l) {
        long l2 = l;
        if (string != null && (string = string.trim()).length() > 0) {
            try {
                l2 = Long.parseLong(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return l2;
    }

    public static float toFloat(String string) {
        return StringUtils.toFloat(string, 0.0f);
    }

    public static float toFloat(String string, float f) {
        float f2 = f;
        if (string != null && (string = string.trim()).length() > 0) {
            try {
                f2 = Float.parseFloat(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return f2;
    }

    public static double toDouble(String string) {
        return StringUtils.toDouble(string, 0.0);
    }

    public static double toDouble(String string, double d) {
        double d2 = d;
        if (string != null && (string = string.trim()).length() > 0) {
            try {
                d2 = Double.parseDouble(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return d2;
    }

    public static boolean toBoolean(String string) {
        return StringUtils.toBoolean(string, false);
    }

    public static boolean toBoolean(String string, boolean bl) {
        boolean bl2 = bl;
        if (string != null && (string = string.trim()).length() > 0) {
            char c = string.charAt(0);
            bl2 = c == 't' || c == 'T' || c == 'y' || c == 'Y' || c > '0' && c <= '9';
        }
        return bl2;
    }

    public static boolean equals(Object object, Object object2) {
        boolean bl = false;
        if (object == object2) {
            bl = true;
        } else if (object != null && object2 != null) {
            bl = object.equals(object2);
        }
        return bl;
    }

    public static int compareTo(Object object, Object object2) {
        if (object == object2) {
            return 0;
        }
        if (object == null) {
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        if (object instanceof Comparable) {
            return ((Comparable)object).compareTo(object2);
        }
        return object.toString().compareTo(object2.toString());
    }

    public static String[] split(String string, char c) {
        return StringUtils.split(string, c, true);
    }

    public static String[] split(String string, char c, boolean bl) {
        String[] stringArray = EMPTY_STRINGS;
        if (string != null && string.length() > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < string.length(); ++i) {
                char c2 = string.charAt(i);
                if (c2 == c || i == string.length() - 1) {
                    if (c2 != c) {
                        stringBuffer.append(c2);
                    }
                    if (stringBuffer.length() > 0) {
                        String string2 = stringBuffer.toString().trim();
                        stringBuffer = new StringBuffer();
                        if (string2.length() > 0) {
                            arrayList.add(string2);
                            continue;
                        }
                    }
                    if (bl) {
                        arrayList.add(null);
                    }
                    if (c2 != c || i != string.length() - 1) continue;
                    if (!bl) break;
                    arrayList.add(null);
                    break;
                }
                stringBuffer.append(c2);
            }
            if (arrayList.size() > 0) {
                stringArray = new String[arrayList.size()];
                arrayList.toArray(stringArray);
            }
        }
        return stringArray;
    }

    public static final char[][] splitAndTrimOn(char c, char[] cArray) {
        int n;
        int n2;
        int n3;
        int n4 = n3 = cArray == null ? 0 : cArray.length;
        if (n3 == 0) {
            return NO_CHAR_CHAR;
        }
        int n5 = 1;
        for (int i = 0; i < n3; ++i) {
            if (cArray[i] != c) continue;
            ++n5;
        }
        char[][] cArrayArray = new char[n5][];
        int n6 = 0;
        int n7 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            if (cArray[n2] != c) continue;
            int n8 = n2 - 1;
            for (n = n6; n < n2 && cArray[n] == ' '; ++n) {
            }
            while (n8 > n && cArray[n8] == ' ') {
                --n8;
            }
            cArrayArray[n7] = new char[n8 - n + 1];
            System.arraycopy(cArray, n, cArrayArray[n7++], 0, n8 - n + 1);
            n6 = n2 + 1;
        }
        n = n3 - 1;
        for (n2 = n6; n2 < n3 && cArray[n2] == ' '; ++n2) {
        }
        while (n > n2 && cArray[n] == ' ') {
            --n;
        }
        cArrayArray[n7] = new char[n - n2 + 1];
        System.arraycopy(cArray, n2, cArrayArray[n7++], 0, n - n2 + 1);
        return cArrayArray;
    }

    public static String toURI(String string) {
        if (string == null) {
            return null;
        }
        return StringUtils.toURI(new File(string));
    }

    public static String toURI(File file) {
        if (file != null) {
            return file.toURI().toString();
        }
        return null;
    }

    public static boolean equals(String string, char[] cArray, boolean bl) {
        if (string.length() == cArray.length) {
            return StringUtils.startsWith(string, cArray, bl);
        }
        return false;
    }

    public static boolean startsWith(String string, String string2, boolean bl) {
        if (bl) {
            return string.startsWith(string2);
        }
        int n = string2.length();
        if (n == 0) {
            return true;
        }
        if (n <= string.length()) {
            return StringUtils.startsWith(string, string2.toCharArray(), bl);
        }
        return false;
    }

    public static boolean startsWith(String string, char[] cArray, boolean bl) {
        int n = cArray.length;
        if (n == 0) {
            return true;
        }
        if (n > string.length()) {
            return false;
        }
        char[] cArray2 = new char[n];
        string.getChars(0, n, cArray2, 0);
        if (bl) {
            for (int i = 0; i < n; ++i) {
                if (cArray[i] == cArray2[i]) continue;
                return false;
            }
        } else {
            for (int i = 0; i < n; ++i) {
                if (cArray[i] == cArray2[i] || Character.toLowerCase(cArray[i]) == Character.toLowerCase(cArray2[i])) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean startsWith(String string, char[] cArray, int n, boolean bl) {
        int n2 = cArray.length - n;
        if (n2 == 0) {
            return true;
        }
        if (n2 > string.length()) {
            return false;
        }
        char[] cArray2 = new char[n2];
        string.getChars(0, n2, cArray2, 0);
        if (bl) {
            for (int i = 0; i < n2; ++i) {
                if (cArray[i] == cArray2[i + n]) continue;
                return false;
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                char c = cArray2[i + n];
                if (cArray[i] == c || Character.toLowerCase(cArray[i]) == Character.toLowerCase(c)) continue;
                return false;
            }
        }
        return true;
    }

    public static final int indexOf(char c, char[] cArray, int n) {
        for (int i = n; i < cArray.length; ++i) {
            if (c != cArray[i]) continue;
            return i;
        }
        return -1;
    }

    public static final char[] subarray(char[] cArray, int n, int n2) {
        if (n2 == -1) {
            n2 = cArray.length;
        }
        if (n > n2) {
            return null;
        }
        if (n < 0) {
            return null;
        }
        if (n2 > cArray.length) {
            return null;
        }
        char[] cArray2 = new char[n2 - n];
        System.arraycopy(cArray, n, cArray2, 0, n2 - n);
        return cArray2;
    }

    protected static boolean isValidEntity(String string) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        if (n == 0) {
            return false;
        }
        if (string.charAt(0) == '#') {
            if (n == 1) {
                return false;
            }
            int n2 = 10;
            String string2 = null;
            if (string.charAt(1) == 'x') {
                n2 = 16;
                string2 = string.substring(2);
            } else {
                string2 = string.substring(1);
            }
            if (string2 == null || string2.length() == 0) {
                return false;
            }
            if (string2.charAt(0) == '-') {
                return false;
            }
            try {
                Integer.parseInt(string2, n2);
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            return true;
        }
        return false;
    }

    public static String escapeValue(String string, char c) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null) {
            int n = string.length();
            block5: for (int i = 0; i < n; ++i) {
                char c2 = string.charAt(i);
                switch (c2) {
                    case '<': {
                        stringBuffer.append(ENT_LT);
                        continue block5;
                    }
                    case '&': {
                        String string2;
                        int n2 = string.indexOf(59, i + 1);
                        if (n2 > i + 1 && StringUtils.isValidEntity(string2 = string.substring(i + 1, n2))) {
                            stringBuffer.append('&').append(string2).append(';');
                            i = n2;
                            continue block5;
                        }
                        stringBuffer.append(ENT_AMP);
                        continue block5;
                    }
                    case '\"': 
                    case '\'': {
                        if (c2 == c) {
                            stringBuffer.append(c2 == '\"' ? ENT_QUOT : ENT_APOS);
                            continue block5;
                        }
                        stringBuffer.append(c2);
                        continue block5;
                    }
                    default: {
                        stringBuffer.append(c2);
                    }
                }
            }
        }
        return stringBuffer.toString();
    }
}

