/*
 * Decompiled with CFR 0.152.
 */
package com.spket.xpc.preferences;

import com.spket.ui.internal.UIMessages;
import com.spket.ui.preferences.AbstractPreferencePage;
import com.spket.ui.preferences.OverlayPreferenceStore;
import com.spket.ui.util.StatusInfo;
import com.spket.xpc.internal.XPCMessages;
import com.spket.xpc.internal.XPCPlugin;
import java.io.File;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class ExtensionPreferencePage
extends AbstractPreferencePage {
    private Text fPath;

    protected Plugin getPlugin() {
        return XPCPlugin.getDefault();
    }

    protected String getPluginId() {
        return "com.spket.js.xpc";
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return XPCPlugin.getDefault().getPreferenceStore();
    }

    protected OverlayPreferenceStore.OverlayKey[] createOverlayStoreKeys() {
        OverlayPreferenceStore.OverlayKey[] overlayKeyArray = new OverlayPreferenceStore.OverlayKey[]{new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "ff.dir")};
        return overlayKeyArray;
    }

    protected void initialize() {
        String string;
        OverlayPreferenceStore overlayPreferenceStore = this.getOverlayPreferenceStore();
        if (this.fPath != null && (string = overlayPreferenceStore.getString("ff.dir")) != null) {
            this.fPath.setText(string);
        }
        super.initialize();
    }

    protected Control createContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)new GridData(1808));
        Group group = new Group(composite2, 0);
        group.setText(XPCMessages.Firefox_label);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(768));
        this.fPath = new Text((Composite)group, 2052);
        this.fPath.setLayoutData((Object)new GridData(768));
        Button button = new Button((Composite)group, 8);
        String string = JFaceResources.getString((String)"openBrowse");
        button.setText(string == null ? UIMessages.Browse_text : string);
        this.setButtonLayoutData(button);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                if (24 == event.type) {
                    ExtensionPreferencePage.this.onPathChanged(event);
                } else {
                    ExtensionPreferencePage.this.onBrowser(event);
                }
            }
        };
        this.fPath.addListener(24, listener);
        button.addListener(13, listener);
        return composite2;
    }

    protected void onBrowser(Event event) {
        DirectoryDialog directoryDialog = new DirectoryDialog(this.fPath.getShell(), 4096);
        String string = this.fPath.getText();
        if (string != null && string.length() > 0) {
            directoryDialog.setFilterPath(string);
        }
        if ((string = directoryDialog.open()) != null) {
            this.fPath.setText(string);
        }
    }

    protected void onPathChanged(Event event) {
        StatusInfo statusInfo = null;
        String string = this.fPath.getText();
        if (string.length() > 0) {
            if (Path.ROOT.isValidPath(string)) {
                File file = new File(string);
                if (!file.exists() && !file.isDirectory()) {
                    statusInfo = new StatusInfo(2, this.getPluginId(), XPCMessages.Path_not_exists);
                }
            } else {
                statusInfo = new StatusInfo(4, this.getPluginId(), XPCMessages.Path_invalid);
            }
        }
        if (statusInfo == null) {
            this.getOverlayPreferenceStore().setValue("ff.dir", string);
        }
        this.updateStatus((IStatus)statusInfo);
    }
}

