/*
 * Decompiled with CFR 0.152.
 */
package com.a7soft.examxml;

import com.a7soft.examxml.ExamXMLErrorHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.Properties;

public class Options {
    private static final String DO_NAMESPACES = "DoNamespaces";
    private static final String DO_SCHEMA = "DoSchema";
    private static final String SCHEMA_FULL_CHECKING = "SchemaFullChecking";
    private static final String CONTINUE_AFTER_FATAL_ERROR = "ContinueAfterFatalError";
    private static final String SHEMA_VALIDATION = "ShemaValidation";
    private static final String CASE_SENSITIVE = "CaseSensitive";
    private static final String IGNORE_WHITESPACES = "IgnoreWhitespaces";
    private static final String INSERT_COMMENTS = "InsertComments";
    private static final String COMPARE_LEVEL = "CompareLevel";
    private static final String ENCODING = "Encoding";
    private static final String XML_VERSION = "XMLVersion";
    private static final String IGNORE_ATTRIBUTES = "IgnoreAttributes";
    private static final String IGNORE_VALUES = "IgnoreValues";
    static final String UTF8 = "UTF-8";
    static final String ONE = "1";
    static final int FAST = 0;
    static final int NORMAL = 1;
    static final int SLOW = 2;
    static final int FULL = 3;
    static boolean doNamespaces = true;
    static boolean doSchema = true;
    static boolean schemaFullChecking = true;
    static boolean continueAfterFatalError = false;
    static boolean caseSensitive = true;
    static boolean ignoreWhitespaces = false;
    static int compareLevel = 3;
    static boolean insertComments = true;
    static int shemaValidation = 0;
    static String xmlVersion = "1.0";
    static boolean ignoreAttributes = false;
    static boolean ignoreValues = false;
    private static String encoding = "UTF-8";
    private static boolean encodingFromOptions;
    private static Properties properties;

    private Options() {
    }

    private static String getProperty(String key, String defaultValue) {
        String value = properties.getProperty(key);
        return value != null ? value : defaultValue;
    }

    private static boolean getProperty(String key, boolean defaultValue) {
        String value = properties.getProperty(key);
        return value != null ? ONE.equals(value) : defaultValue;
    }

    private static int getProperty(String key, int defaultValue) {
        String value = properties.getProperty(key);
        return value != null ? Integer.parseInt(value) : defaultValue;
    }

    public static boolean loadOptions(String fileName) {
        if (fileName == null) {
            return true;
        }
        File file = new File(fileName);
        if (file.exists()) {
            properties = new Properties();
            try {
                properties.load(new FileInputStream(file));
                doNamespaces = Options.getProperty(DO_NAMESPACES, doNamespaces);
                doSchema = Options.getProperty(DO_SCHEMA, doSchema);
                schemaFullChecking = Options.getProperty(SCHEMA_FULL_CHECKING, schemaFullChecking);
                continueAfterFatalError = Options.getProperty(CONTINUE_AFTER_FATAL_ERROR, continueAfterFatalError);
                shemaValidation = Options.getProperty(SHEMA_VALIDATION, shemaValidation);
                caseSensitive = Options.getProperty(CASE_SENSITIVE, caseSensitive);
                ignoreWhitespaces = Options.getProperty(IGNORE_WHITESPACES, ignoreWhitespaces);
                compareLevel = Options.getProperty(COMPARE_LEVEL, compareLevel);
                insertComments = Options.getProperty(INSERT_COMMENTS, insertComments);
                xmlVersion = Options.getProperty(XML_VERSION, xmlVersion);
                ignoreAttributes = Options.getProperty(IGNORE_ATTRIBUTES, ignoreAttributes);
                ignoreValues = Options.getProperty(IGNORE_VALUES, ignoreValues);
                Options.setEncoding(Options.getProperty(ENCODING, null), true);
            }
            catch (IOException e) {
                ExamXMLErrorHandler.printError(e);
                return false;
            }
            return true;
        }
        return false;
    }

    public static void setDoNamespaces(boolean doNamespaces) {
        Options.doNamespaces = doNamespaces;
    }

    public static void setDoSchema(boolean doSchema) {
        Options.doSchema = doSchema;
    }

    public static void setSchemaFullChecking(boolean schemaFullChecking) {
        Options.schemaFullChecking = schemaFullChecking;
    }

    public static void setContinueAfterFatalError(boolean continueAfterFatalError) {
        Options.continueAfterFatalError = continueAfterFatalError;
    }

    public static void setCaseSensitive(boolean caseSensitive) {
        Options.caseSensitive = caseSensitive;
    }

    public static void setIgnoreWhitespaces(boolean ignoreWhitespaces) {
        Options.ignoreWhitespaces = ignoreWhitespaces;
    }

    public static void setShemaValidation(int shemaValidation) {
        Options.shemaValidation = shemaValidation;
    }

    public static void setInsertComments(boolean insertComments) {
        Options.insertComments = insertComments;
    }

    private static void setEncoding(String encoding) {
        try {
            if (Charset.isSupported(encoding)) {
                Options.encoding = encoding;
            }
        }
        catch (IllegalCharsetNameException e) {
            e.printStackTrace();
        }
    }

    public static void setEncoding(String encoding, boolean options) {
        if (encoding != null) {
            if (options || !encodingFromOptions) {
                Options.setEncoding(encoding);
            }
            if (options) {
                encodingFromOptions = true;
            }
        }
    }

    static boolean isFullComparison() {
        return compareLevel == 3;
    }

    static String getEncoding() {
        return encoding;
    }

    public static void setIgnoreAttributes(boolean ignoreAttributes) {
        Options.ignoreAttributes = ignoreAttributes;
    }

    public static void setIgnoreValues(boolean ignoreValues) {
        Options.ignoreValues = ignoreValues;
    }
}

