/*
 * Decompiled with CFR 0.152.
 */
package com.a7soft.examxml;

import com.a7soft.examxml.ExamXML;
import com.a7soft.examxml.Options;
import com.a7soft.examxml.XMLString;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Element {
    static final char LT = '<';
    static final char GT = '>';
    static final char SB = ' ';
    static final char QUOT = '\"';
    static final char EQUAL = '=';
    static final char AMP = '&';
    static final char CR = '\r';
    static final char LF = '\n';
    static final char BEGIN_ATTR = '\u0001';
    static final char END_ATTR = '\u0002';
    static final String CLOSE_TAG_ELEMENT = "/>";
    static final String OPEN_TAG_ELEMENT = "</";
    static final String EOL = System.getProperty("line.separator");
    private static final String XML_HEADER = "<?xml version=\"VERSION\" encoding=\"CHARSET\"?>";
    private static final String VERSION = "VERSION";
    private static final String CHARSET = "CHARSET";
    private static final String START_COMMENT = "<!-- ";
    private static final String END_COMMENT = " -->";
    private static final String[] ELEMENT_COMMENTS = new String[]{"Added Element(s)", "Deleted Element(s)", "Changed Element:old", "Changed Element:new"};
    static final int NO_COMMENTS = 0;
    static final int ADDED_ELEMENTS = 1;
    static final int DELETED_ELEMENTS = 2;
    static final int OLD_ELEMENTS = 3;
    static final int NEW_ELEMENTS = 4;
    private static int currentComment = 0;
    private static final int CAN_HASH = 47;
    private Element parent;
    private Element partner;
    private int lineNumber;
    private int iName;
    private String qName;
    private String attributes;
    private String value;
    private int canonicalName;
    private ArrayList<Element> children;
    private HashMap<Element, Element> elements;
    private HashMap<Integer, ArrayList<Element>> names;
    private int hashSubNames;
    private int subchildren;
    private int hashAttr0;
    private int hashAttr1;
    private int hashValue0;
    private int hashValue1;
    private int hashSubAttrs0;
    private int hashSubAttrs1;
    private int hashSubValue0;
    private int hashSubValue1;
    private int valueLen;
    private int subValueLen;
    private int attrLen;
    private int subAttrLen;
    private int hash;
    private static HashMap<String, Integer> elementNames = new HashMap();

    private static int addName(String qname) {
        int i;
        Integer ref = elementNames.get(qname);
        if (ref == null) {
            i = elementNames.size() + 1;
            elementNames.put(qname, i);
        } else {
            i = ref;
        }
        return i;
    }

    Element(String qname, Attributes attrs, Element parent, int canName, int lineNumber) {
        int len;
        this.qName = qname;
        this.iName = Element.addName(qname);
        this.parent = parent;
        this.lineNumber = lineNumber;
        this.canonicalName = canName * 47 + this.iName;
        int n = len = Options.ignoreAttributes ? 0 : attrs.getLength();
        if (len > 0) {
            StringBuffer at = new StringBuffer();
            for (int i = 0; i < len; ++i) {
                String aName = attrs.getQName(i);
                String aValue = attrs.getValue(i);
                XMLString.hash(aName);
                int hn0 = XMLString.getHash0();
                int hn1 = XMLString.getHash1();
                this.attrLen += XMLString.hash(aValue, Options.ignoreWhitespaces, Options.caseSensitive);
                this.hashAttr0 += XMLString.getHash0() * hn0;
                this.hashAttr1 += XMLString.getHash1() ^ hn1;
                if (!ExamXML.isPrinting()) continue;
                if (at.length() > 0) {
                    at.append(' ');
                }
                at.append(aName).append('=').append('\u0001').append(aValue).append('\u0002');
            }
            this.attributes = at.toString();
        }
    }

    void setValue(StringBuffer sb) {
        if (sb.length() > 0) {
            this.value = this.value == null ? sb.toString() : this.value.concat(sb.toString());
            sb.setLength(0);
        }
    }

    void closeElement() {
        this.valueLen = XMLString.hash(this.value, Options.ignoreWhitespaces, Options.caseSensitive);
        this.hashValue0 = XMLString.getHash0();
        this.hashValue1 = XMLString.getHash1();
        this.hash = (1 + this.valueLen) * (this.hashValue0 ^ this.hashValue1) + (3 + this.attrLen) * (this.hashAttr0 ^ this.hashAttr1) + (5 + this.subValueLen) * (this.hashSubValue0 ^ this.hashSubValue1) + (7 + this.subAttrLen) * (this.hashSubAttrs0 ^ this.hashSubAttrs1) + (9 + this.canonicalName) * (this.subchildren + 17);
        if (!ExamXML.isPrinting()) {
            this.qName = null;
            this.value = null;
        }
    }

    void addElement(Element element) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(element);
        this.subchildren += element.subchildren + 1;
        this.hashSubNames += element.hashSubNames + element.iName;
        this.subValueLen += element.subValueLen + element.valueLen;
        this.subAttrLen += element.subAttrLen + element.attrLen;
        this.hashSubValue0 += element.hashValue0 + element.hashSubValue0;
        this.hashSubValue1 += (element.hashValue1 + element.hashSubValue1) * (element.iName + 15);
        this.hashSubAttrs0 += element.hashAttr0 + element.hashSubAttrs0;
        this.hashSubAttrs1 += (element.hashAttr1 + element.hashSubAttrs1) * (element.iName + 11);
    }

    void setPartner(Element element) {
        this.partner = element;
        element.partner = this;
    }

    private boolean equalAttrs(Element element) {
        return this.attrLen != 0 && this.attrLen == element.attrLen && this.hashAttr0 == element.hashAttr0 && this.hashAttr1 == element.hashAttr1;
    }

    private boolean equalValue(Element element) {
        return this.valueLen != 0 && this.valueLen == element.valueLen && this.hashValue0 == element.hashValue0 && this.hashValue1 == element.hashValue1;
    }

    private boolean equalSubElemenets(Element element) {
        return this.subchildren != 0 && this.hashSubNames == element.hashSubNames && this.subValueLen == element.subValueLen && this.subAttrLen == element.subAttrLen && this.hashSubValue0 == element.hashSubValue0 && this.hashSubValue1 == element.hashSubValue1 && this.hashSubAttrs0 == element.hashSubAttrs0 && this.hashSubAttrs1 == element.hashSubAttrs1;
    }

    private boolean equalElement(Element element) {
        return element != null && this.iName == element.iName && this.valueLen == element.valueLen && this.attrLen == element.attrLen && this.hashValue0 == element.hashValue0 && this.hashValue1 == element.hashValue1 && this.hashAttr0 == element.hashAttr0 && this.hashAttr1 == element.hashAttr1;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Element) {
            Element element = (Element)obj;
            return this.canonicalName == element.canonicalName && this.subchildren == element.subchildren && this.hashSubNames == element.hashSubNames && this.iName == element.iName && this.hash == element.hash && this.subValueLen == element.subValueLen && this.subAttrLen == element.subAttrLen && this.hashSubValue0 == element.hashSubValue0 && this.hashSubValue1 == element.hashSubValue1 && this.hashSubAttrs0 == element.hashSubAttrs0 && this.hashSubAttrs1 == element.hashSubAttrs1 && this.valueLen == element.valueLen && this.attrLen == element.attrLen && this.hashValue0 == element.hashValue0 && this.hashValue1 == element.hashValue1 && this.hashAttr0 == element.hashAttr0 && this.hashAttr1 == element.hashAttr1;
        }
        return false;
    }

    public int hashCode() {
        return this.hash;
    }

    private HashMap<Element, Element> fillElements() {
        if (this.elements == null) {
            this.elements = new HashMap();
            for (Element child : this.children) {
                while (this.elements.get(child) != null) {
                    child.hash += 1007;
                }
                this.elements.put(child, child);
            }
        }
        return this.elements;
    }

    private void addNotFindElement(Element element) {
        ArrayList<Element> list;
        if (this.names == null) {
            this.names = new HashMap();
        }
        if ((list = this.names.get(element.iName)) == null) {
            list = new ArrayList();
            this.names.put(element.iName, list);
        }
        list.add(element);
    }

    private void createNames() {
        for (Element child : this.children) {
            if (child.partner != null) continue;
            this.addNotFindElement(child);
        }
    }

    private static boolean swap(Element left, Element right) {
        if (left.elements != null && right.elements != null) {
            return left.children.size() < right.children.size();
        }
        if (left.elements == null && right.elements == null) {
            return left.children.size() > right.children.size();
        }
        return left.elements == null;
    }

    private static int testElements(Element left, Element right) {
        int result = 0;
        if (left.children != null && right.children != null) {
            if (Element.swap(left, right)) {
                Element temp = left;
                left = right;
                right = temp;
            }
            left.fillElements();
            for (Element child : right.children) {
                if (!left.elements.containsKey(child)) continue;
                ++result;
            }
            result = result * 200 / (left.children.size() + right.children.size());
        }
        return result;
    }

    static boolean compareElements(Element left, Element right) {
        left.setPartner(right);
        if (left.equals(right)) {
            return true;
        }
        if (left.children != null && right.children != null) {
            Element temp;
            if (Element.swap(left, right)) {
                temp = left;
                left = right;
                right = temp;
            }
            left.fillElements();
            for (Element child : right.children) {
                Element e = left.elements.get(child);
                if (e != null) {
                    Element.compareElements(child, e);
                    continue;
                }
                if (!Options.isFullComparison()) continue;
                right.addNotFindElement(child);
            }
            if (Options.isFullComparison()) {
                left.createNames();
                if (left.names != null && right.names != null) {
                    if (left.names.size() > right.names.size()) {
                        temp = left;
                        left = right;
                        right = temp;
                    }
                    for (Integer i : left.names.keySet()) {
                        ArrayList<Element> list = right.names.get(i);
                        if (list == null) continue;
                        Element.compareSubElements(list, left.names.get(i));
                    }
                }
            }
            left.clearElements();
            right.clearElements();
        }
        return false;
    }

    private static void compareSubElements(ArrayList<Element> list0, ArrayList<Element> list1) {
        if (list0.size() == 1 && list1.size() == 1) {
            Element.compareElements(list0.get(0), list1.get(0));
            return;
        }
        if (list0.size() > list1.size()) {
            Element.compareSubElements(list1, list0);
            return;
        }
        for (Element element0 : list0) {
            int max = 0;
            Element good = null;
            for (Element element1 : list1) {
                if (element1.partner != null) continue;
                if (element0.equalSubElemenets(element1)) {
                    good = element1;
                    break;
                }
                int i = 0;
                if (element0.equalAttrs(element1)) {
                    i += 50;
                }
                if (element0.equalValue(element1)) {
                    i += 25;
                }
                if ((i += Element.testElements(element0, element1)) <= max) continue;
                max = i;
                good = element1;
            }
            if (good == null) continue;
            Element.compareElements(element0, good);
        }
    }

    private void clearElements() {
        if (this.elements != null) {
            this.elements.clear();
            this.elements = null;
        }
        if (this.names != null) {
            this.names.clear();
            this.names = null;
        }
    }

    String getQName() {
        return this.qName;
    }

    int getIName() {
        return this.iName;
    }

    int getCanonicalName() {
        return this.canonicalName;
    }

    int getLineNumber() {
        return this.lineNumber;
    }

    Element getParent() {
        return this.parent;
    }

    Element getPartner() {
        return this.partner;
    }

    String getAttributes() {
        return this.attributes;
    }

    String getValue() {
        return this.value;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(60);
        sb.append(this.qName);
        if (this.attributes != null) {
            sb.append(' ').append(this.attributes);
        }
        if (this.value != null || this.children != null) {
            sb.append('>');
            if (this.value != null) {
                sb.append(this.value);
            }
            if (this.children != null) {
                for (Element child : this.children) {
                    sb.append(child.toString());
                }
            }
            sb.append(OPEN_TAG_ELEMENT).append(this.qName).append('>');
        } else {
            sb.append(CLOSE_TAG_ELEMENT);
        }
        return sb.toString();
    }

    private void dispatchElement(Writer writer) throws IOException {
        if (this.partner == null || this.equals(this.partner)) {
            this.printElement(writer, true, this.partner == null ? 2 : 0);
        } else if (this.equalElement(this.partner)) {
            this.printElement(writer, false, 0);
        } else {
            this.printElement(writer, true, 3);
            this.partner.printElement(writer, true, 4);
        }
    }

    void printElement(Writer writer, boolean simple, int comment) throws IOException {
        if (ExamXML.isMerge() || ExamXML.isDiff() && (this.partner == null || !this.equals(this.partner))) {
            if (Options.insertComments) {
                Element.printComment(writer, comment);
            }
            writer.write(60);
            writer.write(this.qName);
            if (this.attributes != null) {
                writer.write(32);
                XMLString.normalize(writer, this.attributes, true);
            }
            if (simple && this.value == null && this.children == null) {
                writer.write(CLOSE_TAG_ELEMENT);
                writer.write(EOL);
            } else {
                writer.write(62);
                if (this.value != null) {
                    XMLString.normalize(writer, this.value, false);
                }
                if (this.children != null) {
                    writer.write(EOL);
                    for (Element child : this.children) {
                        if (simple) {
                            child.printElement(writer, true, 0);
                            continue;
                        }
                        child.dispatchElement(writer);
                    }
                }
                if (!simple && this.partner != null) {
                    this.partner.printDeletedElements(writer);
                }
                writer.write(OPEN_TAG_ELEMENT);
                writer.write(this.qName);
                writer.write(62);
                writer.write(EOL);
            }
        }
    }

    void printDeletedElements(Writer writer) throws IOException {
        if (this.children != null) {
            for (Element child : this.children) {
                if (child.partner != null) continue;
                child.printElement(writer, true, 1);
            }
        }
    }

    static void printXMLHeader(Writer writer) throws IOException {
        writer.write(XML_HEADER.replaceFirst(VERSION, Options.xmlVersion).replaceFirst(CHARSET, Options.getEncoding()));
        writer.write(EOL);
    }

    private static void printComment(Writer writer, int comment) throws IOException {
        if (comment != currentComment && comment > 0) {
            writer.write(START_COMMENT);
            writer.write(ELEMENT_COMMENTS[comment - 1]);
            writer.write(END_COMMENT);
            writer.write(EOL);
        }
        currentComment = comment;
    }
}

