/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jdbc.base;

import com.microsoft.jdbc.base.BaseColumns;
import com.microsoft.jdbc.base.BaseData;
import com.microsoft.jdbc.base.BaseExceptions;
import com.microsoft.jdbc.base.BasePreparedStatement;
import com.microsoft.jdbc.base.BaseResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public final class BaseResultSetMetaData
implements ResultSetMetaData {
    private static String footprint = "$Revision:   1.6.1.0  $";
    protected Object associate;
    protected BaseColumns columns;
    BaseExceptions exceptions;

    protected BaseResultSetMetaData(Object object, BaseExceptions baseExceptions) {
        this.associate = object;
        this.exceptions = baseExceptions;
        this.setupColumns();
    }

    public String getCatalogName(int n) throws SQLException {
        this.validateClosedState();
        this.validateColumnIndex(n);
        return this.columns.get((int)n).catalogName;
    }

    public String getColumnClassName(int n) throws SQLException {
        this.validateClosedState();
        this.validateColumnIndex(n);
        return BaseData.mapJDBCTypeToJavaObjectTypeName(this.columns.get((int)n).type);
    }

    public int getColumnCount() throws SQLException {
        this.validateClosedState();
        return this.columns.count(1);
    }

    public int getColumnDisplaySize(int n) throws SQLException {
        this.validateClosedState();
        this.validateColumnIndex(n);
        return this.columns.get((int)n).displaySize;
    }

    public String getColumnLabel(int n) throws SQLException {
        this.validateClosedState();
        this.validateColumnIndex(n);
        return this.columns.get((int)n).label;
    }

    public String getColumnName(int n) throws SQLException {
        this.validateClosedState();
        this.validateColumnIndex(n);
        return this.columns.get((int)n).name;
    }

    public int getColumnType(int n) throws SQLException {
        this.validateClosedState();
        this.validateColumnIndex(n);
        return this.columns.get((int)n).type;
    }

    public String getColumnTypeName(int n) throws SQLException {
        this.validateClosedState();
        this.validateColumnIndex(n);
        return this.columns.get((int)n).typeName;
    }

    public int getPrecision(int n) throws SQLException {
        this.validateClosedState();
        this.validateColumnIndex(n);
        return this.columns.get((int)n).precision;
    }

    public int getScale(int n) throws SQLException {
        this.validateClosedState();
        this.validateColumnIndex(n);
        return this.columns.get((int)n).scale;
    }

    public String getSchemaName(int n) throws SQLException {
        this.validateClosedState();
        this.validateColumnIndex(n);
        return this.columns.get((int)n).schemaName;
    }

    public String getTableName(int n) throws SQLException {
        this.validateClosedState();
        this.validateColumnIndex(n);
        return this.columns.get((int)n).tableName;
    }

    public boolean isAutoIncrement(int n) throws SQLException {
        this.validateClosedState();
        this.validateColumnIndex(n);
        return this.columns.get((int)n).isAutoIncrement;
    }

    public boolean isCaseSensitive(int n) throws SQLException {
        this.validateClosedState();
        this.validateColumnIndex(n);
        return this.columns.get((int)n).isCaseSensitive;
    }

    public boolean isCurrency(int n) throws SQLException {
        this.validateClosedState();
        this.validateColumnIndex(n);
        return this.columns.get((int)n).isCurrency;
    }

    public boolean isDefinitelyWritable(int n) throws SQLException {
        this.validateClosedState();
        this.validateColumnIndex(n);
        return this.columns.get((int)n).isDefinitelyWritable;
    }

    public int isNullable(int n) throws SQLException {
        this.validateClosedState();
        this.validateColumnIndex(n);
        return this.columns.get((int)n).isNullable;
    }

    public boolean isReadOnly(int n) throws SQLException {
        this.validateClosedState();
        this.validateColumnIndex(n);
        return this.columns.get((int)n).isReadOnly;
    }

    public boolean isSearchable(int n) throws SQLException {
        this.validateClosedState();
        this.validateColumnIndex(n);
        return this.columns.get((int)n).isSearchable;
    }

    public boolean isSigned(int n) throws SQLException {
        this.validateClosedState();
        this.validateColumnIndex(n);
        return this.columns.get((int)n).isSigned;
    }

    public boolean isWritable(int n) throws SQLException {
        this.validateClosedState();
        this.validateColumnIndex(n);
        return this.columns.get((int)n).isWritable;
    }

    private void setupColumns() {
        this.columns = this.associate instanceof BaseResultSet ? ((BaseResultSet)this.associate).columns : ((BasePreparedStatement)this.associate).currentColumns;
    }

    private void validateClosedState() throws SQLException {
        if (this.associate instanceof BaseResultSet) {
            ((BaseResultSet)this.associate).validateClosedState();
        } else {
            ((BasePreparedStatement)this.associate).validateClosedState();
        }
    }

    private void validateColumnIndex(int n) throws SQLException {
        if (!this.columns.isValidColumnOrdinal(n)) {
            Integer n2 = new Integer(n);
            String[] stringArray = new String[]{n2.toString()};
            throw this.exceptions.getException(6007, stringArray);
        }
    }
}

