<%@ page language="java" import="java.sql.*, java.util.*, com.kplab.webeasy.Util,
    com.kplab.webeasy.OrderBean.*, com.kplab.webeasy.OrderInfo,
    com.kplab.webeasy.OrderItem" contentType="text/html" %>

<jsp:useBean id="OrderBean" scope="session" class="com.kplab.webeasy.OrderBean" />

<%
//    response.setHeader("Pragma", "no-cache");
//    response.setHeader("Cache-Control", "no-cache");
//    response.setHeader("Expires", "0");
%>
          
<html>
<head>
<title>123-WebEasy Order Management</title>
<meta http-equiv="Content-Type" content="text/html">
</head>

<%! int MAX_PER_PAGE = 20; %>
<%! int DISPLAY_LANG = 1;  %>
<% 
    /****************************************/
    /******* Variables Initialization *******/
    /****************************************/

    int from_day=1, from_month=1, from_year=2000;
    int to_day=31, to_month=12, to_year=2005;
    try {
      from_day = Integer.parseInt(request.getParameter("FromDay"));
      from_month = Integer.parseInt(request.getParameter("FromMonth"));
      from_year = Integer.parseInt(request.getParameter("FromYear"));
      to_day = Integer.parseInt(request.getParameter("ToDay"));
      to_month = Integer.parseInt(request.getParameter("ToMonth"));
      to_year = Integer.parseInt(request.getParameter("ToYear"));
    }
    catch (Exception e) {
      %>Sorry, the page you selected does not exist.<%
      return;
    }
    Timestamp from_time = new Timestamp(from_year-1900, from_month-1, from_day, 0, 0, 0, 0);
    Timestamp to_time = new Timestamp(to_year-1900, to_month-1, to_day, 23, 59, 59, 999900000);

    int num_of_match=0, display_index=0, from_id=0, to_id=0;
    if (request.getParameter("num_of_match") == null  ||
        request.getParameter("display_index") == null ||
        request.getParameter("from_id") == null       ||
        request.getParameter("to_id") == null)
    {
      /* First Call */
      from_id = OrderBean.getMinOrderID(from_time);
      to_id = OrderBean.getMaxOrderID(to_time);
      num_of_match = OrderBean.getCount(from_id, to_id);
      display_index = 0;
    }
    else
    {
      /* Subsequent Calls */
      try {
        num_of_match = Integer.parseInt(request.getParameter("num_of_match"));
        display_index = Integer.parseInt(request.getParameter("display_index"));
        from_id = Integer.parseInt(request.getParameter("from_id"));
        to_id = Integer.parseInt(request.getParameter("to_id"));
      }
      catch (Exception e) {
        %>Sorry, the page you selected does not exist.<%
        return;
      }
    }

    /*** Retrieve list of orders ***/
    OrderBean.refreshInfoList(from_id, to_id, MAX_PER_PAGE);
    int infolist_size = OrderBean.getInfoListSize();
%>



<body background="../images/bg.gif" bgcolor="white" marginheight="0" marginwidth="0"
      topmargin="5" leftmargin="5">

<font color="#800080" size="5" face="Arial"><strong>List Order Information</strong></font>

<%
    if (infolist_size == 0)
    {
%>
  <p>Sorry, no records meet your selection criteria.</p>
<%
    }
    else
    {

    /******************************************/
    /******* Number of records retrieved ******/
    /******************************************/
%>
  <p>Total <%= Integer.toString(num_of_match) %> records are found from
           <%= Integer.toString(from_day) %>/<%= Integer.toString(from_month) %>/<%=
               Integer.toString(from_year) %> to
           <%= Integer.toString(to_day) %>/<%= Integer.toString(to_month) %>/<%=
               Integer.toString(to_year) %>.</p>



  <form action="ListOrderInfo.jsp" method="POST">
    <table border="1" width="100%" cellspacing="2" cellpadding="3">

      <tr>
        <td align="center">Order date and time</td>
        <td align="center">Order ID</td>
        <td align="center">Customer ID</td>
        <td align="center">Customer surname</td>
        <td align="center">Customer first name</td>
        <td align="center">Order amount</td>
        <td align="center">Payment method</td>
        <td align="center">Cardholder name</td>
        <td align="center">Card number</td>
        <td align="center">Card expiration date</td>
        <td align="center">Recipient's surname</td>
        <td align="center">Recipient's first name</td>
        <td align="center">Recipient's phone</td>
        <td align="center">Recipient's address</td>
      </tr>

<%
    /******************************************/
    /*************** Order Info ***************/
    /******************************************/

      int last_order_id=0;
      for (int i=0; i<infolist_size; i++)
      {
        display_index++;
        OrderInfo order_info = OrderBean.getOrderInfoAt(i);
        int order_id = order_info.getOrderID();
        Timestamp order_time = order_info.getOrderTime();
        int expiry_month = order_info.getExpiryMonth();
        int expiry_year = order_info.getExpiryYear();
        String customer_id = order_info.getCustomerID();
        String customer_last_name = order_info.getCustomerLastName();
        String customer_first_name = order_info.getCustomerFirstName();
        String payment_method = order_info.getPaymentMethod();
        String cardholder_name = order_info.getCardholderName();
        String card_number = order_info.getCardNumber();
        String recipient_last_name = order_info.getRecipientLastName();
        String recipient_first_name = order_info.getRecipientFirstName();
        String recipient_phone = order_info.getRecipientPhone();
        String recipient_address = order_info.getRecipientAddress();
        double total_amount = order_info.getTotalAmount();

        String link = "ShowOrderDetail.jsp?OrderID=" + Integer.toString(order_id);
%>

      <tr>
        <td align="center" nowrap><%= order_time           %></td>
        <td align="center" nowrap><a href="<%= link %>">
                                  <%= Util.padInteger(order_id, 10) %></a></td>
        <td align="center" nowrap><%= customer_id          %></td>
        <td align="center" nowrap><%= customer_last_name   %></td>
        <td align="center" nowrap><%= customer_first_name  %></td>
        <td align="center" nowrap><%= Double.toString(total_amount) %></td>
        <td align="center" nowrap><%= payment_method       %></td>
        <td align="center" nowrap><%= cardholder_name      %></td>
        <td align="center" nowrap><%= card_number          %></td>
        <td align="center" nowrap><%= Integer.toString(expiry_month) %>/
                                  <%= Integer.toString(expiry_year) %></td>
        <td align="center" nowrap><%= recipient_last_name  %></td>
        <td align="center" nowrap><%= recipient_first_name %></td>
        <td align="center" nowrap><%= recipient_phone      %></td>
        <td align="center" nowrap><%= recipient_address    %></td>
      </tr>
<%
        last_order_id = order_id;
      }

      if (last_order_id < to_id)
      {
        from_id = last_order_id + 1;
%>
      <input type="hidden" name="FromDay" value="<%= Integer.toString(from_day) %>">
      <input type="hidden" name="FromMonth" value="<%= Integer.toString(from_month) %>">
      <input type="hidden" name="FromYear" value="<%= Integer.toString(from_year) %>">

      <input type="hidden" name="ToDay" value="<%= Integer.toString(to_day) %>">
      <input type="hidden" name="ToMonth" value="<%= Integer.toString(to_month) %>">
      <input type="hidden" name="ToYear" value="<%= Integer.toString(to_year) %>">

      <input type="hidden" name="num_of_match" value="<%= Integer.toString(num_of_match) %>">
      <input type="hidden" name="display_index" value="<%= Integer.toString(display_index) %>">
      <input type="hidden" name="from_id" value="<%= Integer.toString(from_id) %>">
      <input type="hidden" name="to_id" value="<%= Integer.toString(to_id) %>">

      <tr>
        <td align="left" colspan="16"><input type="submit" value="Next Page">
          <a href="index.html">Exit</a>
        </td>
      </tr>
<%
      }
%>

    </table>
  </form>
<%
    }
%>

</body>
</html>
