#ifndef LINT
static char SCCSidI[] = "@(#) ./comm/save/initpvm.c 07/23/93";
#endif

/*  
     There may be a problem with the way this is intended to run.
  The main process sets a link for the executable then immediately tells
  the other processor (with an initiate()) to run it. It seems that the
  other machine may look for the link and not find it, because it
  has been cached somehow. We need a way of flushing over the entire
  NFS network of any directory caches.

     I put a sleep() in but that is not very satisfactory. 

*/

/*  PVM has many bad design decisions; we should write them down and 
grind our teeth. But I don't want to change it at all; we must write
an interface so we can use standard PVM without changing our upper level
code.

  1) Limited path for looking for executables.
  2) Does not set a reasonable working directory.
  3) Does not pass command line.
  4) There is no routine to return the number of machines of 
     a particular architecture.
  5) stderr and stdout go to where the deamons are started up.
  6) makes no attempt to catch interupts on user process; one could
     die and the PVM system wouldn't even know.
  7) in unpacking messages user must know exactly how they were packed.
  8) Must have a pvm daemon running that has the number of processors
     you want.  You can't simply generate a list of processors to run
     on (it really is a virtual machine, defined statically).  We'll
     fix this by starting one with the list of workstations to use.

  In order to handle (1), we need to establish links to the appropriate 
  machines (PVMCreateLink).  2-3 are handled by PIcall startup code.
  There isn't much that we can do about 5; 6 we attempt to handle by
  catching the interrupts.  7 is a feature.  4 and 8 go together, and
  are tricky to deal with.  

  Since PVM won't tell us what machines are available, we may need the
  name of the file that started the pvmd.  If we don't have that, we
  have to fake it.
*/

#define MAXFILELEN 31 /* limit of PVM */

#include "comm/comm.h"
#include "comm/hosts.h"
#include "system/system.h"
#include <stdio.h>
#include <string.h>
#include <pwd.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/param.h>

#if defined(intelnx)
typedef u_short uid_t;
typedef u_short gid_t;
#endif

void PVMCreateLink();
void PVMRemoveLinks();
void PVMArchType();
void PVMexitall();
extern char *getenv();

/* This defines these values */
int  __PVMFROM, __PVMLEN, __PVMTYPE, __PVMGLOBALTYPE;
char __PVM_COMPONENT[MAXFILELEN];
int  __MYPROCID, __NUMNODES;

static int pvmdpid = 0;
#if defined(LOGCOMMDISABLE)
#define LOGpush()
#define LOGpop()
#endif

/* 
   PIcall - version for PVM. It uses argv[0] to determine the 
            name of the other np-1 instances of the  process group. 
   
  Things still needed to be done for this interface.

   1) Check if pvmd is running; if not create hosttable and start it up

   ??? HeNCE

*/

PIcall(np, procgroup, dummy, routine, argc, argv)
int  np, argc;
char **procgroup, *dummy;
char **argv;
int  (*routine)();
{
  HostTable *table, *utable;
  int       i,j,k,l,count,len,fsec, maxarches = MAXARCHES;
  char      cwd[MAXPATHLEN],arch[20], bname[MAXFILELEN], *machine;
  char      fname[MAXPATHLEN];
  char      *archpath,*path, hostfile[MAXPATHLEN], oarch[20];
  Arch      narch,iarch;
  FILE      *fd;

  /* setup to catch interrupts; include ^C */
  SYDefaultSignals( SYDefaultHandler );
  signal( SIGINT, SYDefaultHandler ); 

  /* set the exit routine */
  SYSetExitAll(PVMexitall);

  /* determine base name of our, to be created, process group */
  PIBaseName( argv[0],0,bname, MAXFILELEN );
  strncpy(__PVM_COMPONENT,bname,MAXFILELEN);

  /* enroll in pvm */
  __MYPROCID  = enroll( __PVM_COMPONENT ); 
  if (__MYPROCID < 0) {
      /* Try to start a daemon */
      if (PIiPVMStartPVMD( 0 ) == -1) return -1;
      __MYPROCID  = enroll( __PVM_COMPONENT ); 
      if (__MYPROCID < 0) {
	  /* Give up */
	  fprintf(stderr,"Error enrolling in PVM %d \n",__MYPROCID);
	  SETERR(1); return 0;
	  }
      }

  /* determine our arch */
  SYArchType(arch,20); narch = PIStringToArch(arch);

  LOGpush(); LOGDISABLE;
  if (__MYPROCID) {  /* we are a worker processor */
    /* receive number of processors */
    RECVSYNC(10001,&__NUMNODES,sizeof(int),MSG_INT);

    /* If we are over the limit of number of nodes, we should exit here ? */

    /* receive resource limits */
    PIBroadcastLimits( &cpu, &mem, &pf, &maxtime, &niceval, 0,(ProcSet *)0 );
    SYSetLimits( mem, cpu, pf, &maxtime );
    if (niceval > 0) SYNice( niceval );

    /* receive the command line */
    PIBroadcastArgs( &argc, &argv, 0, (ProcSet *)0 ); 
    PIGetDebugArgs( &argc, argv );

    /* get the current working directory and chdir to it*/
    GSCATTER(&len, sizeof(int), 0, (ProcSet *)0, MSG_INT);
    GSCATTER(cwd, len, 0, (ProcSet *)0, MSG_OTHER);
    chdir(cwd);

    /* pass to user code */
    LOGpop();
    PIinitlog();
    (*routine)(argc,argv);
    PIendlog();
    GSYNC((ProcSet*)0);
    leave();
    return;
  } 

  /* we are the host process; */
  /* determine if we have enough processors */
  SYArgGetInt( &argc, argv, 1, "-np", &np );
  pstatus( &__NUMNODES, (int *)0 );
  if (__NUMNODES < np) { 
    fprintf(stderr,"Not enough processors: want %d total %d \n",np,__NUMNODES);
    SETERR(2); leave(); if (pvmdpid) kill( pvmdpid, SIGINT); return -1;
  }
  __NUMNODES = np--; 

  /* Get resource limits */
  SYGetResourceDefaults( &cpu, &mem, &pf, &niceval, &fsec );
  gettimeofday( &maxtime, 0 );  maxtime.tv_sec += fsec;
  SYGetResourceLimits( &argc, argv, &cpu, &mem, &pf, &maxtime, 0 );

  SYGetwd( cwd, MAXPATHLEN );
#ifndef FOO  
/* Note that this should really be generated from the file that started the
   pvmd */ 
utable = 0;
table  = 0;
if (!pvmdpid && PIiPVMFormHostTable( &utable, &table, 
				     np, mem, cpu, pf, arch, bname, 
				     cwd, &argc, &argv ) == -1) { 
    leave(); return -1; }
#else 
  /* get environmental variables needed  */
  SYGetwd( cwd, MAXPATHLEN );
  archpath = getenv("TOOLSARCHES");if (!archpath) archpath = arch;
  path = getenv("PATH"); if (!path) path = cwd;

  /* Get database of available processors */
  SYGetFileFromEnvironment( "TOOLSHOST", DEFAULTTOOLSHOST,
                            "hosts", hostfile, 'r' ); 
  fd = fopen(hostfile,"r"); 
  if (!fd) {
    fprintf(stderr,"Could not open hosts database %s \n",hostfile);
    SETERR(1); leave(); return -1;
  }
  table = PIReadInHostTable(fd, mem, cpu, pf, 0); fclose(fd); 
  if (!table) {leave(); SETERRC(2,"Could not get hosttable"); return -1;}
  utable = 
    PIBuildHostTable(bname,np,table,&argc,&argv,path,archpath,
		     (char *)0,narch,cwd,0); 
#endif

if (!pvmdpid && !utable) {leave(); SETERRC(3,"Could not get host table"); 
                          return -1;}

#ifndef FOO
if (pvmdpid || !utable) {
    if (!PIFullPathFromBase(bname,-1,(char *)0,path,fname,MAXPATHLEN,cwd)) 
	strcpy(fname,bname);
    }
if (PIiPVMCreateLinks( utable, maxarches, bname, arch, fname ) 
    == -1) return -1;
if (PIiPVMStartWorkers( utable, maxarches, bname, np, fname ) 
    == -1) return -1;
#else
  /* loop over the arches in utable starting up the processes */
  count = 0;
  for ( i=0; i<maxarches; i++ ) {
    if (utable->archtable[i].np) {
      /* this bit of code is to get around a stupid feature of PVM */
      /* makes a link of executable to the users $HOME/pvm/$ARCH */
      PVMCreateLink(i,utable->archtable[i].fname,bname); CHKERRV(5,-1);
      sleep(3); /* this sleep is to allow the directory caches to sync */
      for ( j=0; j<utable->archtable[i].ne; j++ ) {
        machine = utable->archtable[i].hosts[j]->name;
        for ( k=0; k<utable->archtable[i].hosts[j]->np; k++ ) {
          if (initiateM(bname, machine) < 0) {
            fprintf(stderr,"Cannot initiate worker process %d %s \n",i,machine);
            fprintf(stderr,"bname %s program %s \n", 
                                     bname,utable->archtable[i].fname);
            for ( l=0; l<count; l++ ) {
              if (l != MYPROCID) terminate( __PVM_COMPONENT, l );
            }   
            /* PVMRemoveLinks(); */
            leave();
            SETERR(3); 
            return -1;
          } 
          count++;
        }
      }         
    }
  }
#endif
  if (utable) PIDestroyHostTable(utable);
  if (table)  PIDestroyHostTable( table);

  /* pass to all workers the number of processors.  We can't use the 
     usual GSCATTER here since that will use the value of __NUMNODES*/
  for ( i=0; i<np; i++ ) {
    SENDSYNC(10001,&__NUMNODES,sizeof(int),i+1,MSG_INT);
  }

  /* Broadcast resource limits */
  PIBroadcastLimits( &cpu, &mem, &pf, &maxtime, &niceval, 1,(ProcSet *)0 );
  SYSetLimits( mem, cpu, pf, &maxtime );
  if (niceval > 0) SYNice( niceval );

  /* pass to all workers command line */
  PIBroadcastArgs( &argc, &argv, 1, (ProcSet *)0 ); 
  PIGetDebugArgs( &argc, argv );

  /* pass to all workers the current working directory */
  len = strlen(cwd);
  GSCATTER(&len, sizeof(int), 1, (ProcSet *)0, MSG_INT);
  GSCATTER(cwd, len, 1, (ProcSet *)0, MSG_OTHER);

  /* pass to user code */
  LOGpop();
  PIinitlog();
  (*routine)(argc,argv);
  PIendlog();
  LOGDISABLE;
  GSYNC((ProcSet*)0);
  PVMRemoveLinks();
  /* Kill off the pvm daemon is we started it */
  if (pvmdpid)
      kill( pvmdpid, SIGINT );
  leave();
}

/*
    exitall - terminate all processes in an execution (parallel exit)
    See init.c for a complete description of the interface.
 */
void PVMexitall(msg,rc)
char *msg;
int  rc;
{
   int i;
   fprintf(stderr,msg);
   for ( i=0; i<NUMNODES; i++ ) {
     if (i != MYPROCID) terminate( __PVM_COMPONENT, i );
   }
   if (!MYPROCID) PVMRemoveLinks();
   leave();
}

/*
 Here are pvm support routines.  These take datatype as an argument,
 and convert it into a routine name.  An alternate approach is to
 have an array of routines, and use the data_type to dereference the
 array
 */
/* 
   Note:  When sending a byte stream, it first appends an integer length 
  of the byte stream; then puts down the bytes, then pads so the 
  total length is divisible by four; therefore there is no way to 
  to check whether the arriving message is the expected size. 
 
    We should make sure that we never use MSG_OTHER except for 
  character strings; not even for structures on the same architecture.
*/

pvm_send( type, to, buffer, length, datatype )
int  type, to, length, datatype;
char *buffer;
{
initsend();
if (length) {
  switch (datatype) {
    case MSG_LNG:   length = length / sizeof(long);
		    putnlong( (int *)buffer, length ); break;
    case MSG_INT:   length = length / sizeof(int);
		    putnint( (int *)buffer, length ); break;
    case MSG_FLT:   length = length / sizeof(float);
		    putnfloat( (float *)buffer, length ); break;
    case MSG_DBL:   length = length / sizeof(double);
		    putndfloat( (double *)buffer, length ); break;
    case MSG_OTHER: putbytes( (char *)buffer, length ); break;
    }
  } 
snd( __PVM_COMPONENT, to, type );
}

pvm_recv( type, from, buffer, length, datatype )
int  *type, *length, *from, datatype;
char *buffer;
{
int  bytes, msgtype;
char *component;

rcv( *type );

rcvinfo( &bytes, &msgtype, &component, from );
*type = msgtype; 

if (bytes > *length) {
  bytes = *length;
  /* Error condition - truncate */
  if ( datatype != MSG_OTHER ) {  /* see note above */
    fprintf(stderr,"[%d] received message too long from %d, %d %d truncating\n"
                , MYPROCID,*from,bytes,*length);
  }
}

*length = bytes;

if (bytes) {
  switch (datatype) {
    case MSG_LNG:   bytes = bytes / sizeof(long);
	            getnlong( (int *)buffer, bytes ); break;
    case MSG_INT:   bytes = bytes / sizeof(int);
		    getnint( (int *)buffer, bytes ); break;
    case MSG_FLT:   bytes = bytes / sizeof(float);
 		    getnfloat( (float *)buffer, bytes ); break;
    case MSG_DBL:   bytes = bytes / sizeof(double);
		    getndfloat( (double *)buffer, bytes ); break;
    case MSG_OTHER: getbytes( (char *)buffer, bytes ); break;
    }
  }
}

/* the next one may be wrong ???*/
pvm_recv_unsz( type, from, buffer, length, datatype )
int  *type, *from, *length, datatype;
char **buffer;
{
int  bytes, msgtype;
char *component;

rcv( *type );
rcvinfo( &bytes, &msgtype, &component, from );
*length = bytes; *type = msgtype; 

*buffer = MALLOC(bytes); CHKPTR(*buffer);

if (bytes) {
  switch (datatype) {
    case MSG_LNG:   bytes = bytes / sizeof(long);
	            getnlong( (int *)*buffer, bytes ); break;
    case MSG_INT:   bytes = bytes / sizeof(int);
		    getnint( (int *)*buffer, bytes ); break;
    case MSG_FLT:   bytes = bytes / sizeof(float);
 		    getnfloat( (float *)*buffer, bytes ); break;
    case MSG_DBL:   bytes = bytes / sizeof(double);
		    getndfloat( (double *)buffer, bytes ); break;
    case MSG_OTHER: getbytes( (char *)*buffer, bytes ); break;
    }
  }
}
 
#define PI_HAS_INIT
#define PI_HAS_EXIT

/*   Given a path of executable creates a soft link to $HOME/pvm/$ARCH */
/*  so that the pvmd can find and load it.                             */
/*  1) make sure pname exists.                                         */
/*  2) make sure $HOME/pvm/$ARCH exists; if not create it.             */
/*     NOTE: pvm uses different $ARCHes then we do                     */
/*  3) create link.                                                    */
/*
/*      iarch - arch of machine making link for                        */
/*      name - name of file being linked                               */
/*      bname - basename of new file created                           */

int  __PVMNumberLinks = 0;
char *__PVMLinks[MAXARCHES];

void PVMCreateLink(iarch,name,bname)
char *name,*bname;
Arch iarch;
{
  char   truename[MAXPATHLEN], pname[MAXPATHLEN], tmppath[MAXPATHLEN];
  char   arch[20], homedir[MAXPATHLEN];
  struct passwd *pwde;
  int    err,len;
  struct stat statbuf;

  PIArchToString(arch,iarch); PVMArchType(arch,20);

  /* get true path */
  if (!realpath(name,truename)) {
      SETERRC(5,"Could not get executable's path"); leave(); return;}

  /* determine home directory */
  pwde = getpwuid( geteuid() );  
  if (!pwde) {
      SETERRC(6,"Could not get user's home directory"); leave(); return;}
  strcpy( tmppath, pwde->pw_dir );
  if (!realpath(tmppath,homedir)) {
      SETERRC(5,"Could not get user's home directory"); leave(); return;}

  /* make sure subdirectories are in place */
  strcat(homedir,"/pvm");

  err = stat( homedir, &statbuf ); 
  if (err) {
    if (mkdir(homedir,S_IRUSR|S_IWUSR|S_IXUSR)) {
        SETERRC(8,"Could not make pvm executable directory");leave();return;} 
  }
  strcat(homedir,"/");
  strcat(homedir,arch);  
  err = stat( homedir, &statbuf ); 
  if (err) {
    if (mkdir(homedir,S_IRUSR|S_IWUSR|S_IXUSR)) {
        SETERRC(8,"Could not make pvm executable directory");leave();return;} 
  }
  strcat(homedir,"/");
  strcat(homedir,bname);

  /* is the file already there ? */
  err = stat( homedir, &statbuf );
  if (err) {
    if (symlink(truename,homedir)) {
        SETERRC(9,"Could not link to pvm executable");leave();return;}
    len = strlen(homedir);
    __PVMLinks[__PVMNumberLinks] = (char *) MALLOC( (len+1)*sizeof(char) );
    if (!__PVMLinks[__PVMNumberLinks]) {
        SETERRC(10,"Could not allocate space for file links");leave();return;}
    strcpy(__PVMLinks[__PVMNumberLinks++],homedir);
  }
}
/* 
      Removes any links set by PVMCreateLink().
*/
void PVMRemoveLinks()
{
  int i;
  for ( i=0; i<__PVMNumberLinks; i++ ) {
    unlink(__PVMLinks[i]);
  }
}

/*        
     Given out string name of an architecture; returns PVM name in the
   same location.
*/
  
void PVMArchType(arch,len)
char *arch;
int  len;
{
  if (!strncmp(arch,"sun4",4))    { strncpy(arch,"SUN4",4); return; }
  if (!strncmp(arch,"sun3",4))    { strncpy(arch,"SUN3",4); return; }
  if (!strncmp(arch,"tc2000",6))  { strncpy(arch,"BFLY",4); return; }
  if (!strncmp(arch,"intelnx",7)) { strncpy(arch,"I860",4); return; }
  if (!strncmp(arch,"NeXT",4))    { strncpy(arch,"NEXT",4); return; }
  if (!strncmp(arch,"rs6000",6))  { strncpy(arch,"RIOS",4); return; }
  if (!strncmp(arch,"IRIX",4))    { strncpy(arch,"SGI",4); return; }
}

/* This routine forms the host table to give to start a pvm daemon, OR
   determine the hosts to select. Returns -1 on failure, 0 on success */
int PIiPVMFormHostTable( utable, table, np, mem, cpu, pf, arch, bname, cwd, 
			 Argc, Argv )
HostTable **utable, **table;
int       np, mem, cpu, pf;
char      *arch, *bname, *cwd;
int       *Argc;
char      ***Argv;
{
int       maxarches = MAXARCHES, i;
char      *archpath,*path, hostfile[MAXPATHLEN];
Arch      narch;
FILE      *fd;

/* get environmental variables needed  */
SYGetwd( cwd, MAXPATHLEN );
archpath = getenv("TOOLSARCHES");if (!archpath) archpath = arch;
path = getenv("PATH"); if (!path) path = cwd;

/* Get database of available processors */
SYGetFileFromEnvironment( "TOOLSHOST", DEFAULTTOOLSHOST,
			 "hosts", hostfile, 'r' ); 
fd = fopen(hostfile,"r"); 
if (!fd) {
    fprintf(stderr,"Could not open hosts database %s \n",hostfile);
    SETERR(1); return -1;
    }
*table = PIReadInHostTable( fd, mem, cpu, pf, 0 ); fclose(fd); 
if (!*table) {SETERRC(2,"Could not read in host table"); return -1;}
*utable = 
    PIBuildHostTable(bname,np,*table,Argc,Argv,path,archpath,0,narch,cwd,0); 
if (!utable) {SETERRC(3,"Could not build host table"); return -1;}
return 0;
}

/* This routine generates the links to the executables */
int PIiPVMCreateLinks( utable, maxarches, bname, arch, fname )
HostTable *utable;
int       maxarches;
char      *bname, *arch, *fname;
{
int  i;

if (!utable) 
    PVMCreateLink( 0, fname, bname );
else {
    for ( i=0; i<maxarches; i++ ) {
	if (utable->archtable[i].np) {
	    /* this bit of code is to get around a stupid feature of PVM */
	    /* makes a link of executable to the users $HOME/pvm/$ARCH */
	    PVMCreateLink(i,utable->archtable[i].fname,bname); CHKERRV(5,-1);
	    }
	}
    }
sleep(3); /* this sleep is to allow the directory caches to sync */
}

/* Actually start the processes */
PIiPVMStartWorkers( utable, maxarches, bname, np, fname )
HostTable *utable;
int       maxarches, np;
char      *bname, *fname;
{
int  count, i, j, k, l;
char *machine;

/* If we don't have a host table, just try to initialize processes */
if (!utable) {
    for ( k=0; k<np; k++ ) {
	if (initiateM(bname, (char *)0) < 0) {
	    fprintf(stderr,"Cannot initiate worker process %d\n", i);
	    fprintf(stderr,"bname %s program %s \n", bname, fname);
	    for ( l=0; l<k; l++ ) {
		if (l != MYPROCID) terminate( __PVM_COMPONENT, l );
		}   
	    PVMRemoveLinks();
	    leave();
	    SETERR(3); 
	    return -1;
	    }
	}
    return 0;
    }

count = 0;
/* loop over the arches in utable starting up the processes */
for ( i=0; i<maxarches; i++ ) {
    if (utable->archtable[i].np) {
	for ( j=0; j<utable->archtable[i].ne; j++ ) {
	    machine = utable->archtable[i].hosts[j]->name;
	    for ( k=0; k<utable->archtable[i].hosts[j]->np; k++ ) {
		if (initiateM(bname, machine) < 0) {
		    fprintf(stderr,"Cannot initiate worker process %d %s \n",
			    i,machine);
		    fprintf(stderr,"bname %s program %s \n", 
			    bname,utable->archtable[i].fname);
		    for ( l=0; l<count; l++ ) {
			if (l != MYPROCID) terminate( __PVM_COMPONENT, l );
			}   
		    PVMRemoveLinks();
		    leave();
		    SETERR(3); 
		    return -1;
		    } 
		count++;
		}
	    }         
	}
    }
return 0;
}


/* 
   This routine starts a default PVMD.  The default location of the
   daemon and the hosts file are given by
   DEFAULTPVMD and DEFAULTPVMHOSTS ; 
   these may be overridden with the ENVIRONMENT PARAMETERS
   
   TOOLSPVMD
   TOOLSPVMHOSTS

   The format of the file is 
   
   hostname dx=absolute-path-of-daemon-for-that-architecture
 */
int PIiPVMStartPVMD( np )
int np;
{
char pvmdfile[MAXPATHLEN];
char pvmhosts[MAXPATHLEN];
int  err;

SYGetFileFromEnvironment( "TOOLSPVMD", DEFAULTPVMD,
                            "/usr/tmp/pvmd", pvmdfile, 'r' ); 
/* We should actually be prepared to write the pvmhosts file, using the
   host-table code */
SYGetFileFromEnvironment( "TOOLSPVMHOSTS", DEFAULTPVMHOSTS,
                            "/usr/tmp/pvmhosts", pvmhosts, 'r' ); 
pvmdpid = fork();
if (pvmdpid == -1) {
    fprintf( stderr, "Could not start pvm daemon\n" );
    return -1;
    }
if (!pvmdpid) {
    /* Child */
    err = execl( pvmdfile, pvmdfile, pvmhosts, (char *)0 );
    }
else {
    /* Wait for the thing to start */
    fprintf( stdout, "Waiting for pvmd to start...\n" );
    sleep(10);
    }
return 0;
}
