#ifndef lint
static char SCCSid[] = "@(#) ./comm/mcomm/ivec.c 07/23/93";
#endif

#include "tools.h"
#include "comm/comm.h"
#include "comm/mcomm/mcomm.h"

/* 
   For the asynchronous versions, we must introduce a datastructure that
   holds both the id of the underlying op AND the pointer to the
   allocated buffer 
 */

void PISendISync( type, buf, elmlen, ibuf, elmcount, to, datatype, 
		    is_force )
int  type, elmlen, *ibuf, elmcount, to, datatype, is_force;
char *buf; 
{
int  nbytes;
char *lbuf, *lp;

/* Compute the size of the buffer */
nbytes = elmlen * elmcount;
MSGALLOCSEND( lbuf, nbytes, char );         CHKPTR( lbuf );

/* Pack the buffer */
PIpackI( buf, elmlen, ibuf, elmcount, lbuf, datatype );
if (is_force) {
    SENDSYNCFORCE( type, lbuf, nbytes, to, datatype );
    }
else {
    SENDSYNC( type, lbuf, nbytes, to, datatype );
    }
MSGFREESEND( lbuf );
}

void PIRecvISync(type,buf,elmlen,ibuf,elmcount,datatype, is_force) 
int  type, elmlen, *ibuf, elmcount, datatype, is_force;
char *buf; 
{
int  nbytes;
char *lbuf, *lp;

/* Compute the size of the buffer */
nbytes = elmlen * elmcount;
MSGALLOCRECV( lbuf, nbytes, char );         CHKPTR( lbuf );

if (is_force) {
    RECVSYNCFORCE( type, lbuf, nbytes, datatype );
    }
else {
    RECVSYNC( type, lbuf, nbytes, datatype );
    }

/* UnPack the buffer */
PIunpackI( buf, elmlen, ibuf, elmcount, lbuf, datatype );
MSGFREERECV( lbuf );
}

void PISendIASync(type,buf,elmlen,ibuf,elmcount,to,datatype,id, is_force) 
int  type, elmlen, *ibuf, elmcount, to, datatype, is_force;
char *buf; 
PIAsyncSendMsg_t *id;
{
int           nbytes;
char          *lbuf, *lp;
ASYNCSendId_t iid;

/* Compute the size of the buffer */
nbytes = elmlen * elmcount;
MSGALLOCSEND( lbuf, nbytes, char );         CHKPTR( lbuf );

/* Pack the buffer */
PIpackI( buf, elmlen, ibuf, elmcount, lbuf, datatype );
if (is_force) {
    SENDASYNCFORCE( type, lbuf, nbytes, to, datatype, iid );
    }
else {
    SENDASYNC( type, lbuf, nbytes, to, datatype, iid );
    }
id->id = iid;
id->buf = lbuf;
}

void PIRecvIASync(type,buf,elmlen,ibuf,elmcount,datatype,id, is_force ) 
int  type, elmlen, ibuf, elmcount, datatype, is_force;
char *buf; 
PIAsyncRecvMsg_t *id;
{
int           nbytes;
char          *lbuf;
ASYNCRecvId_t iid;

/* Compute the size of the buffer */
nbytes = elmlen * elmcount;
MSGALLOCRECV( lbuf, nbytes, char );         CHKPTR( lbuf );

if (is_force) {
    RECVASYNCFORCE( type, lbuf, nbytes, datatype, iid );
    }
else {
    RECVASYNC( type, lbuf, nbytes, datatype, iid );
    }
id->id  = iid;
id->buf = lbuf;
}

void PIASendIWait(type,buf,elmlen,ibuf,elmcount,to,datatype,id,is_force) 
int  type, elmlen, *ibuf, elmcount, to, datatype, is_force;
char *buf; 
PIAsyncSendMsg_t *id;
{
int nbytes;

nbytes = elmlen * elmcount;
if (is_force) {
    SENDWAITFORCE( type, id->buf, nbytes, to, datatype, id->id );
    }
else {
    SENDWAIT( type, id->buf, nbytes, to, datatype, id->id );
    }
MSGFREESEND( id->buf );
}

void PIRecvIWait(type,buf,elmlen,ibuf,elmcount,datatype,id,is_force) 
int  type, elmlen, *ibuf, elmcount, datatype, is_force;
char *buf; 
PIAsyncRecvMsg_t *id;
{
int nbytes;

nbytes = elmlen * elmcount;
if (is_force) {
    RECVWAITFORCE( type, id->buf, nbytes, datatype, id->id );
    }
else {
    RECVWAIT( type, id->buf, nbytes, datatype, id->id );
    }
PIunpackI( buf, elmlen, ibuf, elmcount, id->buf, datatype );
MSGFREERECV( id->buf );
}

