#ifndef lint
static char SCCSidI[] = "@(#) ./comm/initpvm.c 07/23/93";
#endif

/*  
     There may be a problem with the way this is intended to run.
  The main process sets a link for the executable then immediately tells
  the other processor (with an initiate()) to run it. It seems that the
  other machine may look for the link and not find it, because it
  has been cached somehow. We need a way of flushing over the entire
  NFS network of any directory caches.

     I put a sleep() in but that is not very satisfactory. 

*/

/*  PVM has many bad design decisions; we should write them down and 
grind our teeth. But I don't want to change it at all; we must write
an interface so we can use standard PVM without changing our upper level
code.

  1) Limited path for looking for executables.
  2) Does not set a reasonable working directory.
  3) Does not pass command line.
  4) There is no routine to return the number of machines of 
     a particular architecture.
  5) stderr and stdout go to where the deamons are started up.
  6) makes no attempt to catch interupts on user process; one could
     die and the PVM system wouldn't even know.
  7) in unpacking messages user must know exactly how they were packed.
  8) Must have a pvm daemon running that has the number of processors
     you want.  You can't simply generate a list of processors to run
     on (it really is a virtual machine, defined statically).  We'll
     fix this by starting one with the list of workstations to use.

  In order to handle (1), we need to establish links to the appropriate 
  machines (PVMCreateLink).  2-3 are handled by PIcall startup code.
  There isn't much that we can do about 5; 6 we attempt to handle by
  catching the interrupts.  7 is a feature.  4 and 8 go together, and
  are tricky to deal with.  

  Since PVM won't tell us what machines are available, we may need the
  name of the file that started the pvmd.  If we don't have that, we
  have to fake it.

  Ah, just discovered that PVM 2.1.4 WILL give you the machines.  The 
  code is:
  pvm_mstat( int *nhosts, int **ifprocs, char ***hosts, char ***arches )
  (see Skjellum's paper, page 7)
*/

#define MAXFILELEN 31 /* limit of PVM */
#define MAXPVMCOMPLEN 9 /* limit of PVM */

/* Define CANSTARTDAEMON to allow PICall to try and start a PVM daemon */
#define CANSTARTDAEMON

#include "comm/comm.h"
#include "comm/hosts.h"
#include "system/system.h"
#include <stdio.h>
#include <string.h>
#include <pwd.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/param.h>
#if defined(rs6000) || defined(solaris)
#include <signal.h>
#endif

#if defined(intelnx)
typedef u_short uid_t;
typedef u_short gid_t;
#endif

void PVMCreateLink();
void PVMRemoveLinks();
void PVMArchType();
void PVMexitall();
extern char *getenv();

/* This defines these values */
int  __PVMFROM, __PVMLEN, __PVMTYPE, __PVMGLOBALTYPE;
char *__PVMCOMPONENT;
char __PVM_COMPONENT[MAXPVMCOMPLEN];
int  __MYPROCID, __NUMNODES;

static int pvmdpid = 0;
static int pvm_use_vsnd = 0;
static int pvm_kill_pvmd = 1;
#if defined(rs6000)
static int pvm_no_irpt = 1;
#else
static int pvm_no_irpt = 0;
#endif
#if defined(LOGCOMMDISABLE)
#define LOGpush()
#define LOGpop()
#endif

/* 
   PIcall - version for PVM. It uses argv[0] to determine the 
            name of the other np-1 instances of the  process group. 
   
  Things still needed to be done for this interface.

   1) Check if pvmd is running; if not create hosttable and start it up

   ??? HeNCE

*/
#define CBUFLEN 10

int PIcall(np, procgroup, dummy, routine, argc, argv)
int  np, argc;
char **procgroup, *dummy;
char **argv;
int  (*routine)();
{
  HostTable *table, *utable;
  int       i,j,k,l,count,len,fsec, maxarches = MAXARCHES, rc;
  char      cwd[MAXPATHLEN],arch[20], bname[MAXFILELEN], *machine;
  char      fname[MAXPATHLEN], cbuf[CBUFLEN];
  char      *archpath,*path, hostfile[MAXPATHLEN], oarch[20];
  Arch      narch,iarch;
  FILE      *fd;
  int       snd_type;

  /* setup to catch interrupts; include ^C */
  SYSetDefaultSignals( SYDefaultHandler );
  signal( SIGINT, SYDefaultHandler ); 

  /* set the exit routine */
  SYSetExitAll(PVMexitall);

  /* determine base name of our, to be created, process group */
  PIBaseName( argv[0],0,bname, MAXFILELEN );
  strncpy(__PVM_COMPONENT,bname,MAXPVMCOMPLEN);
  __PVM_COMPONENT[MAXPVMCOMPLEN-1] = 0;
  /* Note: Barry reports that names of more than eight
     characters cause problems. */ 

  /* enroll in pvm.  */
  __MYPROCID  = enroll( __PVM_COMPONENT );
  /* One problem with PVM is there is no way to determine if we are
     the 0th or nth process.  This can be a problem if there are some
     hung processes and the application is restarted.  Then, the
     value from enroll, which we are COUNTING on being 0, may be
     > 0, since the hung processes will be counted.  There is no
     certain way to handle this, but we can take advantage of the fact
     that PVM does not pass command line arguments when processes
     are started.  Thus, if argc > 1 and __MYPROCID > 0, there is a
     problem. */
  if (argc > 1 && __MYPROCID > 0) {
      fprintf( stderr,
      "Error in enrolling 0th process - there may be hung processes with\n" );
      fprintf( stderr,
      "name %s.  Kill those processes or kill and restart the daemon\n",
      argv[0] );
      return -1;
      }
  if (__MYPROCID < 0) {
#ifdef CANSTARTDAEMON
      /* Try to start a daemon */
      if (PIiPVMStartPVMD( 0 ) == -1) return -1;
      __MYPROCID  = enroll( __PVM_COMPONENT ); 
      if (__MYPROCID < 0) {
	  /* Give up */
	  fprintf(stderr,"Error enrolling in PVM %d \n",__MYPROCID);
	  SETERR(1); return -1;
	  }
#else
      fprintf( stderr, "Start a PVM Daemon and re-run your application\n" );
      fprintf( stderr,
               "See the tools man page on PICall for more information\n" );
      SETERR(1);
      return -1;  
#endif      
      }

  /* determine our arch */
  SYGetArchType(arch,20); narch = PIStringToArch(arch);

  LOGpush(); LOGDISABLE;

  if (MYPROCID == 0) {
      /* we are the host process; */
      /* determine if we have enough processors */
      SYArgGetInt( &argc, argv, 1, "-np", &np );
      /* 
	Since we can start multiple tasks on the same node, this test
	is not accurate.  We should let the host table routines handle this
       */
#ifdef CHECK_ON_PROCESSES
      pstatus( &__NUMNODES, (int *)0 );
      if (__NUMNODES < np) { 
	  fprintf(stderr,
		  "Not enough processors: want %d total %d \n",np,__NUMNODES);
	  SETERR(2); leave(); 
	  if (pvmdpid && pvm_kill_pvmd) kill( pvmdpid, SIGINT); return -1;
	  }
#endif
      __NUMNODES = np--; 
      /* np is now the number left to start */
      
      /* Get resource limits */
      SYGetResourceDefaults( &cpu, &mem, &pf, &niceval, &fsec );
      SYArgGetInt( &argc, argv, 1, "-nice", &niceval );
      gettimeofday( &maxtime, 0 );  maxtime.tv_sec += fsec;
      SYGetResourceLimits( &argc, argv, &cpu, &mem, &pf, &maxtime, 0 );
      
      SYGetwd( cwd, MAXPATHLEN );
      
      /* Note that this should really be generated from the file that 
	 started the pvmd */ 
      utable = 0;
      table  = 0;
      if (!pvmdpid && PIiFormHostTable( &utable, &table, 
					np, mem, cpu, pf, arch, bname, 
					cwd, &argc, &argv, 
				        "TOOLSPVMHOSTS", 
				        DEFAULTPVMHOSTS ) == -1) { 
	  leave(); return -1; }
      if (!pvmdpid && !utable) {leave(); 
				SETERRC(3,"Could not get host table"); 
				return -1;}
      
      if (pvmdpid || !utable) {
	  if (!PIFullPathFromBase(bname,-1,(char *)0,path,fname,
				  MAXPATHLEN,cwd)) 
	      if (!PIFullPathFromBase(bname,arch,(char *)0,path,fname,
				      MAXPATHLEN,cwd))
		  strcpy(fname,bname);
	  }
      if (PIiPVMCreateLinks( utable, maxarches, bname, arch, fname ) == -1) 
	  return -1;
      if (PIiPVMStartWorkers( utable, maxarches, bname, np, fname ) == -1) 
	  return -1;
      if (SYArgHasName( &argc, argv, 1, "-listnodes" )) {
	  PIPrintHostTable( utable, stdout );
	  }
      if (utable) PIDestroyHostTable(utable);
      if (table)  PIDestroyHostTable( table);
      for ( i=0; i<np; i++ ) {
	  SENDSYNC(10001,&__NUMNODES,sizeof(int),i+1,MSG_INT);
	  }
      }
  else {
      /* receive number of processors */
      RECVSYNC(10001,&__NUMNODES,sizeof(int),MSG_INT);
      /* If we are over the limit of number of nodes, we should exit here ? */
      }
  
  PISetupCollectiveTree( );
  /* receive resource limits */
  PIBroadcastLimits( &cpu, &mem, &pf, &maxtime, &niceval, 
		    MYPROCID==0,(ProcSet *)0 );
  SYSetResourceLimits( mem, cpu, pf, &maxtime );
  if (niceval > 0) SYSetNice( niceval );
  
  /* receive the command line */
  PIBroadcastArgs( &argc, &argv, MYPROCID==0, (ProcSet *)0 ); 
  PIGetDebugArgs( &argc, argv );
  /* Check for pvm-specific options */
  while (SYArgGetString( &argc, argv, 1,"-pvm", cbuf, CBUFLEN ))
      PISetOption( "pvm", cbuf, (void *)0 );

  /* At this point, we may have switched the send type.  Stay with the
     snd/rcv version until we are done with the setup */
  snd_type     = pvm_use_vsnd;
  pvm_use_vsnd = 0;

  /* get the current working directory and chdir to it*/
  len = strlen(cwd);
  GSCATTER(&len, sizeof(int), MYPROCID==0, (ProcSet *)0, MSG_INT);
  GSCATTER(cwd, len, MYPROCID==0, (ProcSet *)0, MSG_OTHER);
  chdir(cwd);
  
  /* pass to user code */
  LOGpop();
  PIinitlog();
  /* This GSYNC is used to insure that all processors reach this point
     (bad things can happen if someone does a SYexitall before all
     tasks reach this point) */
  GSYNC((ProcSet*)0);

  pvm_use_vsnd = snd_type;
  rc = (*routine)(argc,argv);
  pvm_use_vsnd = 0;

  PIendlog();
  GSYNC((ProcSet*)0);
  leave();
  if (MYPROCID == 0) {
      PVMRemoveLinks();
      /* Kill off the pvm daemon if we started it */
      if (pvm_kill_pvmd && pvmdpid)
	  kill( pvmdpid, SIGINT );
      }
  return rc;
}

/*
    exitall - terminate all processes in an execution (parallel exit)
    See init.c for a complete description of the interface.
 */
void PVMexitall(msg,rc)
char *msg;
int  rc;
{
   int i;
   fputs( msg, stderr );
   for ( i=0; i<NUMNODES; i++ ) {
     if (i != MYPROCID) terminate( __PVM_COMPONENT, i );
   }
   if (!MYPROCID) PVMRemoveLinks();
   leave();
   fflush(stdout);
   fflush(stderr);
   exit(1);
}

/*
 Here are pvm support routines.  These take datatype as an argument,
 and convert it into a routine name.  An alternate approach is to
 have an array of routines, and use the data_type to dereference the
 array
 */
/* 
   Note:  When sending a byte stream, it first prepends an integer length 
  of the byte stream; then puts down the bytes, then pads so the 
  total length is divisible by four; therefore there is no way to 
  to check whether the arriving message is the expected size. 
 
    We should make sure that we never use MSG_OTHER except for 
  character strings; not even for structures on the same architecture.
*/

pvm_send( type, to, buffer, length, datatype )
int  type, to, length, datatype;
char *buffer;
{
if (pvm_no_irpt)
    SYSetResourceClockOff();

initsend();
if (length) {
  switch (datatype) {
    case MSG_LNG:   length = length / sizeof(long);
		    putnlong( (int *)buffer, length ); break;
    case MSG_INT:   length = length / sizeof(int);
		    putnint( (int *)buffer, length ); break;
    case MSG_FLT:   length = length / sizeof(float);
		    putnfloat( (float *)buffer, length ); break;
    case MSG_DBL:   length = length / sizeof(double);
		    putndfloat( (double *)buffer, length ); break;
    default:
    case MSG_OTHER: putbytes( (char *)buffer, length ); break;
    }
  }
if (pvm_use_vsnd) 
    vsnd( __PVM_COMPONENT, to, type );
else 
    snd( __PVM_COMPONENT, to, type );

if (pvm_no_irpt)
    SYSetResourceClockOn();
}

pvm_recv( type, from, buffer, length, datatype )
int  *type, *length, *from, datatype;
char *buffer;
{
int  bytes, msgtype;
char *component;

if (pvm_no_irpt)
    SYSetResourceClockOff();

if (pvm_use_vsnd) 
    vrcv( *type );
else
    rcv( *type );

rcvinfo( &bytes, &msgtype, &component, from );
*type = msgtype;
/* We may want to check that the component name matches */

if (bytes > *length) {
  bytes = *length;
  /* Error condition - truncate */
  if ( datatype != MSG_OTHER ) {  /* see note above */
    fprintf(stderr,"[%d] received message too long from %d, %d %d truncating\n"
                , MYPROCID,*from,bytes,*length);
    }
  }

*length = bytes;

if (bytes) {
  switch (datatype) {
    case MSG_LNG:   bytes = bytes / sizeof(long);
	            getnlong( (int *)buffer, bytes ); break;
    case MSG_INT:   bytes = bytes / sizeof(int);
		    getnint( (int *)buffer, bytes ); break;
    case MSG_FLT:   bytes = bytes / sizeof(float);
 		    getnfloat( (float *)buffer, bytes ); break;
    case MSG_DBL:   bytes = bytes / sizeof(double);
		    getndfloat( (double *)buffer, bytes ); break;
    default:
    case MSG_OTHER: getbytes( (char *)buffer, bytes ); break;
    }
  }
if (pvm_no_irpt)
    SYSetResourceClockOn();
}

/* Receive a message of unknown size */
pvm_recv_unsz( type, from, buffer, length, datatype )
int  *type, *from, *length, datatype;
char **buffer;
{
int  bytes, msgtype;
char *component;

if (pvm_no_irpt)
    SYSetResourceClockOff();

if (pvm_use_vsnd) 
    vrcv( *type );
else
    rcv( *type );
rcvinfo( &bytes, &msgtype, &component, from );
*length = bytes; *type = msgtype; 

*buffer = MALLOC(bytes); CHKPTR(*buffer);

if (bytes) {
  switch (datatype) {
    case MSG_LNG:   bytes = bytes / sizeof(long);
	            getnlong( (int *)*buffer, bytes ); break;
    case MSG_INT:   bytes = bytes / sizeof(int);
		    getnint( (int *)*buffer, bytes ); break;
    case MSG_FLT:   bytes = bytes / sizeof(float);
 		    getnfloat( (float *)*buffer, bytes ); break;
    case MSG_DBL:   bytes = bytes / sizeof(double);
		    getndfloat( (double *)buffer, bytes ); break;
    default:
    case MSG_OTHER: getbytes( (char *)*buffer, bytes ); break;
    }
  }
if (pvm_no_irpt)
    SYSetResourceClockOn();
}
 
#define PI_HAS_INIT
#define PI_HAS_EXIT

/*   Given a path of executable creates a soft link to $HOME/pvm/$ARCH */
/*  so that the pvmd can find and load it.                             */
/*  1) make sure pname exists.                                         */
/*  2) make sure $HOME/pvm/$ARCH exists; if not create it.             */
/*     NOTE: pvm uses different $ARCHes then we do                     */
/*  3) create link.                                                    */
/*
/*      iarch - arch of machine making link for                        */
/*      name - name of file being linked                               */
/*      bname - basename of new file created                           */

int  __PVMNumberLinks = 0;
char *__PVMLinks[MAXARCHES];

void PVMCreateLink(iarch,name,bname)
char *name,*bname;
Arch iarch;
{
  char   truename[MAXPATHLEN], pname[MAXPATHLEN], tmppath[MAXPATHLEN];
  char   arch[20], homedir[MAXPATHLEN];
  struct passwd *pwde;
  int    err,len;
  struct stat statbuf;

  PIArchToString(arch,iarch); PVMArchType(arch,20);

  /* get true path */
  if (!SYGetRealpath(name,truename)) {
      SETERRC(5,"Could not get executable's path"); leave(); return;}

  /* determine home directory */
  pwde = getpwuid( geteuid() );  
  if (!pwde) {
      SETERRC(6,"Could not get user's home directory"); leave(); return;}
  strcpy( tmppath, pwde->pw_dir );
#if defined(rs6000)
  strcpy(homedir,tmppath);
#else
  if (!realpath(tmppath,homedir)) {
      SETERRC(5,"Could not get user's home directory"); leave(); return;}
#endif

  /* make sure subdirectories are in place */
  strcat(homedir,"/pvm");

  err = stat( homedir, &statbuf ); 
  if (err) {
    if (mkdir(homedir,S_IRUSR|S_IWUSR|S_IXUSR)) {
        SETERRC(8,"Could not make pvm executable directory");leave();return;} 
  }
  strcat(homedir,"/");
  strcat(homedir,arch);  
  err = stat( homedir, &statbuf ); 
  if (err) {
    if (mkdir(homedir,S_IRUSR|S_IWUSR|S_IXUSR)) {
        SETERRC(8,"Could not make pvm executable directory");leave();return;} 
  }
  strcat(homedir,"/");
  strcat(homedir,bname);

  /* is the file already there ? */
  err = stat( homedir, &statbuf );
  if (err) {
    if (symlink(truename,homedir)) {
        SETERRC(9,"Could not link to pvm executable");leave();return;}
    len = strlen(homedir);
    __PVMLinks[__PVMNumberLinks] = (char *) MALLOC( (len+1)*sizeof(char) );
    if (!__PVMLinks[__PVMNumberLinks]) {
        SETERRC(10,"Could not allocate space for file links");leave();return;}
    strcpy(__PVMLinks[__PVMNumberLinks++],homedir);
  }
}
/* 
      Removes any links set by PVMCreateLink().
*/
void PVMRemoveLinks()
{
  int i;
  for ( i=0; i<__PVMNumberLinks; i++ ) {
    unlink(__PVMLinks[i]);
  }
}

/*        
     Given out string name of an architecture; returns PVM name in the
   same location.  len should be at least 5 (NOT 4!).
*/
  
void PVMArchType(arch,len)
char *arch;
int  len;
{
  if (!strncmp(arch,"sun4",4))    { strncpy(arch,"SUN4",len); return; }
  if (!strncmp(arch,"sun3",4))    { strncpy(arch,"SUN3",len); return; }
  if (!strncmp(arch,"tc2000",6))  { strncpy(arch,"BFLY",len); return; }
  if (!strncmp(arch,"intelnx",7)) { strncpy(arch,"I860",len); return; }
  if (!strncmp(arch,"NeXT",4))    { strncpy(arch,"NEXT",len); return; }
  if (!strncmp(arch,"rs6000",6))  { strncpy(arch,"RIOS",len); return; }
  if (!strncmp(arch,"IRIX",4))    { strncpy(arch,"SGI",len); return; }
}

/* This routine generates the links to the executables */
int PIiPVMCreateLinks( utable, maxarches, bname, arch, fname )
HostTable *utable;
int       maxarches;
char      *bname, *arch, *fname;
{
int  i;

if (!utable) 
    PVMCreateLink( 0, fname, bname );
else {
    for ( i=0; i<maxarches; i++ ) {
	if (utable->archtable[i].np) {
	    /* this bit of code is to get around a stupid feature of PVM */
	    /* makes a link of executable to the users $HOME/pvm/$ARCH */
	    PVMCreateLink(i,utable->archtable[i].fname,bname); CHKERRV(5,-1);
	    }
	}
    }
sleep(3); /* this sleep is to allow the directory caches to sync */
}

/* Actually start the processes */
PIiPVMStartWorkers( utable, maxarches, bname, np, fname )
HostTable *utable;
int       maxarches, np;
char      *bname, *fname;
{
int  count, i, j, k, l;
char *machine;

/* If we don't have a host table, just try to initialize processes */
if (!utable) {
    for ( k=0; k<np; k++ ) {
	/* There may be a problem if strlen(bname) > 8 */
	if (initiateM( bname, (char *)0 ) < 0) {
	    fprintf(stderr,"Cannot initiate worker process %d\n", k);
	    fprintf(stderr,"base name %s program %s \n", bname, fname);
	    for ( l=0; l<k; l++ ) {
		if (l != MYPROCID) terminate( __PVM_COMPONENT, l );
		}   
	    PVMRemoveLinks();
	    leave();
	    SETERR(3); 
	    return -1;
	    }
	}
    return 0;
    }

count = 0;
/* loop over the arches in utable starting up the processes */
for ( i=0; i<maxarches; i++ ) {
    if (utable->archtable[i].np) {
	for ( j=0; j<utable->archtable[i].ne; j++ ) {
	    machine = utable->archtable[i].hosts[j]->name;
	    for ( k=0; k<utable->archtable[i].hosts[j]->np; k++ ) {
		if (initiateM( bname, machine ) < 0) {
		    fprintf(stderr,"Cannot initiate worker process %d %s \n",
			    i,machine);
		    fprintf(stderr,"bname %s program %s \n", 
			    bname,utable->archtable[i].fname);
		    for ( l=0; l<count; l++ ) {
			if (l != MYPROCID) terminate( __PVM_COMPONENT, l );
			}   
		    PVMRemoveLinks();
		    leave();
		    SETERR(3); 
		    return -1;
		    } 
		count++;
		}
	    }         
	}
    }
return 0;
}

#ifdef CANSTARTDAEMON
/* 
   This routine starts a default PVMD.  The default location of the
   daemon and the hosts file are given by
   DEFAULTPVMD and DEFAULTPVMHOSTS ; 
   these may be overridden with the ENVIRONMENT PARAMETERS
   
   TOOLSPVMD
   TOOLSPVMHOSTS

   The format of the file is 
   
   hostname dx=absolute-path-of-daemon-for-that-architecture
 */
int PIiPVMStartPVMD( np )
int np;
{
char      pvmdfile[MAXPATHLEN];
char      pvmhosts[MAXPATHLEN];
char      localhost[MAXHOSTNAMELEN];
char      pfname[MAXPATHLEN];
char      pvmarch[10];
HostTable *htable;
int       err;
FILE      *fout, *fin;
int       i, j;

SYGetFileFromEnvironment( "TOOLSPVMD", DEFAULTPVMD,
                            "/usr/tmp/pvmd", pvmdfile, 'r' ); 
/* We should actually be prepared to write the pvmhosts file, using the
   host-table code */
SYGetFileFromEnvironment( "TOOLSPVMHOSTS", DEFAULTPVMHOSTS,
                            "/usr/tmp/pvmhosts", pvmhosts, 'r' );
/* pvmhosts is the "hosts" file; now we write out a pvmd style file */
fout = SYOpenWritableFile( "./:~/", "/tmp/PIXXXXXX", "PIXXXXXX", pfname, 1 );
if (!fout) {
    fprintf( stderr, "Could not open file for PVM daemon list\n" );
    return 0;
    }
fin  = fopen( pvmhosts, "r" );
htable = PIReadInHostTable( fin, 0, 0, 0, 0 );
SYGetHostName( localhost, MAXHOSTNAMELEN);
SYGetArchType( pvmarch, 10 );
PVMArchType( pvmarch, 10 );
fprintf( fout, "%s dx=%s/%s/pvmd\n", localhost, DEFAULTPVMROOT, pvmarch );
for (i=0; i<MAXARCHES; i++) {
    if (htable->archtable[i].np) {
	for (j=0; j<htable->archtable[i].ne; j++) {
	    PIArchToString( pvmarch, i );
	    PVMArchType( pvmarch, 10 );
	    fprintf( fout, "%s dx=%s/%s/pvmd\n", 
		     htable->archtable[i].hosts[j]->name, DEFAULTPVMROOT, 
		     pvmarch );
	    }
	}
    }
PIDestroyHostTable( htable );
fclose( fin );
fclose( fout );

pvmdpid = fork();
if (pvmdpid == -1) {
    fprintf( stderr, "Could not start pvm daemon\n" );
    return -1;
    }
if (!pvmdpid) {
    /* Child */
    err = execl( pvmdfile, pvmdfile, pfname, (char *)0 );
    }
else {
    /* Wait for the thing to start */
    fprintf( stdout, "Waiting for pvmd to start...\n" );
    sleep(10);
    }
return 0;
}
#endif


#define PI_HAS_SET_OPTION
void PISetOption( version, name, val )
char *version, *name;
void *val;
{
if (strcmp( version, "pvm" ) != 0) return;

if (strcmp( name, "list" ) == 0) {
    fprintf( (FILE*)val, 
"list   - generate this list\n\
vsnd   - use vsnd to send messages\n\
snd    - use snd to send messages\n\
nokill - don't kill the pvm daemon on exit if one is started\n\
         (an already running pvm daemon is never killed)\n\
noirpt - disable interrupts around pvm operations.  Use this if you get\n\
         \"select: Interrupted system call\" messages\n" );
    return;
    }
    
if (strcmp( name, "snd" ) == 0) {
    pvm_use_vsnd = 0;
    }
else if (strcmp( name, "vsnd" ) == 0) {
    pvm_use_vsnd = 1;
    }
else if (strcmp( name, "nokill" ) == 0) {
    pvm_kill_pvmd = 0;
    }
else if (strcmp( name, "noirpt" ) == 0) {
    pvm_no_irpt   = 1;
    }
/* Eventually should add busywait */
}

int PIpvmIprobe( type )
int type;
{
int rc;

rc = (probe(type) != -1);
if (rc) {
    rcvinfo( &__PVMLEN, &__PVMTYPE, &__PVMCOMPONENT, &__PVMFROM );
    }
return rc;
}
