#ifndef lint
static char SCCSid[] = "@(#) ./comm/init.c 07/23/93";
#endif

/*
    PI - routine to initialize a parallel program

    These routines provide a common interface for parallel programs to
    initialize themselves.  These provide a "hostless" environment.
 */

/*

  New interface:
  The "PICall" interface continues to be supported.  However, there is a 
  need to support other interface models.  To this end, a PIinit()
  interface is also defined.  This does NOT run a user-supplied program
  or even manage much setup.  All that it is responsible for is initializing
  whatever data is used by that interface (primarily static data in
  init<comm>.c).


     Notes on handling different architectures.

    1) The name of the file containing the list of hosts is 
       hardwired in comm/hosts.h by DEFAULTTOOLSHOST

    2) At run time this can be overridden by setting the 
       environmental variable TOOLSHOST
 
    3) By default it will using only the architecture of the 
       machine it was started on.

    4) This can be overridden by setting the environmental variable
       TOOLSARCHES in the form arch1:arch2:arch3 etc. The machines in 
       the hosttable will then be allocated in the order first all 
       available machines of type arch1, then all availible machines
       of type arch2 etc.

    5) By default the program names must be of the form pgrm.arch, the 
       program on the host machine doesn't need the .arch appendix

    We will at some point want to support TOOLSFORMAT which will allow
    other formats for indicated the architecture in the program name.

    We will want at some point to support command line arguments as well.

*/

#include "tools.h"
#include "comm/comm.h"
#include <stdio.h>
#ifndef __MSDOS__
#include <sys/time.h>
#else
struct timeval { unsigned long tv_usec, tv_sec; };
#endif

/* Here is where these logging variables reside (they are always available
   in case the user is using logging but not using the version of tools
   that logs "tools" routines) */
int     _logsend=0, _logsendn=0, _logrecv=0, _logrecvn=0;
SYstate _state_recv=SYNullState, _state_recvwait=SYNullState,
        _state_send=SYNullState, 
        _state_gsync=SYNullState, _state_gop=SYNullState;

/* Used to manage resource limits.  These are used to pass values between the
   PIcall routine and the "slave" routine, if any.  These should be moved into
   the appropriate init<comm>.c files */
static int cpu, mem, pf, niceval;
static struct timeval maxtime;

/* Forward references */
long PIhhmmtoSec( );

/* 
   This is the common debuging info argument eater

   This should be elsewhere so that the optimized version won't load all
   of the tracing etc stuff.
 */
PIGetDebugArgs( argc, argv )
int *argc;
char **argv;
{
char name[1024];

if (SYArgHasName( argc, argv, 0, "-help" )) {
    /* Add help information on the PICall options.  Do not remove the
       option in case other parts of the program want to use it.
       In order to keep all compilers happy, we make this into a few
       separate calls to fprintf (PGI complained)
     */
    fprintf( stderr, "PICall options:\n\
     -np   n           number of processors to use\n\
     -arch name        Architecture name\n\
     -exes name        Name of program to run in parallel (fully qualified)\n\
     -dbg              (debugging)  This is implementation defined.\n\
     -trace            Enable communication tracing\n\
     -tracefile name   Specify a file name for the tracing information to\n\
                       be written to.  stdout is the default.  If the\n" );
    fprintf( stderr, "\
                       name contains \"%%d\", the value of PImytid will\n\
                       replace the \"%%d\".\n\
     -event            Enable event tracing\n\
         -blogclock option    Set event clock control.  Options are:\n\
                 skew         Adjust for clock skew\n\
                 offsets      Adjust for clock offsets\n\
                 print        Print clock adjustments\n\
                 all          All adjustments\n\
                 none         Disable all clock adjustments\n\
                 no[skew | offsets | print]   Disable given operation\n\
         -blogfmat [alog | picl]  Choose output format\n" );
    fprintf( stderr, 
"     -nomerge          Do not generate a single event log file; instead\n\
                       generate one for each processor.\n\
     -summary          Enable communication summary\n\
     -p4 option        Set p4 option.  Currently only busywait (use with\n\
                       -event to get wait times on receives).\n\
     -pvm option       Set pvm option. Currently snd (use snd/rcv) and\n\
                       vsnd (use vsnd/vrcv) are available.\n\
     -listnodes        List the nodes (processors) chosen\n\
     -pifile name      File containing names of hosts and other information.\n\
     -pihosts names    List of host names, separated by commas (and NO spaces)\n\
                       not including the local (initiating) host.\n" );
    fprintf( stderr, 
"     -piarches names   List of nodes separated by colons (and NO spaces).\n\
                       This is an alternate form of TOOLSARCHES.\n\
     -pidbg            Generate a trace of the process of identifying hosts\n\
                       this is useful for debugging and understanding the \n\
                       decisions made in chosing hosts\n\n" );
    fprintf( stderr, "   and the resource limits\n\n\
     -cpu  min   minutes of cpu time\n\
     -mem  mb    megabytes of memory\n\
     -pf   n     number of pagefaults\n\
     -dtime hh:mm time (delta) from current time\n\
     -atime hh:mm time (absolute)\n\
     -nice n     nice increment\n\n" );
    }

if (SYArgHasName( argc, argv, 1, "-trace" ))
    PISetLoggingBit( 0x2, 1 );
if (SYArgHasName( argc, argv, 1, "-lastcomm" )) {
    PISetLoggingBit( 0x8, 1 );
    /* Also need to insure the the error handler calls the trace dump 
       routine */
    }
if (SYArgHasName( argc, argv, 1, "-event" ))
    PISetLoggingBit( 0x1, 1 );
/*
   if contains %d, one per node, replace with MYPROCID; else, merge logs 
   together.
if (SYArgGetString( argc, argv, 1, "-eventfile", name, 1024 ))
    PISetEventFile( name );
 */
if (SYArgHasName( argc, argv, 1, "-summary" ))
    PISetLoggingBit( 0x4, 1 );
if (SYArgGetString( argc, argv, 1, "-tracefile", name, 1024 ))
    PISetTracefile( name );

/* Control the handling of the event clocks */
BLOGClockControl( argc, argv );
/* Control the type of output */
BLOGOutputFormat( argc, argv );
if (SYArgHasName( argc, argv, 1, "-nomerge" ))
    PISetMergeEventFiles( 0 );
}

/* This is the new form of PIcall */
/*@C
   PICall - Call a routine in a parellel execution mode.

   Input Parameters:
.   routine   - routine to execute; declared as

$      int routine( argc, argv )
$      int  argc;
$      char **argv;

.   argc,argv - arguments to pass to routine.  Some arguments are processed
    by PICall.  These are
$     -np   n           number of processors to use
$     -arch name        Architecture name
$     -exes name        Name of program to run in parallel (fully qualified)
$     -dbg              (debugging)  This is implementation defined.
$     -trace            Enable communication tracing      
$     -tracefile name   Specify a file name for the tracing information to
$                       be written to.  stdout is the default.  If the 
$                       name contains "%d", the value of MYPROCID will
$                       replace the "%d".
$     -event            Enable event tracing
$     -nomerge          Do not generate a single event log file; instead
$                       generate one for each processor.
$     -summary          Enable communication summary
$     -p4 option        Set p4 option.  Currently only busywait (use with 
$                       -event to get wait times on receives).
$     -pvm option       Set pvm option. Currently snd (use snd/rcv) and 
$                       vsnd (use vsnd/vrcv) are available.
$     -listnodes        List the nodes (processors) chosen
$     -pifile name      File containing names of hosts and other information
$                       (see below).  Not yet implemented.
$     -pihosts names    List of host names, separated by commas (and NO spaces)
$
$   and the resource limits
$
$     -cpu  min   minutes of cpu time
$     -mem  mb    megabytes of memory
$     -pf   n     number of pagefaults
$     -dtime hh:mm time (delta) from current time
$     -atime hh:mm time (absolute)
$     -nice n     nice increment

    On some systems, not all of these options may be recognized.  Also,
    the options -trace, -event, and -summary require that the libraries
    be compiled with the appropriate switches.  The "production" library
    may not provide these facilities.

   Note:
   As should be clear from the definition of "routine", it is expected that
   the "routine" is the main program.  A typical use of PIcall is

$   main( argc, argv )
$   int  argc;
$   char **argv;
$   {
$   int worker();
$   PICall( worker, argc, argv );
$   }
$   worker( argc, argv )
$   ... old main program ....

    Some versions (in particular, the p4 version) implement a resource
    limit control to help catch and terminate run-away jobs.  These
    limits may be overriden by command line parameters (-mem, -cpu, etc)
    or with SYChangeResourceDefaults, which should be called BEFORE
    PIcall.

    Special features:
    Several of the "communication" options (pvm and p4) use a number of
    environment variables to determine the list of hosts that can run
    these programs.  The relavent environment variables are

$   PVM
.   TOOLSARCHES - list of architectures to run on, separated by :.
.   TOOLSPVMHOSTS - name of the file, in tools host database format, 
                    containing the available hosts
.   TOOLSPVMD     - name of the program to run to start a pvm daemon if
                    one is not running

$   P4
.   TOOLSARCHES - list of architectures to run on, separated by :.
.   TOOLSHOSTS   - name of the file, in tools host database format, 
                    containing the available hosts
.   TOOLSP4D     - name of the program to run to start a p4 server if
                    one is not running

    Default values for these variables are provided in .../comm/hosts.h .
@*/
int PICall( r, argc, argv )
int (*r)(), argc;
char **argv;
{
int defnp = 1;
#if defined(intelnx)
defnp = numnodes();
#endif
return PIcall( defnp, (char **)0, (char *)0, r, argc, argv );
}

/* 
   Pick the higher-level versions first; then the vendor or default
   implementations 
*/
#if defined(p4)
#include "comm/initp4.c"
#elif defined(picl)
#include "comm/initpicl.c"
#elif defined(pvm)
#include "comm/initpvm.c"
#elif defined(intelnx)
#include "comm/initnx.c"
#elif defined(cm5)
#include "comm/initcm5.c"
#elif defined(eui)
#include "comm/initeui.c"
#elif defined(ncube)
#include "comm/initn3.c"
#endif

#ifndef PI_HAS_SET_OPTION
/*@
  PISetOption - Set a message-passing-system specific option

  Input parameters:
. version - Version of message passing.  Known values include
$       p4
$       pvm
$       nx
$       cmmd
. name - name of option to set.  These are all specific to the system
  except for "list", which lists the available options on the file
  specified by val.
. val  - pointer to data

  Notes:
  This routine is used to provide access to options that are not "portable".
  These include things like switching between send/receive protocols in PVM
  and kind of message wait in P4.  
@*/
void PISetOption( version, name, val )
char *version, *name;
void *val;
{
if (strcmp( name, "list" ) == 0) {
    fprintf( (FILE*)val, "No options for %s\n", version );
    }
}
#endif

/* Include the defaults */
#ifndef PI_HAS_INIT
/*
    (old arguments for picall)
.   np        - number of processors to use (default value; see argc,arvg
                below)
.   procgroup - (optional) character array containing the processor to run on
.   pfname    - (optional) name of file containing procgroup information.
                If both procgroup and pfname are null, processors will
		be chosen from the tools/comm/hosts file.
 */
int PIcall( np, procgroup, pfname, routine, argc, argv )
int  np, argc;
char **procgroup, *pfname;
char **argv;
int  (*routine)();
{
int  rc;

LOGPUSHATOMIC;
#if !defined(LOGCOMMDISABLE)
PIGetDebugArgs( &argc, argv );
#endif
PIinitlog();
LOGPOPATOMIC;
rc = (*routine)( argc, argv );
LOGPUSHATOMIC;
PIendlog();
LOGPOPATOMIC;
return rc;
}
#endif

#ifndef PI_HAS_PIINIT
void PIinit()
{
}
#endif
#ifndef PI_HAS_EXIT
/* A default exitall routine.  No longer be needed (see system/exitall) */
#endif

#ifndef PI_HAS_NODENAME
/* A default routine to generate the name of the node */
/*@
  PINodeName - Create a string containing the name of the node

  Input Parameter:
. maxlen - maximum length of string

  Output Parameter:
. name   - holds name

  Description:
  This routine generates a string that identifies a node.  Typically, this
  is of the form
$ machine-name:node-number
  where node-number is the value of MYPROCID. 
@*/
void PINodeName( name, maxlen )
char *name;
int  maxlen;
{
char buf[200], b1[20];
SYGetHostName( buf, 200 );
sprintf( b1, ":%d", MYPROCID );
strncpy( name, buf, maxlen );
strncat( name, b1, maxlen );
}
#endif
