#ifndef lint
static char SCCSid[] = "@(#) ./blog/b2alog.c 07/23/93";
#endif

#include <stdio.h>
#include "tools.h"
#include "blog/blog.h"
#include "system/time/usec.h"

/* 
  This file contains routines to write out a log file in alog format
 */

void BLOG2AlogHeader( fp, procid )
FILE *fp;
int  procid;
{
fprintf( fp, "-1 0 0 0  0 0 Me\n" );
fprintf( fp, "-11 %d 0 0 0 %u\n", procid, SYusc_rollover_val() );
}

void BLOG2AlogHeaderFull( fp, procid, nevents, nevent_types, nnodes, 
		     starttime, endtime )
FILE *fp;
int  procid, nevents, nevent_types, nnodes;
unsigned long starttime[2], endtime[2];
{
fprintf( fp, "-1 0 0 0  0 0 Me\n" ); 
fprintf( fp, "-2 0 0 %d 0 0\n", nevents );
fprintf( fp, "-3 0 0 %d 0 0\n", nnodes );
fprintf( fp, "-4 0 0 1  0 0\n" );
fprintf( fp, "-5 0 0 %d 0 0\n", nevent_types );
fprintf( fp, "-6 0 0 0  %u %u\n", starttime[0], starttime[1] );
fprintf( fp, "-7 0 0 0  %u %u\n", endtime[0], endtime[1] );
fprintf( fp, "-8 0 0 1  0  0\n" );  /* timer cycles */
fprintf( fp, "-11 %d 0 0 0 %u\n", procid, SYusc_rollover_val() );
}

/* 
   This assumes that any a character string may be encoded in the log file.
   We will need to change this to allow the log file to contain additional
   integers, needed for the more elaborate communication tracing
 */
void BLOG2AlogOutput( fp, procid, ap )
FILE *fp;
int  procid, *ap;
{
BLOG_HEADER *b;
BLOG_VFIELD *v;
int         lnleft, dataval1, dataval2;
char        *strp;

b      = (BLOG_HEADER *)ap;
fprintf( fp, "%d %d ", b->event, procid );
lnleft = b->len;
ap += (sizeof(BLOG_HEADER) / sizeof(int));
lnleft -= (sizeof(BLOG_HEADER) / sizeof(int));
if (lnleft > 0) {
    dataval1 = 0;
    dataval2 = 0;
    strp    = "";
    while (lnleft) {
	/* There may be a string or integer data.  It there is integer data,
	   take the first element only */
	v      = (BLOG_VFIELD *)ap;
	ap     += v->len;
	lnleft -= v->len;
	if (v->dtype == BLOG_INT) {
	    dataval1 = v->other[0];
	    if (v->len > (sizeof(BLOG_VFIELD)/sizeof(int)))
		dataval2 = v->other[1];
	    }
	else if (v->dtype == BLOG_CHAR) {
	    strp = (char *)(v->other);
	    }
	}
    /* State events are special - they have two data values  */
    if (b->event == -13) 
	fprintf( fp, "%d %d 0 0 %s\n", dataval1, dataval2, strp );
    else
	fprintf( fp, "0 %d %u %u %s\n", 
		dataval1, b->time.s1[0], b->time.s1[1], strp );
    }
else
    fprintf( fp, "0 0 %u %u\n", 
             b->time.s1[0], b->time.s1[1] );
}


/* Other Header events.  
   Some of these are generated after looking at the values.
 -1                                                    creator and date
 -2                       # events
 -3                       # procs
 -4                       # tasks
 -5                       # event types
 -6                                         start_time
 -7                                         end_time
 -8                       # timer_cycles
 -11                                        timer rollover

  ADD:
 -12  local offset for clock
 -13  local skew for clock
 -14  global offset  clock
      (default values are 0, 1, 0)
 */
