/* 
   This file contains a test program for the routines that generate
   BC programs for global arrays with a variety of decompositions
 */

#include "tools.h"
#include "blkcm/bc.h"
#include "blkcm/mesh.h"
#include <stdio.h>

/*ARGSUSED*/
int main( argc, argv )
int  argc;
char **argv;
{
int         i, nd, myid, nproc;
BCArrayPart sz[5];
BCPGM       *pgm;
int         mdim[5], isp[5], ndim[5], iper[5];

/* Set the defaults */
nd = 3;
mdim[0] = 10;
mdim[1] = 11;
mdim[2] =  6;
mdim[3] =  9;
mdim[4] = 12;
isp[0]  = 1;
isp[1]  = 0;
isp[2]  = 1;
isp[3]  = 0;
isp[4]  = 1;
iper[0] = 0;
iper[1] = 0;
iper[2] = 0;
iper[3] = 0;
iper[4] = 0;
nproc   = 4;
if (SYArgHasName( &argc, argv, 1, "-help" )) {
    fprintf( stderr, 
    "%s [-nd n] [-mdim m1... ] [-isparallel p1 ... ] [-isper p1 ... ]\n",
    argv[0] );
    exit(0);
    }
SYArgGetInt( &argc, argv, 1, "-nd", &nd );
SYArgGetIntVec( &argc, argv, 1, "-mdim", nd, mdim );
SYArgGetIntVec( &argc, argv, 1, "-isparallel",  nd, isp );
SYArgGetIntVec( &argc, argv, 1, "-isper", nd, iper );
SYArgGetInt( &argc, argv, 1, "-np", &nproc );

fprintf( stdout, "Decomposition is:\n" );
for (myid = 0; myid < nproc; myid++) {
    /* Re-initialize the descriptor */
    for (i=0; i<nd; i++) {
	sz[i].mdim        = mdim[i];
	sz[i].is_parallel = isp[i];
	sz[i].ndim        = -1;
	}

    /* Setup the ghost points from the stencil */
    BCFindGhostFromStencil( nd, sz, 0, (int *)0, 11 );

    BCGlobalToLocalArray( nd, sz, nproc, myid );
    BCSetGhostWidths( nd, sz, iper );

    fprintf( stdout, "For processor %d:\n", myid );
    BCPrintArrayPartVerbose( stdout, nd, sz );
    fprintf( stdout, "\n Raw program (uncompiled) for this processor is:\n" );
    pgm = BCBuildArrayPGM( nd, sz, nproc, myid, sizeof(double) );
    BCprint_pgm( pgm, stdout );

    BCfree( pgm );
    }
return 0;
}
