#ifndef lint
static char SCCSid[] = "@(#) ./blkcm/exec/schesend.c 07/23/93";
#endif

/* #define DEBUG */
#include "tools.h"
#include "blkcm/bcp.h"
#include "blkcm/bc.h"
#include <stdio.h>

/*
    This file contains alternate routines that use synchronous sends
    and receives, executing the program as given.  This should be used
    with a program that has been scheduled so that sends are matched
    up with receives.  We still insist that one phase be completed
    before another starts.

    A version of this that uses asynchronous ops can be written.
 */

#ifdef DISTRIBUTED_MEMORY 
extern BCentry *BCdo_recv( );
/* 
   Do sends.  Obey phase partial ordering (this means completing
   all receives from the previous phase before sending)
 */
int BCOrdsend( Program )
BCPGM *Program;
{
int        n;
BCentry *pgm_save, *pgm;
int        (*out)() = Program->out;
int        (*in)()  = Program->in;
int        (*copy)() = Program->copy;
double     *p;

#ifdef DEBUG
printf( "[%d] Starting Ordsend\n", MYPROCID );
#endif
n   = Program->n;
pgm = pgm_save = Program->pgm;
Program->pgm_last = pgm;
while (n--) {
    /* May be local source */
    switch (GET_MAJOR_MODE(pgm)) {
        case BLOCK_COMM_LOCAL_SRC:
            (*copy)( &pgm->src, &((pgm + pgm->processor)->src) );
	    break;
	case BLOCK_COMM_SRC:
      	    /* ???? offsets ???? */
	    p  = pgm->buffer;
	    if (!pgm->inplace)
	        (*out)( &pgm->src, p );
	    if (pgm->type & BLOCK_COMM_BUFFER) {
	        PIbsend( pgm->mtype, p, pgm->act_len, pgm->processor, MSG_DBL );
		}
	    break;
	case BLOCK_COMM_DEST:
	    if (pgm->type & BLOCK_COMM_BUFFER) {
	        PIbrecv(pgm->mtype, pgm->buffer, pgm->act_len, MSG_DBL);
	        }
	    if (!pgm->inplace) {
	        (*in)( pgm->buffer, &pgm->src );
	        }
	    break;
	    }
    NEXTLINE(pgm);
    }
#ifdef DEBUG
printf( "[%d] Ending Ordsend\n", MYPROCID );
#endif
return 0;
}

/* 
   Nothing to wait on.
 */
BCOrdwait( Program )
BCPGM *Program;
{
}

/*@
  BCUseOrderedSend - Use the ordered blocking send routines instead of the 
  default nonblocking send routines.

  Input Parameter:
.  pgm - make this program use the ordered, blocking send routines

  Notes:
  This routine also re-orders the sends and receives so that processors
  exchanging messages alternate between sending and receiving.  This can
  improve performance and, more importantly, avoid possible resource 
  exhaustion caused by requiring too much buffer space.
 @*/
void BCUseOrderedSend( pgm )
BCPGM *pgm;
{
extern void BCSortSRPairs();
pgm->schedule = (int (*)())BCSortSRPairs;
pgm->isend    = BCOrdsend;
pgm->iwait    = BCOrdwait;  /* null routine */
pgm->irecv    = BCOrdwait;  /* null routine */
}
#else
void BCUseOrderedSend( pgm )
BCPGM *pgm;
{
}	
#endif
