#ifndef lint
static char SCCSid[] = "@(#) ./blkcm/defn/setptr.c 07/23/93";
#endif

/* 
   This file contains routines for only the create and execute program
   operations
 */
#include "blkcm/bcp.h"
#include "blkcm/bc.h"

/*
   Set the pointers in the program 
 */
BCSetPointers( Program, sctx, dctx )
BCPGM *Program;
void  *sctx, *dctx;
{
BCentry *src;
slab       *s;
int        n;

n   = Program->n;
src = Program->pgm;
while (n--) {
    s = &(src->src);
    if (IS_SRC(src) || IS_LOCAL_SRC(src)) {
	s->p = (*Program->GetAddressSrc)( sctx, s->lctx );
#ifdef DISTRIBUTED_MEMORY
	if (src->inplace) 
	    src->buffer = s->p;
#endif
	}
    else if (IS_DEST(src) || IS_LOCAL_DEST(src)) {
	s->p = (*Program->GetAddressDest)( dctx, s->lctx );
#ifdef DISTRIBUTED_MEMORY
	if (src->inplace) 
	    src->buffer = s->p;
#endif
	}
    NEXTLINE(src);
    }
}

/*
   Default get address function.  In this case, the "ctx" (passed in the
   BCexec call) is the OFFSET from the array that was specified in the
   BCset?d (the "lctx").
 */
double *BCDefaultAddress( ctx, lctx )
int    ctx;
double *lctx;
{
return lctx + ctx;
}

/*
   Alternate default get address function.  In this case, the "ctx" (passed in
   the BCexec call) is the base array address and "lctx" (specified in the 
   BCset?d call) is the offset from this address.
 */
double *BCDefaultAddress2( ctx, lctx )
int    lctx;
double *ctx;
{
return lctx + ctx;
}




