#ifndef lint
static char SCCSid[] = "@(#) ./blkcm/copy/util4d.c 07/23/93";
#endif

/* 
    This file contains routines for moveing data from one slab to 
    another.  Inorder to make motion to/from a communications
    buffer efficient, special cases for compacted (unit stride)
    storage are included.
 */

#include "tools.h"
#include "blkcm/bcp.h"

BCs_to_d4d( s, d )
slab *s, *d;
{
register double *sp3 = s->p;
register double *dp3 = d->p;
register double *sp1, *sp, *dp1, *dp, *sp2, *dp2;
register int    n4  = s->n4, n2, n1, dinc = d->s1, sinc = s->s1, n3;

while (n4--) {
    n3 = s->n3;
    dp2 = dp3;
    sp2 = sp3;
    while (n3--) {
	n2 = s->n2;
	dp1= dp2;
	sp1= sp2;
	while (n2--) {
	    n1 = s->n1;
	    dp = dp1;
	    sp = sp1;
	    while (n1--) {
		*dp = *sp;
		dp  += dinc;
		sp  += sinc;
		}
	    dp1 += d->inc1;
	    sp1 += s->inc1;
	    }
	dp2 += d->inc2;
	sp2 += s->inc2;
	}
    dp3 += d->inc3;
    sp3 += s->inc3;
    }
}

BCs_to_b4d( s, b )
slab   *s;
double *b;
{
register double *sp3 = s->p;
register double *dp = b;
register double *sp1, *sp, *sp2;
register int    n4  = s->n4, n2, n1, spinc = s->s1, n3;

while (n4--) {
    n3 = s->n3;
    sp2= sp3;
    while (n3--) {
	n2 = s->n2;
	sp1= sp2;
	while (n2--) {
	    n1 = s->n1;
	    sp = sp1;
	    while (n1--) {
		*dp++ = *sp;
		sp  += spinc;
		}
	    sp1 += s->inc1;
	    }
	sp2 += s->inc2;
	}
    sp3 += s->inc3;
    }
}


BCb_to_d4d( b, d )
slab   *d;
double *b;
{
register double *sp = b;
register double *dp3 = d->p;
register double *dp1, *dp, *dp2;
register int    n4  = d->n4, n2, n1, dpinc = d->s1, n3;

while (n4--) {
    n3  = d->n3;
    dp2 = dp3;
    while (n3--) {
	n2 = d->n2;
	dp1= dp2;
	while (n2--) {
	    n1 = d->n1;
	    dp = dp1;
	    while (n1--) {
		*dp = *sp++;
		dp  += dpinc;
		}
	    dp1 += d->inc1;
	    }
	dp2 += d->inc2;
	}
    dp3 += d->inc3;
    }
}

#include "blkcm/bc.h"
/* 
   Routine to set the entries for a line for a 4-d structure
 */
int BCset4d( Program, line, id, phase, kind, 
	    p, n1, n2, n3, n4, s1, inc1, inc2, inc3 )
BCPGM  *Program;
int    line, id, phase, kind, n1, n2, n3, n4, s1, inc1, inc2, inc3;
void   *p;
{
BCentry *pgm;

pgm = (*Program->getline)( Program, line );
if (!pgm) return ERR_NO_PGM_LINE;

pgm->id       = id;
pgm->phase    = phase;
pgm->type     = kind;
pgm->processor= -1;
pgm->src.s1   = s1;
pgm->src.n1   = n1;
pgm->src.n2   = n2;
pgm->src.n3   = n3;
pgm->src.n4   = n4;
pgm->src.n5   = 1;
pgm->src.inc1 = inc1;
pgm->src.inc2 = inc2;
pgm->src.inc3 = inc3;
pgm->src.inc4 = 1;
pgm->src.lctx = p;

BCSetMaxdim( Program, n1, n2, n3, n4, 1 );
return ERR_NONE;
}
