#ifndef lint
static char SCCSid[] = "@(#) ./blkcm/copy/util1dad.c 07/23/93";
#endif

/* 
    This file contains routines for moveing data from one slab to 
    another.  Inorder to make motion to/from a communications
    buffer efficient, special cases for compacted (unit stride)
    storage are included.
 */
#include "blkcm/bcp.h"
#include "inline/copy.h"

/* 
  If you KNOW that you are moving 1-d slices, consider using these routines.
  There is an optimization option (TRIMMOVE) that will try to 
  use these routines.  Note that the stride is probably != 1 since 
  if the stride == 1, the inplace option will probably be used.
 */

BCs_to_d1dadd( s, d )
slab *s, *d;
{
register double *sp = s->p;
register double *dp = d->p;
register int    n1  = s->n1, dinc = d->s1, sinc = s->s1;

while(n1--) {
    *dp += *sp; 
    dp  +=dinc; 
    sp  += sinc;
    }
}

BCb_to_d1dadd( b, d )
slab   *d;
double *b;
{
register double *sp = b;
register double *dp = d->p;
register int    n1  = d->n1, dpinc = d->s1;

while(n1--) {
    *dp += *sp++; 
    dp  +=dpinc;
    }
}

