#ifndef lint
static char SCCSid[] = "@(#) ./blkcm/compile/settype.c 07/23/93";
#endif

#include "blkcm/bcp.h"
#include "blkcm/bc.h"
#ifdef DISTRIBUTED_MEMORY

/*
   This routine sets the message types.  It should be replace/augmented
   with one that determines the types at runtime.  In addition, it could
   look for forcetypes and pair exchanges.

   Algorithm:
   Find range of phases.  Make mtype = BASE_MTYPE + (id .. (phase-minphase)),
   where id is shifted enough to leave room for the phase.

   We ALSO need to make the types unique to a PROCESS that holds multiple
   programs.  Perhaps using a static that everyone agrees on (max of
   any current value?).
 */
BCset_types( Program )
BCPGM *Program;
{
BCentry *pgm = Program->pgm;
int        n    = Program->n;
int        minphase, maxphase, psize, shft,
           btype= Program->basetype;

/* Set defaults for the min/max phases for those processors that have
   no programs */
minphase = 2000000000;
maxphase = -2000000000;
if (n != 0) {
    /* Find the range of phases */
    minphase = pgm->phase;
    maxphase = minphase;
    n--;
    NEXTLINE(pgm);
    while (n--) {
	if (pgm->phase > maxphase)      maxphase = pgm->phase;
	else if (pgm->phase < minphase) minphase = pgm->phase;
	NEXTLINE(pgm);
	}
    }
/* Make sure that we have the phase limits for ALL processors */
GIMIN( &minphase, 1, &shft, 0 );
GIMAX( &maxphase, 1, &shft, 0 );

/* shft is the number of BITS in psize */
shft = 0;
psize= maxphase - minphase;
while (psize > 0) {
    psize >>= 1;
    shft++;
    }
/* Should check for shft out-of-range */

/* Set the message types */
pgm = Program->pgm;
n   = Program->n;
/* The "buffer" routine sets mtype to id prior to this */
while (n--) {
    if (pgm->type & BLOCK_COMM_BUFFER) {
	pgm->mtype = btype + (pgm->mtype << shft) + pgm->phase - minphase;
	/* ForceType bit set in send/recv routines */
	}
    NEXTLINE(pgm);
    }
}

BCset_types_dynamic( Program )
BCPGM *Program;
{
}
#endif

/* 
   Let the user set the base type to use
 */
BCset_base_type( Program, val )
BCPGM *Program;
int   val;
{
Program->basetype = val;
}











