#ifndef lint
static char SCCSid[] = "@(#) ./blkcm/compile/findloc.c 07/23/93";
#endif

/*
   This file contains routines to find LOCAL transfers and adjust the
   program refs (processor field becomes local offset).

   Alogrithm:
   (Assumes program is sorted so that dests preceed sources and id's
   are in increasing order

   Find a local source.  Find matching local dest.  (Find here means
   moving down the program, exploiting the sorted order).  Change
   DEST to LOCALDEST; SRC to LOCALSRC; adjust "processor" field to 
   offset to DEST.

   Algorithm:
   Sorting order is (Phase,Type,Processor,Id).  Match them in this order,
   taking advantage that DEST preceeds SRC.  Note that if we FAIL to 
   find a match, we need to repeat some DEST values.
 */

#include "blkcm/bc.h"
#include "blkcm/bcp.h"

BCfind_local( Program )
BCPGM *Program;
{
BCentry *src, *dest;
int     n;

n   = Program->n;
src = dest = Program->pgm;
BCfind_localInFrag( src, dest, n );
}

/*
  This routine is separate so that we can apply it to a partial fragment.
 */
BCfind_localInFrag( src, dest, n )
BCentry *src, *dest;
int     n;
{
BCentry *dest_save;

while (n--) {
    if (IS_SRC(src)) {
	/* Skip to the same phase */
	while (dest < src && dest->phase < src->phase)
	    NEXTLINE(dest);
	/* Find destinations (this should never trigger, unless type==0) */
	while (!IS_DEST(dest) && dest < src)
	    NEXTLINE(dest);
	/* We have now matched (Phase,Type), look for ID.  Note that
	   the processor is either -1 (if FindOwner) or mynode() (if
	   set by the user) */
	dest_save = dest;
	while (IS_DEST(dest) && dest < src) {
	    /* Don't go too far... */
	    if (dest->phase == src->phase && dest->id > src->id) break;
	    /* Check for match */
	    if (dest->id == src->id && dest->phase == src->phase) {
		SET_MAJOR_MODE(src,BLOCK_COMM_LOCAL_SRC);
		SET_MAJOR_MODE(dest,BLOCK_COMM_LOCAL_DEST);
		src->processor = (int)(dest-src);
		/* skip to next dest */
		NEXTLINE(dest);
		dest_save = dest;
		break;
		}
	    NEXTLINE(dest);
	    }
	/* Set the next dest to use */
	dest = dest_save;
	}
    NEXTLINE(src);
    }
}

