/*
 *
 * $Source: /filesv/usr/local/proj/sphinx/spx2/src/user/RCS/spxlist.c,v $
 *
 *
 *  MODULE NAME:    spxlist.c
 *
 *
 *  AUTHORS:
 *
 *	K. Alagappan
 *
 */


/*
 * COPYRIGHT (C) 1992 DIGITAL EQUIPMENT CORPORATION
 * ALL RIGHTS RESERVED
 *
 * "Digital Equipment Corporation authorizes the reproduction,
 * distribution and modification of this software subject to the following
 * restrictions:
 * 
 * 1.  Any partial or whole copy of this software, or any modification
 * thereof, must include this copyright notice in its entirety.
 *
 * 2.  This software is supplied "as is" with no warranty of any kind,
 * expressed or implied, for any purpose, including any warranty of fitness 
 * or merchantibility.  DIGITAL assumes no responsibility for the use or
 * reliability of this software, nor promises to provide any form of 
 * support for it on any basis.
 *
 * 3.  Distribution of this software is authorized only if no profit or
 * remuneration of any kind is received in exchange for such distribution. 
 * 
 * 4.  This software and all application programs are to be used only for
 * non-commercial purposes. However, media costs associated with the
 * distribution of the software or application programs may be recovered.
 *
 */


#include <stdio.h>
#include <pwd.h>
#include <sys/types.h>
#include <sys/file.h>
#include <sys/time.h>
#include <sys/param.h>
#include "random.h"
#include "BigNum.h"
#include "BigRSA.h"
#include "cdc.h"
#include "cdc_db.h"
#include "spxapi_defs.h"

extern int optind, opterr;
extern char *optarg;

char   *progname, *rindex();

main(argc, argv)
int    argc;
char  *argv[];
{
    register char *cp;
    int     c, errflg = 0;
    char    aname[ANAME_SZ], answ[10];
    int     vflag = 0, iflag = 0, cred_valid;
    struct passwd      *pwd;
    ClaimantCred       cred;
    TrustedCred        ta_cred;

    progname = (cp = rindex(*argv, '/')) ? cp + 1 : *argv;

    opterr = 0;
    while ((c=getopt(argc, argv, "vi")) != EOF)
      switch(c) {
        case 'v' :
	  vflag = 1;
	  break;
        case 'i' :
	  iflag = 1;
	  break;
	case '?' :
	  errflg++;
	}
    if (argv[optind] == NULL) {
      pwd = getpwuid(getuid());
      strcpy(aname, pwd->pw_name);
      if (!*aname)
	exit(0);
    } else strcpy(aname, argv[optind++]);
    if (optind != argc)  errflg++;

    if (errflg) {
      printf("Usage: %s [-v] [name]\n", progname);
      printf("\t-v      verbose mode\n");
      printf("\t          (default local account name)\n");
      exit(1);
    }

  /*  read claimant credentials from issuer's file  */

  if (spx_tf_init(spx_tkt_string(aname, NULL), R_TKT_FIL) != ASUCCESS) {
    printf("claimant credential file doesn't exist\n");
    exit(-1);
  }

  spx_tf_get_cred(aname, &cred, &ta_cred);

  printf("\nClaimant credentials for local user %s",cred.name);
  if (strcmp(cred.name, aname) != 0) printf(" ( being used by %s )\n\n", aname);
  else printf("\n\n");
  cred_valid = display_claimant_cred(&cred, vflag);
  printf("\n%s\n\thas ", cred.fullname);
  display_ta_cred(&ta_cred,vflag);
  printf("\n");
  if (!cred_valid)  {
    printf("Credentials expired ... delete ?  [y] : ");
    gets(answ);
    if ((answ[0] != 'n') && (answ[0] != 'N')) dest_claimant(1);
  } else {
    if (iflag) {
      printf("Enter <return> to exit : ");
      gets(answ);
    }
  }
}

local_hexdump(p, l)
char *p;
int l;
{
  int i;

  for (i=0; i<l; i++)  {
    printf("%02x", (unsigned char ) p[i]);
  }
}
