/*
 *
 * $Source: /filesv/usr/local/proj/sphinx/spx2/src/lib/cfile/RCS/get_in_vfile.c,v $
 *
 *
 *  MODULE NAME:    get_in_vfile.c
 *
 *
 *  AUTHORS:
 *
 *	K. Alagappan
 *
 */


/*
 * COPYRIGHT (C) 1992 DIGITAL EQUIPMENT CORPORATION
 * ALL RIGHTS RESERVED
 *
 * "Digital Equipment Corporation authorizes the reproduction,
 * distribution and modification of this software subject to the following
 * restrictions:
 * 
 * 1.  Any partial or whole copy of this software, or any modification
 * thereof, must include this copyright notice in its entirety.
 *
 * 2.  This software is supplied "as is" with no warranty of any kind,
 * expressed or implied, for any purpose, including any warranty of fitness 
 * or merchantibility.  DIGITAL assumes no responsibility for the use or
 * reliability of this software, nor promises to provide any form of 
 * support for it on any basis.
 *
 * 3.  Distribution of this software is authorized only if no profit or
 * remuneration of any kind is received in exchange for such distribution. 
 * 
 * 4.  This software and all application programs are to be used only for
 * non-commercial purposes. However, media costs associated with the
 * distribution of the software or application programs may be recovered.
 *
 */


#include <stdio.h>
#include "BigNum.h"
#include "BigRSA.h"
#include "SPHINX-types.h"
#include "random.h"
#include "hashes.h"
#include "cdc.h"
#include "cdc_db.h"
#include "spxapi_defs.h"

#ifdef sun
#define strcasecmp     strcmp_support
#endif

#define MAX_SIZE 2*DigitLim*sizeof(BigNumDigit)

#define ILLEGAL_PASSWORD     -3

int cdc_get_pwd_in_vfile(server, life, uselocalfile, ca, vflag)
char *server, *ca;
int  life, uselocalfile, vflag;
{
    int     ta_index = 0, ta_num = 0, status;
    static  char server_ava[ANAME_SZ], ca_fullname[FULLNAME_SZ];
    static  char domain_fullname[FULLNAME_SZ], fullname[FULLNAME_SZ];
    static  char uuid[UID_SZ], issuer_uuid[UID_SZ];
    int     issuer_uidlen=0, uidlen = 0 ;
    static  RSAKeyStorage serverRSAKey;
    char    princ_name[ANAME_SZ], cdc_server[FULLNAME_SZ];
    time_t  start_time,end_time;
    TrustedCred       *ta_cred;
    TrustedAuthority  *ta;
    struct type_SPHINX_Certificate            *tacertif;

    strcpy(domain_fullname, get_domain_name(NULL));
    strcpy(ca_fullname, domain_fullname);
    strcat(ca_fullname, "/");
    strcat(ca_fullname, ca);
    strcpy(fullname, ca_fullname);
    strcat(fullname, "/CN=");
    strcat(fullname, server);

    if (uselocalfile == 1) {
      char hashk[MD_BLOCK_SIZE];
      if (read_privkey_verbose(server,server_ava, uuid, &uidlen, hashk, &serverRSAKey, NULL) == 0) {
	printf("\n%s: Error decoding issuer private key.\n",__FILE__);
        bzero(&serverRSAKey, sizeof(serverRSAKey));
	return(-1);
      }
    } else {
      DESblock pwkey;
      char  privkey[sizeof(RSAKeyStorage)];
      int privkeylen;
      if ((status=read_login_cstub(fullname, 0, privkey, &privkeylen, cdc_server, 0)) != 0) {
	return(status);
      }
      DES_read_password(&pwkey, "password: ", 0);
      if(!recover_private(&pwkey,privkey,privkeylen,&serverRSAKey)) {
	bzero(&pwkey, sizeof(pwkey));
	bzero(privkey, sizeof(privkey));
        bzero(&serverRSAKey, sizeof(serverRSAKey));
	return(ILLEGAL_PASSWORD);
      }
      bzero(&pwkey, sizeof(pwkey));
      bzero(privkey, sizeof(privkey));
    }

    /*  get server's uid if one exists from ta certif  */

    ta_cred = (TrustedCred *) malloc(sizeof(TrustedCred));
    ta_cred->count = 0;
    ta_cred->head = NULL;
    if (uselocalfile == 1) {
      char  ta_certif_buf[CERTIF_SZ];
      int ta_certiflen;
      if (read_certif(server,ca,ta_certif_buf,&ta_certiflen)<0){
        printf("\n%s: Error recovering local ta certificate.", __FILE__);
        bzero(&serverRSAKey, sizeof(serverRSAKey));
        return(-1);
      }        
      tacertif = (struct type_SPHINX_Certificate *) 
                      decode_certif_aux(ta_certif_buf, ta_certiflen);
      if ((tacertif != NULL) &&
        	     (verify_certif_aux(tacertif, &serverRSAKey)==1)) {
	ta = (TrustedAuthority *) malloc(sizeof(TrustedAuthority));
	ta_cred->head = ta;
	ta_cred->count = 1;
	ta->next = NULL;
	strcpy(ta->fullname, rdn_to_str(tacertif->cinfo->subject));
        if(uid_from_certif( tacertif->cinfo, ta->uuid, &ta->uidlen, uuid, &uidlen ));
	else {
	  printf("Warning: UIDs don't exist in TA certificates, set to 0\n");
	  bzero(ta->uuid, UID_SZ);
	  ta->uidlen = 0;
	  bzero(uuid, UID_SZ);
	  uidlen = 0;
	}
	ta_num++;
	if (ta->pubRSAKey = (RSAKeyStorage *) calloc(sizeof(RSAKeyStorage), 1));
        else {
            printf("\n%s: Allocation Error.\n", __FILE__);
            bzero(&serverRSAKey, sizeof(serverRSAKey));
            return(-1);
        }
	if (key_from_certif(tacertif->cinfo,ta->pubRSAKey)&&(uselocalfile));
        else {
	  printf("\n%s: local TA public key is invalid\n", __FILE__);
          bzero(&serverRSAKey, sizeof(serverRSAKey));
	  return(-1);
	}
	if (strcasecmp(get_local_name(tacertif->cinfo->issuer), server) != 0)
	  printf("last ava of issuer name in TA certif isn't for me.\n");
	if (str_cmp(ta->fullname, fullname) != 1) ta->cross_certifier = 1;
	else  ta->cross_certifier = 0;
#ifdef DEBUG
printf("\n%s: ta_num=%d\n", __FILE__, ta_num);
#endif
      }
      else {
        printf("\n%s: verify of ta failed.\n", __FILE__);
        bzero(&serverRSAKey, sizeof(serverRSAKey));
        return(-1);
      }
    } else {
      ta_index = 0;
      if (build_ta_cred(fullname,2,&ta_index,ta_cred,&serverRSAKey,&tacertif,cdc_server)>0) {
        if(uid_from_certif(tacertif->cinfo, issuer_uuid, &issuer_uidlen, uuid, &uidlen));
	else {
	  printf("Warning: UIDs don't exist in TA certificates, set to 0\n");
	  bzero(uuid, UID_SZ);
	  uidlen = 0;
	}
        free_SPHINX_Certificate(tacertif);
      }
      if (ta_index != 0)  printf("%s: didn't get all the TAs for %s\n", __FILE__, server);
    }

    /*  initialize credential file cache  */

    if (in_ver(server, NULL) != ASUCCESS) {
      printf("%s: unable to initialize verifier file\n", __FILE__);
      bzero(&serverRSAKey, sizeof(serverRSAKey));
      return(-1);
    }
    if (vf_init(ver_string(server, NULL), W_TKT_FIL) != ASUCCESS) {
      printf("%s: cannot vf_init\n",__FILE__);
      bzero(&serverRSAKey, sizeof(serverRSAKey));
      return(-1);
    }
    if (vf_get_pname(princ_name) != ASUCCESS) {
      printf("%s: vf_get_pname error\n",__FILE__);
      bzero(&serverRSAKey, sizeof(serverRSAKey));
      return(-1);
    }

    start_time=time(0);
    end_time = start_time+life*60;
    vf_save_cred(fullname, uidlen, uuid, start_time, end_time, &serverRSAKey);

    /*  get more ta(s) if exist  */

    ta = ta_cred->head;
    while (ta) {
      if (strcasecmp(ca_fullname, ta->fullname) == 0) {
	bcopy(ta->pubRSAKey , &serverRSAKey, PUBLIC_KEY_SIZE);
	ta_index = 0;
	build_ta_cred(ca_fullname,1,&ta_index,ta_cred,&serverRSAKey,&tacertif,cdc_server);
	break;
      }
      ta = ta->next;
    }

    while (ta) {
      if (strcasecmp(domain_fullname, ta->fullname) == 0) {
	bcopy(ta->pubRSAKey , &serverRSAKey, PUBLIC_KEY_SIZE);
	ta_index = 0;
	build_ta_cred(domain_fullname,0,&ta_index,ta_cred,&serverRSAKey,&tacertif,cdc_server);
	break;
      }
      ta = ta->next;
    }
    vf_save_ta(ta_cred);
    vf_close();
    bzero(&serverRSAKey, sizeof(serverRSAKey));
    return(0);
}

