/*
 *
 * $Source: /filesv/usr/local/proj/sphinx/spx2/src/lib/cfile/RCS/build_ta_cred.c,v $
 *
 *
 *  MODULE NAME:    build_ta_cred.c
 *
 *
 *  AUTHORS:
 *
 *	K. Alagappan
 *
 */


/*
 * COPYRIGHT (C) 1992 DIGITAL EQUIPMENT CORPORATION
 * ALL RIGHTS RESERVED
 *
 * "Digital Equipment Corporation authorizes the reproduction,
 * distribution and modification of this software subject to the following
 * restrictions:
 * 
 * 1.  Any partial or whole copy of this software, or any modification
 * thereof, must include this copyright notice in its entirety.
 *
 * 2.  This software is supplied "as is" with no warranty of any kind,
 * expressed or implied, for any purpose, including any warranty of fitness 
 * or merchantibility.  DIGITAL assumes no responsibility for the use or
 * reliability of this software, nor promises to provide any form of 
 * support for it on any basis.
 *
 * 3.  Distribution of this software is authorized only if no profit or
 * remuneration of any kind is received in exchange for such distribution. 
 * 
 * 4.  This software and all application programs are to be used only for
 * non-commercial purposes. However, media costs associated with the
 * distribution of the software or application programs may be recovered.
 *
 */


#include <stdio.h>
#include <syslog.h>
#include <pwd.h>
#include "BigNum.h"
#include "BigRSA.h"
#include "SPHINX-types.h"
#include "objid.h"
#include "cdc.h"
#include "cdc_db.h"
#include "random.h"
#include "spxapi_defs.h"

#ifdef sun
#define strcasecmp     strcmp_support
#endif

extern KTEXT_ST cfile_rpkt_st;
extern KTEXT cfile_rpkt;           /* response packet from CDC */

extern int ps_len_strategy;

int build_ta_cred(uselocalfile,fullname, level, ta_index, ta_cred, issu_RSAKey, good_tacertif,cdc_server)
int  uselocalfile;
char *fullname;
int  level;
int  *ta_index;
TrustedCred       *ta_cred;
RSAKeyStorage    *issu_RSAKey;
struct type_SPHINX_Certificate     **good_tacertif;
char  *cdc_server;
{
  int debugflag = 0, strcmpflag, i, status;
  char *name, *cp, myname[40], localcdcfile[80];
  char    *tapubkey = NULL, *tauid = NULL;
  int     tapubkeylen, ta_num, tauidlen, numtacertif;
  TrustedAuthority  *ta_new = NULL, *ta = NULL, *ta_tmp = NULL, *ta_next = NULL;
  struct type_SPHINX_Certificate            *tacertif;
  struct type_SPHINX_CertPath               *ta_certif_path;
  struct passwd       *pwd;


  ta_num = 0;

  name = (cp = rindex(fullname, '=')) ? cp + 1 : fullname;
  do {
    if (uselocalfile) {
      pwd = getpwuid(getuid());
      strcpy(myname, pwd->pw_name);

      strcpy(localcdcfile, pwd->pw_dir);
      strcat(localcdcfile, "/.SPX_");
      strcat(localcdcfile, myname);
      switch (level) {
        case 2 : 
	  strcat(localcdcfile, ".userTA");
	  break;
        case 1 : 
	  strcat(localcdcfile, ".caTA");
	  break;
        case 0 : 
	  strcat(localcdcfile, ".domainTA");
	  break;
	default :
	  return(-1);
	  break;
      }

      status = cfile_file_hexread(localcdcfile, cfile_rpkt->dat, &cfile_rpkt->length);
      if (!status) {
	printf("unable to read ");
	switch (level) {
          case 2 : 
	    printf("userTA");
	    break;
	  case 1 : 
	    printf("caTA");
	    break;
	  case 0 : 
	    printf("domainTA");
	    break;
	}
	printf(" certificates from local file\n");
	return(-1);
      }
      status = check_tacertif_res_apdu(cfile_rpkt->dat, cfile_rpkt->length, ta_index, &ta_certif_path, debugflag);
    } else {
      if (read_tacertif_cstub(cfile_rpkt, fullname, level, 0, ta_index, &ta_certif_path, cdc_server, debugflag)<0) {
	syslog(LOG_INFO,"unable to get ta_certif for %s\n",fullname);
	return(-1);
      }
    }
    if (ta_certif_path == NULL) {
      return(0);
    } else {
      numtacertif = 0;
      do {
	if (numtacertif != 0) ta_certif_path = ta_certif_path->next;
	tacertif = ta_certif_path->Certificate;

	if ((tacertif != NULL) &&
	    (verify_certif_aux(tacertif, issu_RSAKey)==1)) {
	  ta_new = (TrustedAuthority *) malloc(sizeof(TrustedAuthority));
	  strcpy(ta_new->fullname, rdn_to_str(tacertif->cinfo->subject));
	  if ((tacertif->cinfo->version != NULL) &&
	      (tacertif->cinfo->version->parm == int_SPHINX_Version_v1992)) {
	    tauid = bitstr2strb(tacertif->cinfo->subjectUID, &tauidlen);
	    ta_new->uidlen = (tauidlen + 7)/8;
	    bcopy(tauid, ta_new->uuid, ta_new->uidlen);
	  } else {
	    bzero(ta_new->uuid, UID_SZ);
	    ta_new->uidlen = 0;
	  }
	  tapubkey = bitstr2strb(tacertif->cinfo->subjectPublicKey->subjectPublicKey, &tapubkeylen);
	  ta_new->pubRSAKey = (RSAKeyStorage *) calloc(sizeof(RSAKeyStorage), 1);
	  if (DecodePublic(tapubkey, ta_new->pubRSAKey) == NULL) {
	    syslog(LOG_INFO,"unable to verify %s 's TA public key\n",ta_new->fullname);
	    free(ta_new);
	  } else {
	    if (strcasecmp(get_local_name(tacertif->cinfo->issuer), name) != 0) {
	      syslog(LOG_INFO,"build_ta_cred : last ava of issuer name in TA certif isn't for me");
	      if (ta_num==0)  return(-1);
	    }
	    strcmpflag = str_cmp(ta_new->fullname, rdn_to_str(tacertif->cinfo->issuer));
	    if ((strcasecmp(fullname, rdn_to_str(tacertif->cinfo->issuer)) != 0) && (strcmpflag > 0))
	      ta_new->cross_certifier = 1;
	    else  ta_new->cross_certifier = 0;
	    if (ta_num == 0) *good_tacertif = tacertif;
	    ta_num++;
	    ta_new->next = NULL;
	    if (ta_cred->head != NULL) {
	      for (ta = ta_tmp = ta_cred->head; ta != NULL; ta = (TrustedAuthority  *) ta->next) {
		ta_next = (TrustedAuthority  *) ta->next;
		if ((ta_next != NULL) && (ta_next->cross_certifier)) {
		  break;
		}
		i = str_cmp(ta_new->fullname, ta->fullname);
		if ((i < 0) && (ta_new->cross_certifier == 0)) {
		  break;
		}
		if (ta_tmp->next != NULL)
		  ta_tmp = (TrustedAuthority *) ta_tmp->next;
	      }
	      ta_new->next = ta_tmp->next;
	      ta_tmp->next = (TrustedAuthority *) ta_new;
	    } else {
	      ta_cred->head = ta_new;
	      ta = ta_new;
	      ta->next = NULL;
	    }
	  }
	} else {
	  if (ta_num==0)  return(-1);
	}
	numtacertif++;
      } while (ta_certif_path->next != NULL);
    }
  } while (*ta_index != 0);
  ta_cred->count = ta_cred->count + ta_num;
  return(ta_num);
}
