/*
 *
 * $Source: /filesv/usr/local/proj/sphinx/spx2/src/lib/api/RCS/display_token_struct.c,v $
 *
 *
 *  MODULE NAME:    display_token_struct.c
 *
 *
 *  AUTHORS:
 *
 *	K. Alagappan
 *
 */


/*
 * COPYRIGHT (C) 1992 DIGITAL EQUIPMENT CORPORATION
 * ALL RIGHTS RESERVED
 *
 * "Digital Equipment Corporation authorizes the reproduction,
 * distribution and modification of this software subject to the following
 * restrictions:
 * 
 * 1.  Any partial or whole copy of this software, or any modification
 * thereof, must include this copyright notice in its entirety.
 *
 * 2.  This software is supplied "as is" with no warranty of any kind,
 * expressed or implied, for any purpose, including any warranty of fitness 
 * or merchantibility.  DIGITAL assumes no responsibility for the use or
 * reliability of this software, nor promises to provide any form of 
 * support for it on any basis.
 *
 * 3.  Distribution of this software is authorized only if no profit or
 * remuneration of any kind is received in exchange for such distribution. 
 * 
 * 4.  This software and all application programs are to be used only for
 * non-commercial purposes. However, media costs associated with the
 * distribution of the software or application programs may be recovered.
 *
 */


#include <stdio.h>
#include "BigNum.h"
#include "BigDyad.h"
#include "BigRSA.h"
#include "SPHINX-types.h"
#include "objid.h"

extern int optind, opterr;
extern char *optarg;

display_token_struct(authtoken)
struct type_SPHINX_AuthenticationToken    *authtoken;
{
  int  j;
  
  if (authtoken->version == NULL)  printf("    version is NULL\n");
  else printf("    version is '%s'\n", qb2str(authtoken->version));
  printf("    authenticator {\n");
  printf("        authinfo {\n");
  printf("            type is ");
  token_oneline_hexdump(bitstr2strb(authtoken->authenticator->authenticatorInfo->type, &j), (j+7)/8);
  printf("            whensigned is %d\n", authtoken->authenticator->authenticatorInfo->whenSigned->seconds);
  printf("            channelId is '%s'\n", qb2str(authtoken->authenticator->authenticatorInfo->channelId));
  printf("        }\n");
  printf("        signature is ");
  token_oneline_hexdump(bitstr2strb(authtoken->authenticator->signature, &j), (j+7)/8);
  printf("    }\n");
  printf("    encryptedkey {\n");
  printf("        encryptedAuthKey is ");
  token_oneline_hexdump(bitstr2strb(authtoken->encryptedkey->encryptedAuthKey, &j), (j+7)/8);
  printf("    }\n");
  printf("    userclaimant {\n");
  printf("        userTicket {\n");
  printf("            tktinfo {\n");
  printf("                version is ");
  if (authtoken->userclaimant->userTicket->tktinfo->version == NULL) printf("NULL\n");
  else printf("'%s'\n", qb2str(authtoken->userclaimant->userTicket->tktinfo->version));
  printf("                validity {\n");
  j = authtoken->userclaimant->userTicket->tktinfo->validity->notBefore->parm;
  printf("                    before is %d or %s", j, asctime(localtime(&j)));
  j = authtoken->userclaimant->userTicket->tktinfo->validity->notAfter->parm;
  printf("                    after is %d or %s", j, asctime(localtime(&j)));
  printf("                }\n");
  printf("                subject_uid is ");
  token_oneline_hexdump(bitstr2strb(authtoken->userclaimant->userTicket->tktinfo->subjectUID, &j), (j+7)/8);
  printf("                delegatingPublicKey is ");
  token_oneline_hexdump(bitstr2strb(authtoken->userclaimant->userTicket->tktinfo->delegatingPublicKey, &j), (j+7)/8);
  printf("            }\n");
  printf("            signature is ");
  token_oneline_hexdump(bitstr2strb(authtoken->userclaimant->userTicket->signature, &j), (j+7)/8);
  printf("        }\n");
  printf("        evidence {\n");
  if (authtoken->userclaimant->evidence->offset == type_SPHINX_Evidence_delegator) {
    printf("            Delegator\n");
    printf("            encryptedPrivKey is ");
    token_oneline_hexdump(bitstr2strb(authtoken->userclaimant->evidence->un.delegator->encryptedPrivKey, &j), (j+7)/8);
  } else {
    printf("            SharedKeyTicketSignature\n");
    printf("            signatureBits is ");
    token_oneline_hexdump(bitstr2strb(authtoken->userclaimant->evidence->un.sharedKeyTicketSignature->signatureBits, &j), (j+7)/8);
  }
  printf("        }\n");
  printf("        userName is ");
  if (authtoken->userclaimant->userName == NULL)  printf("NULL\n");
  else printf("'%s'\n",rdn_to_str(authtoken->userclaimant->userName));
  printf("    }\n");
  if (authtoken->nodeclaimant == NULL)
    printf("    nodeclaimant is NULL\n");
  else {
    printf("    nodeclaimant {\n");
    printf("        SOMETHING\n");
    printf("    }\n");
  }
  printf("}\n");
}

static token_oneline_hexdump(p, l)
char *p;
int l;
{
  int i;

  for (i=0; i<l; i++)  {
/*
    if ((i>0) && (i%16 == 0))  printf("\n");
*/
    printf("%02x", (unsigned char ) p[i]);
  }
  printf("\n");
}
