/* hashes.h */

/*
 * COPYRIGHT (C) 1992 DIGITAL EQUIPMENT CORPORATION
 * ALL RIGHTS RESERVED
 *
 * "Digital Equipment Corporation authorizes the reproduction,
 * distribution and modification of this software subject to the following
 * restrictions:
 * 
 * 1.  Any partial or whole copy of this software, or any modification
 * thereof, must include this copyright notice in its entirety.
 *
 * 2.  This software is supplied "as is" with no warranty of any kind,
 * expressed or implied, for any purpose, including any warranty of fitness 
 * or merchantibility.  DIGITAL assumes no responsibility for the use or
 * reliability of this software, nor promises to provide any form of 
 * support for it on any basis.
 *
 * 3.  Distribution of this software is authorized only if no profit or
 * remuneration of any kind is received in exchange for such distribution. 
 * 
 * 4.  This software and all application programs are to be used only for
 * non-commercial purposes. However, media costs associated with the
 * distribution of the software or application programs may be recovered.
 *
 */



/*
 * Externally Callable Routines. All arguments are character pointers
 * or integer lengths.
 */

#ifndef SPHINX_HASHES
#define SPHINX_HASHES

void RSA_MD2();         /* RSA_MD2(input_buffer, length, hash_result) */
void RSA_MD4();         /* RSA_MD4(input_buffer, length, hash_result) */
void RSA_MAC();         /* RSA_MAC(input_buffer, length, mac, output_length) */
void RSA_MD();          /* RSA_MD(input_buffer, length, hash_result) */

int H1();               /* H1(username, password, hash_result) */
int H2();               /* H2(username, password, hash_result) */

/*
 * Common data structures
 */
#define MAC_BLOCK_SIZE	8
#define MD_BLOCK_SIZE	16


#endif

