// Simple vectors of integers.

#ifndef _CL_SV_INTEGER_H
#define _CL_SV_INTEGER_H

#include "cl_number.h"
#include "cl_SV_rational.h"
#include "cl_io.h"

// A vector of integers is just a normal vector of rational numbers.

typedef cl_heap_SV<cl_I> cl_heap_SV_I;

struct cl_SV_I : public cl_SV<cl_I,cl_SV_RA> {
public:
	// Constructors.
	cl_SV_I () : cl_SV<cl_I,cl_SV_RA> ((cl_heap_SV_I*) (cl_heap_SV_N*) cl_null_SV_N) {};
	cl_SV_I (const cl_SV_I&);
	cl_SV_I (uintL len) : cl_SV<cl_I,cl_SV_RA> ((cl_heap_SV_I*) cl_make_heap_SV_N(len)) {};
	// Assignment operators.
	cl_SV_I& operator= (const cl_SV_I&);
};
inline cl_SV_I::cl_SV_I (const cl_SV_I& x) : cl_SV<cl_I,cl_SV_RA> (as_cl_private_thing(x)) {}
CL_DEFINE_ASSIGNMENT_OPERATOR(cl_SV_I,cl_SV_I)

// Copy a simple vector.
inline cl_SV_I copy (const cl_SV_I& vector)
{
	return The(cl_SV_I) (copy((const cl_SV_RA&) vector));
}

// Output.
inline void fprint (cl_ostream stream, const cl_SV_I& x)
{
	extern cl_print_flags cl_default_print_flags;
	extern void print_vector (cl_ostream stream, const cl_print_flags& flags, void (* fun) (cl_ostream, const cl_print_flags&, const cl_number&), const cl_SV_N& vector);
	extern void print_rational (cl_ostream stream, const cl_print_flags& flags, const cl_RA& z);
	print_vector(stream, cl_default_print_flags,
	             (void (*) (cl_ostream, const cl_print_flags&, const cl_number&))
	             (void (*) (cl_ostream, const cl_print_flags&, const cl_RA&))
	             &print_rational,
	             x);
}
CL_DEFINE_PRINT_OPERATOR(cl_SV_I)

#endif /* _CL_SV_INTEGER_H */
