/**********************************************************************/
/* display.h                                                          */
/*                                                                    */
/* Copyright (C) 1992, Bernard Kwok                                   */
/* All rights reserved.                                               */
/* Revision 1.0                                                       */
/* May, 1992                                                          */
/**********************************************************************/
#ifndef DISPLAY_H
#define DISPLAY_H

#define RGB_SCALE 255.0       /* For scaling to RGB colour */
#define RGB_ROUND 0.5

#define INITIAL_DISPLAY 0     /* Flag to mark initial PR display */

#ifndef VTX_TOLERANCE
#define VTX_TOLERANCE (0.0001)
#endif

/**********************************************************************/
/* Prototypes */
/**********************************************************************/
ColourChar SpectraToRGB();
int Poly_SameProperties();
int Poly_SamePlane();
void Interpolate_FromPatches();
void Interpolate_FromVertices2();
void Interpolate_FromVertices();

extern void DisplayResults();
extern void Draw_Element();
extern void Draw_ElementRGB();
extern void StoreResults();
extern void Update_ElementRGBA();

#endif /* DISPLAY_H */
