/*  GUBI - Gtk+ User Interface Builder
 *  Copyright (C) 1997	Tim Janik	<timj@psynet.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* dmallog.h: memory allocation logger
 * RCS_ID("$Id: dmallog.h,v 1.1 1997/08/18 03:31:36 timj Exp $")
*/


#ifndef		__dmallog_h__
#define		__dmallog_h__

#ifdef		__cplusplus
  extern	"C"	{
#endif



/* --- macros --- */
#ifdef	D_MALLOG

#define	g_malloc(size)			(LOG_POS(),dmg_malloc((size)))
#define	g_malloc0(size)			(LOG_POS(),dmg_calloc(1,(size)))
#define	g_realloc(mem,type,size)	(LOG_POS(),dmg_realloc((mem), (size)))
#define	g_free(mem)			(LOG_POS(),dmg_free((mem)))
#define	g_strdup(str)			(LOG_POS(),dmg_strdup((str)))
#define	LOG_POS()			(dmg_log_pos(__FILE__,__LINE__,__PRETTY_FUNCTION__))

#endif	/*D_MALLOG*/



/* --- prototypes --- */


/* the dmg_init() function initializes the memory allocation
 * logger, if this has not been done before. so this function
 * should be called at the _very_ beginning of a program.
 * the name of the file to log the allocations in can be
 * specified by log_file.
*/
void	dmg_init	(const char		*log_file);

void	*dmg_calloc	(unsigned long int	n_mem_blocks,
			 unsigned long int	block_size);

void	*dmg_malloc	(unsigned long int	size);

void	*dmg_realloc	(void			*ptr,
			 unsigned long int	size);

void	dmg_free	(void			*ptr);

char*	dmg_strdup	(const char		*str);

void	dmg_log_blocks	(void);


/* the dmg_log_pos() function should be used in conjunction
 * with the LOG_POS() macro to log the source code
 * postitions of the various calls.
*/
void	dmg_log_pos	(const char		*file,
			 const int		line,
			 const char		*function);






#ifdef		__cplusplus
  }
#endif
#endif		/*__dmallog_h__*/
