/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef __GTK_VTREE_FORK_H__
#define __GTK_VTREE_FORK_H__


#include <gdk/gdk.h>

#include "gtktreefork.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


typedef enum
{
  GTK_VTREE_FORK_TYPE_A,
  GTK_VTREE_FORK_TYPE_B,
} GtkVTreeForkType;


#define GTK_VTREE_FORK(obj)          GTK_CHECK_CAST (obj, gtk_vtree_fork_get_type (), GtkVTreeFork)
#define GTK_VTREE_FORK_CLASS(klass)  GTK_CHECK_CLASS_CAST (klass, gtk_vtree_fork_get_type (), GtkVTreeForkClass)
#define GTK_IS_VTREE_FORK(obj)       GTK_CHECK_TYPE (obj, gtk_vtree_fork_get_type ())


typedef struct _GtkVTreeFork       GtkVTreeFork;
typedef struct _GtkVTreeForkClass  GtkVTreeForkClass;

struct _GtkVTreeFork
{
  GtkTreeFork tree_fork;

  gint16 vtree_fork_type;
};

struct _GtkVTreeForkClass
{
  GtkTreeForkClass parent_class;
};


guint      gtk_vtree_fork_get_type (void);
GtkWidget* gtk_vtree_fork_new      (GtkVTreeForkType vtree_fork_type);


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __GTK_TREE_FORK_H__ */
