/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include "gtkvtree.h"


static void gtk_vtree_class_init     (GtkVTreeClass    *klass);
static void gtk_vtree_init           (GtkVTree         *vtree);
static void gtk_vtree_size_request   (GtkWidget        *widget,
				      GtkRequisition   *requisition);
static void gtk_vtree_size_allocate  (GtkWidget        *widget,
				      GtkAllocation    *allocation);
static void gtk_vtree__xxx_expand   (GtkTree *tree); /* XXX rename me! */
static void gtk_vtree__xxx_collapse (GtkTree *tree); /* XXX rename me! */


guint
gtk_vtree_get_type ()
{
  static guint vtree_type = 0;

  if (!vtree_type)
    {
      GtkTypeInfo vtree_info =
      {
	"GtkVTree",
	sizeof (GtkVTree),
	sizeof (GtkVTreeClass),
	(GtkClassInitFunc) gtk_vtree_class_init,
	(GtkObjectInitFunc) gtk_vtree_init,
	(GtkArgFunc) NULL,
      };

      vtree_type = gtk_type_unique (gtk_tree_get_type (),
				    &vtree_info);
    }

  return vtree_type;
}

static void
gtk_vtree_class_init (GtkVTreeClass *klass)
{
  GtkWidgetClass *widget_class;
  GtkTreeClass *tree_class;

  widget_class = (GtkWidgetClass*) klass;
  tree_class = (GtkTreeClass*) klass;

  widget_class->size_request = gtk_vtree_size_request;
  widget_class->size_allocate = gtk_vtree_size_allocate;

  tree_class->_xxx_expand = gtk_vtree__xxx_expand;
  tree_class->_xxx_collapse = gtk_vtree__xxx_collapse;
}

static void
gtk_vtree_init (GtkVTree *vtree)
{
}

GtkWidget*
gtk_vtree_new ()
{
  return GTK_WIDGET (gtk_type_new (gtk_vtree_get_type ()));
}

static void
gtk_vtree_size_request (GtkWidget      *widget,
			GtkRequisition *requisition)
{
  GtkTree *tree;
  GtkTreeChild *child;
  GList *children;
  gint nvis_children;

  g_return_if_fail (widget != NULL);
  g_return_if_fail (GTK_IS_VTREE (widget));
  g_return_if_fail (requisition != NULL);

  tree = GTK_TREE (widget);

  nvis_children = 0;
  requisition->width = 0;
  requisition->height = 0;

  children = tree->children;
  while (children)
    {
      child = children->data;
      children = children->next;

      if (GTK_WIDGET_VISIBLE (child->widget))
	{
	    gtk_widget_size_request (child->widget,
				     &child->widget->requisition);

	    requisition->width = MAX (requisition->width,
				      child->widget->requisition.width);
	    requisition->height += child->widget->requisition.height;

	    ++nvis_children;
	}
    }
  requisition->height += tree->spacing * (nvis_children - 1);

  requisition->width += GTK_CONTAINER (tree)->border_width * 2;
  requisition->height +=  GTK_CONTAINER (tree)->border_width * 2;
}

static void
gtk_vtree_size_allocate (GtkWidget     *widget,
			 GtkAllocation *allocation)
{
  GtkTree *tree;
  GtkTreeChild *child;
  GList *children;
  GtkAllocation child_allocation;
  gint x;
  gint y;

  g_return_if_fail (widget != NULL);
  g_return_if_fail (GTK_IS_VTREE (widget));
  g_return_if_fail (allocation != NULL);

  tree = GTK_TREE (widget);
  widget->allocation = *allocation;
  x = allocation->x + GTK_CONTAINER (tree)->border_width;
  y = allocation->y + GTK_CONTAINER (tree)->border_width;

  children = tree->children;
  while (children)
    {
      child = children->data;
      children = children->next;

      if (GTK_WIDGET_VISIBLE (child->widget))
	{
	  child_allocation.x = x;
	  child_allocation.y = y;
	  child_allocation.width = child->widget->requisition.width;
	  child_allocation.height = child->widget->requisition.height;

	  gtk_widget_size_allocate (child->widget, &child_allocation);

	  x += 0;
	  y += child_allocation.height;

	  y += tree->spacing;
	}
    }
}


static void
gtk_vtree__xxx_expand (GtkTree *tree) /* XXX rename me ! */
{
  GtkWidget *top_tree;
    
  g_return_if_fail (tree != NULL);
  g_return_if_fail (GTK_IS_VTREE (tree));

  if (!GTK_WIDGET_VISIBLE (GTK_WIDGET (tree)))
    {
      gtk_widget_show (GTK_WIDGET (tree));

      top_tree = gtk_tree_get_top (tree);
      gtk_widget_queue_resize (top_tree);
    }
}

static void
gtk_vtree__xxx_collapse (GtkTree *tree) /* XXX rename me ! */
{
  GtkWidget *top_tree;
    
  g_return_if_fail (tree != NULL);
  g_return_if_fail (GTK_IS_VTREE (tree));

  if (GTK_WIDGET_VISIBLE (GTK_WIDGET (tree)))
    {
      gtk_widget_hide (GTK_WIDGET (tree));

      top_tree = gtk_tree_get_top (tree);
      gtk_widget_queue_resize (top_tree);
    }
}
