/*
 * GtkMyToolbar by Kemal 'Disq' Hadimli
 * Modified from GtkToolbar by Federico Mena
 *
 * Coded for GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 * GtkToolbar copyright (C) Federico Mena
 *
 *
 * This is the second edition, released to the public just for comments
 * If this code is OK, I'll submit it as a patch for GtkToolbar
 *
 *
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __GTK_MYTOOLBAR_H__
#define __GTK_MYTOOLBAR_H__


#include <gdk/gdk.h>
#include <gtk/gtkcontainer.h>
#include <gtk/gtkenums.h>
#include <gtk/gtkpixmap.h>
#include <gtk/gtksignal.h>
#include <gtk/gtktooltips.h>
#include "gtkmytoolbar_enums.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define GTK_MYTOOLBAR(obj)	 GTK_CHECK_CAST (obj, gtk_mytoolbar_get_type (), GtkMyToolbar)
#define GTK_MYTOOLBAR_CLASS(klass) GTK_CHECK_CLASS_CAST (klass, gtk_mytoolbar_get_type (), GtkMyToolbarClass)
#define GTK_IS_MYTOOLBAR(obj)      GTK_CHECK_TYPE (obj, gtk_mytoolbar_get_type ())

typedef enum
{
  GTK_MYTOOLBAR_CHILD_SPACE,
  GTK_MYTOOLBAR_CHILD_BUTTON,
  GTK_MYTOOLBAR_CHILD_TOGGLEBUTTON,
  GTK_MYTOOLBAR_CHILD_RADIOBUTTON,
  GTK_MYTOOLBAR_CHILD_WIDGET
} GtkMyToolbarChildType;

typedef enum
{
  GTK_MYTOOLBAR_SPACE_EMPTY,
  GTK_MYTOOLBAR_SPACE_LINE
} GtkMyToolbarSpaceStyle;

typedef struct _GtkMyToolbarChild      GtkMyToolbarChild;
typedef struct _GtkMyToolbar           GtkMyToolbar;
typedef struct _GtkMyToolbarClass      GtkMyToolbarClass;

struct _GtkMyToolbarChild
{
  GtkMyToolbarChildType type;
  GtkWidget *widget;
  GtkWidget *icon;
  GtkWidget *icon_2;
  GtkWidget *label;
  gpointer *parent;
  gboolean hasfocus;
};

struct _GtkMyToolbar
{
  GtkContainer container;

  gint             num_children;
  GList           *children;
  GtkOrientation   orientation;
  GtkMyToolbarStyle  style;
  gint             space_size; /* big optional space between buttons */
  GtkMyToolbarSpaceStyle space_style;

  GtkTooltips     *tooltips;

  gint             button_maxw;
  gint             button_maxh;
  GtkReliefStyle   relief;
};

struct _GtkMyToolbarClass
{
  GtkContainerClass parent_class;

  void (* orientation_changed) (GtkMyToolbar      *mytoolbar,
				GtkOrientation   orientation);
  void (* style_changed)       (GtkMyToolbar      *mytoolbar,
				GtkMyToolbarStyle  style);
};


guint      gtk_mytoolbar_get_type        (void);
GtkWidget *gtk_mytoolbar_new             (GtkOrientation   orientation,
					GtkMyToolbarStyle  style);

/* Simple button items */
GtkWidget *gtk_mytoolbar_append_item     (GtkMyToolbar      *mytoolbar,
					const char      *text,
					const char      *tooltip_text,
					const char      *tooltip_private_text,
					GtkWidget       *icon,
					GtkSignalFunc    callback,
					gpointer         user_data);
GtkWidget *gtk_mytoolbar_prepend_item    (GtkMyToolbar      *mytoolbar,
					const char      *text,
					const char      *tooltip_text,
					const char      *tooltip_private_text,
					GtkWidget       *icon,
					GtkSignalFunc    callback,
					gpointer         user_data);
GtkWidget *gtk_mytoolbar_insert_item     (GtkMyToolbar      *mytoolbar,
					const char      *text,
					const char      *tooltip_text,
					const char      *tooltip_private_text,
					GtkWidget       *icon,
					GtkSignalFunc    callback,
					gpointer         user_data,
					gint             position);

/* Simple button items with two icons */
GtkWidget *gtk_mytoolbar_append_item_2     (GtkMyToolbar      *mytoolbar,
					const char      *text,
					const char      *tooltip_text,
					const char      *tooltip_private_text,
					GtkWidget       *icon,
					GtkWidget       *icon_2,
					GtkSignalFunc    callback,
					gpointer         user_data);
GtkWidget *gtk_mytoolbar_prepend_item_2    (GtkMyToolbar      *mytoolbar,
					const char      *text,
					const char      *tooltip_text,
					const char      *tooltip_private_text,
					GtkWidget       *icon,
					GtkWidget       *icon_2,
					GtkSignalFunc    callback,
					gpointer         user_data);
GtkWidget *gtk_mytoolbar_insert_item_2     (GtkMyToolbar      *mytoolbar,
					const char      *text,
					const char      *tooltip_text,
					const char      *tooltip_private_text,
					GtkWidget       *icon,
					GtkWidget       *icon_2,
					GtkSignalFunc    callback,
					gpointer         user_data,
					gint             position);

/* Space Items */
void       gtk_mytoolbar_append_space    (GtkMyToolbar      *mytoolbar);
void       gtk_mytoolbar_prepend_space   (GtkMyToolbar      *mytoolbar);
void       gtk_mytoolbar_insert_space    (GtkMyToolbar      *mytoolbar,
					gint             position);

/* Any element type */
GtkWidget *gtk_mytoolbar_append_element  (GtkMyToolbar      *mytoolbar,
					GtkMyToolbarChildType type,
					GtkWidget       *widget,
					const char      *text,
					const char      *tooltip_text,
					const char      *tooltip_private_text,
					GtkWidget       *icon,
					GtkSignalFunc    callback,
					gpointer         user_data);

GtkWidget *gtk_mytoolbar_prepend_element (GtkMyToolbar      *mytoolbar,
					GtkMyToolbarChildType type,
					GtkWidget       *widget,
					const char      *text,
					const char      *tooltip_text,
					const char      *tooltip_private_text,
					GtkWidget       *icon,
					GtkSignalFunc    callback,
					gpointer         user_data);

GtkWidget *gtk_mytoolbar_insert_element  (GtkMyToolbar      *mytoolbar,
					GtkMyToolbarChildType type,
					GtkWidget       *widget,
					const char      *text,
					const char      *tooltip_text,
					const char      *tooltip_private_text,
					GtkWidget       *icon,
					GtkSignalFunc    callback,
					gpointer         user_data,
					gint             position);


/* Any element type with two icons */
GtkWidget *gtk_mytoolbar_append_element_2  (GtkMyToolbar      *mytoolbar,
					GtkMyToolbarChildType type,
					GtkWidget       *widget,
					const char      *text,
					const char      *tooltip_text,
					const char      *tooltip_private_text,
					GtkWidget       *icon,
					GtkWidget       *icon_2,
					GtkSignalFunc    callback,
					gpointer         user_data);

GtkWidget *gtk_mytoolbar_prepend_element_2 (GtkMyToolbar      *mytoolbar,
					GtkMyToolbarChildType type,
					GtkWidget       *widget,
					const char      *text,
					const char      *tooltip_text,
					const char      *tooltip_private_text,
					GtkWidget       *icon,
					GtkWidget       *icon_2,
					GtkSignalFunc    callback,
					gpointer         user_data);

GtkWidget *gtk_mytoolbar_insert_element_2  (GtkMyToolbar      *mytoolbar,
					GtkMyToolbarChildType type,
					GtkWidget       *widget,
					const char      *text,
					const char      *tooltip_text,
					const char      *tooltip_private_text,
					GtkWidget       *icon,
					GtkWidget       *icon_2,
					GtkSignalFunc    callback,
					gpointer         user_data,
					gint             position);

/* Generic Widgets */
void       gtk_mytoolbar_append_widget   (GtkMyToolbar      *mytoolbar,
					GtkWidget       *widget,
					const char      *tooltip_text,
					const char      *tooltip_private_text);
void       gtk_mytoolbar_prepend_widget  (GtkMyToolbar      *mytoolbar,
					GtkWidget       *widget,
					const char      *tooltip_text,
					const char	*tooltip_private_text);
void       gtk_mytoolbar_insert_widget   (GtkMyToolbar      *mytoolbar,
					GtkWidget       *widget,
					const char      *tooltip_text,
					const char      *tooltip_private_text,
					gint             position);

/* Style functions */
void       gtk_mytoolbar_set_orientation       (GtkMyToolbar           *mytoolbar,
					      GtkOrientation        orientation);
void       gtk_mytoolbar_set_style             (GtkMyToolbar           *mytoolbar,
					      GtkMyToolbarStyle       style);
void       gtk_mytoolbar_set_space_size        (GtkMyToolbar           *mytoolbar,
					      gint                  space_size);
void       gtk_mytoolbar_set_space_style       (GtkMyToolbar           *mytoolbar,
					      GtkMyToolbarSpaceStyle  space_style);
void       gtk_mytoolbar_set_tooltips          (GtkMyToolbar           *mytoolbar,
					      gint                  enable);
void       gtk_mytoolbar_set_button_relief     (GtkMyToolbar           *mytoolbar,
					      GtkReliefStyle        relief);
GtkReliefStyle gtk_mytoolbar_get_button_relief (GtkMyToolbar           *mytoolbar);


#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __GTK_MYTOOLBAR_H__ */
