
/**
 ** Generated data (by mkcproc.pl)
 **/
#line 1 "bseprocedure.proc"

#include <bse/bseplugin.h>
#include <bse/bseprocedure.h>
#include <bse/bsescripthelper.h>
#include <bse/bseserver.h>
#line 22 "bseprocedure.proc"
#include <bse/gslcommon.h>      
#line 23 "bseprocedure.proc"
#include <bse/gslmath.h>        
#line 24 "bseprocedure.proc"
#include <string.h>     
#line 25 "bseprocedure.proc"
#include <stdlib.h>     


#line 30 "bseprocedure.proc"

/* --- bse-note-to-freq --- */
static void
bse_note_to_freq_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 31 "bseprocedure.proc"
 {
#line 33 "bseprocedure.proc"
  *(in_pspecs++)    = bse_pspec_note_simple ("note", "Note", NULL, SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = bse_param_spec_fine_tune ("fine_tune", "Fine Tune", NULL);
  *(out_pspecs++)   = sfi_pspec_real ("frequency", "Frequency", NULL,
			  BSE_KAMMER_FREQUENCY_f, 0, BSE_MAX_FREQUENCY_f, 0.1,
			  SFI_PARAM_DEFAULT);
#line 32 "bseprocedure.proc"
  proc->help = "Retrieve the frequency of a certain note.";
#line 28 "bseprocedure.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 29 "bseprocedure.proc"
  proc->license = "GNU General Public License";
#line 38 "bseprocedure.proc"
}  }
static BseErrorType
#line 38 "bseprocedure.proc"
bse_note_to_freq_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 41 "bseprocedure.proc"
{
#line 42 "bseprocedure.proc"
  
  gint       note       = sfi_value_get_int (in_values++);
  gint       fine_tune  = sfi_value_get_int (in_values++);
  BseNoteDescription *info;
  gfloat freq;
  
#line 48 "bseprocedure.proc"
  
  info = bse_note_description (note, fine_tune);
  if (!info->name)
    freq = 0;
  else
    freq = info->freq;
  bse_note_description_free (info);
  
#line 56 "bseprocedure.proc"
  
  sfi_value_set_real (out_values++, freq);
  
  return BSE_ERROR_NONE;
}

/* --- bse-note-from-freq --- */
static void
bse_note_from_freq_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 62 "bseprocedure.proc"
 {
#line 64 "bseprocedure.proc"
  *(in_pspecs++)    = sfi_pspec_real ("frequency", "Frequency", NULL,
			  BSE_KAMMER_FREQUENCY_f, 0, BSE_MAX_FREQUENCY_f, 0.1,
			  SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = sfi_pspec_note ("note", "Note", NULL, SFI_KAMMER_NOTE, SFI_MIN_NOTE, SFI_MAX_NOTE, TRUE, SFI_PARAM_DEFAULT);
#line 63 "bseprocedure.proc"
  proc->help = "Retrieve the note of a certain frequency.";
#line 28 "bseprocedure.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 29 "bseprocedure.proc"
  proc->license = "GNU General Public License";
#line 68 "bseprocedure.proc"
}  }
static BseErrorType
#line 68 "bseprocedure.proc"
bse_note_from_freq_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 71 "bseprocedure.proc"
{
#line 72 "bseprocedure.proc"
  
  gfloat frequency = sfi_value_get_real (in_values++);
  
#line 75 "bseprocedure.proc"
  
  sfi_value_set_int (out_values++, bse_note_from_freq (frequency));
  
  return BSE_ERROR_NONE;
}

/* --- bse-type-blurb --- */
static void
bse_type_blurb_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 81 "bseprocedure.proc"
 {
#line 83 "bseprocedure.proc"
  *(in_pspecs++)    = sfi_pspec_string ("type", NULL, NULL, NULL, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = sfi_pspec_string ("blurb", NULL, NULL, NULL, SFI_PARAM_DEFAULT);
#line 82 "bseprocedure.proc"
  proc->help = "Retrieve the blurb for a specific type.";
#line 28 "bseprocedure.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 29 "bseprocedure.proc"
  proc->license = "GNU General Public License";
#line 85 "bseprocedure.proc"
}  }
static BseErrorType
#line 85 "bseprocedure.proc"
bse_type_blurb_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 88 "bseprocedure.proc"
{
#line 89 "bseprocedure.proc"
  
  gchar *stype = sfi_value_get_string (in_values++);
  GType type;

#line 93 "bseprocedure.proc"
  
  if (!stype)
    return BSE_ERROR_PROC_PARAM_INVAL;

  type = g_type_from_name (stype);

#line 99 "bseprocedure.proc"
  
  sfi_value_set_string (out_values++, type ? bse_type_blurb (type) : NULL);

  return BSE_ERROR_NONE;
}

static gdouble
str2num (const gchar *str,
         guint        nth)
{
  gchar *num_any = ".0123456789", *num_first = num_any + 1;
  while (nth--)
    {
#line 112 "bseprocedure.proc"
      
      if (*str && strchr (num_first, *str))
        do
          str++;
        while (*str && strchr (num_any, *str));
#line 117 "bseprocedure.proc"
      
      while (*str && !strchr (num_first, *str))
        str++;
      if (!*str)
#line 121 "bseprocedure.proc"
        return 0;       
    }
  if (strchr (num_first, *str))
    return g_strtod (str, NULL);
#line 125 "bseprocedure.proc"
  return 0; 
}

/* --- bse-string-extract-number --- */
static void
bse_string_extract_number_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 128 "bseprocedure.proc"
 {
#line 130 "bseprocedure.proc"
  *(in_pspecs++)    = sfi_pspec_string ("string", NULL, NULL, NULL, SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = sfi_pspec_string ("format", NULL, NULL, NULL, SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = sfi_pspec_real ("aux_base", NULL, NULL, 0, -SFI_MAXNUM, SFI_MAXNUM, 0, SFI_PARAM_DEFAULT);
  *(in_pspecs++)    = sfi_pspec_real ("dflt", NULL, NULL, 0, -SFI_MAXNUM, SFI_MAXNUM, 0, SFI_PARAM_DEFAULT);
  *(out_pspecs++)   = sfi_pspec_real ("number", NULL, NULL, 0, -SFI_MAXNUM, SFI_MAXNUM, 0, SFI_PARAM_DEFAULT);
#line 129 "bseprocedure.proc"
  proc->help = "Retrieve numbers from a string.";
#line 28 "bseprocedure.proc"
  proc->authors = "Tim Janik <timj@gtk.org>";
#line 29 "bseprocedure.proc"
  proc->license = "GNU General Public License";
#line 135 "bseprocedure.proc"
}  }
static BseErrorType
#line 135 "bseprocedure.proc"
bse_string_extract_number_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 138 "bseprocedure.proc"
{
#line 139 "bseprocedure.proc"
  
  gchar *string   = sfi_value_get_string (in_values++);
  gchar *format   = sfi_value_get_string (in_values++);
  SfiReal aux_base = sfi_value_get_real (in_values++);
  SfiReal dflt     = sfi_value_get_real (in_values++);
  SfiReal number = dflt;

  if (string)
    {
      if (format)
        {
          gchar *base, *ep = NULL;
          switch (*format)
            {
              glong l;
            case '#':
              number = str2num (++format, 0);
              break;
            case 'n':
              l = strtol (++format, &ep, 10);
              number = str2num (string, l);
              break;
            case 'b':
              l = strtol (++format, &ep, 10);
              base = g_path_get_basename (string);
              number = str2num  (base ? base : string, l);
              g_free (base);
              break;
            case 'c':
              format++;
              number = aux_base;
              if (*format == '*')
                {
                  gdouble factor = g_strtod (++format, &ep);
                  number *= factor;
                }
              else
                ep = (char*) format;
              break;
            default:
#line 179 "bseprocedure.proc"
              
              number = 0;
              break;
            }
          if (ep && *ep)
            {
#line 185 "bseprocedure.proc"
              if (*ep == 'm')       
                number = gsl_temp_freq (gsl_get_config ()->kammer_freq,
                                        number - gsl_get_config ()->midi_kammer_note);
#line 188 "bseprocedure.proc"
              else 
                number = 0;
            }
        }
      else
        number = str2num (string, 0);
    }
  sfi_value_set_real (out_values++, number);
  return BSE_ERROR_NONE;
}

/* --- Export to BSE --- */
static BseExportNodeProc __enode_bse_note_to_freq = {
  { NULL, BSE_EXPORT_NODE_PROC,
    "bse-note-to-freq", "/Proc/Note to Freq", NULL },
  0, bse_note_to_freq_setup, bse_note_to_freq_exec, 
};
static BseExportNodeProc __enode_bse_note_from_freq = {
  { (BseExportNode*) &__enode_bse_note_to_freq, BSE_EXPORT_NODE_PROC,
    "bse-note-from-freq", "/Proc/Note from Freq", NULL },
  0, bse_note_from_freq_setup, bse_note_from_freq_exec, 
};
static BseExportNodeProc __enode_bse_type_blurb = {
  { (BseExportNode*) &__enode_bse_note_from_freq, BSE_EXPORT_NODE_PROC,
    "bse-type-blurb", "/Proc/Type Blurb", NULL },
  0, bse_type_blurb_setup, bse_type_blurb_exec, 
};
static BseExportNodeProc __enode_bse_string_extract_number = {
  { (BseExportNode*) &__enode_bse_type_blurb, BSE_EXPORT_NODE_PROC,
    "bse-string-extract-number", "/Proc/String Extract Number", NULL },
  0, bse_string_extract_number_setup, bse_string_extract_number_exec, 
};
BseExportNode* bse__builtin_init_bseprocedure_gen_proc_c (void);
BseExportNode* bse__builtin_init_bseprocedure_gen_proc_c (void)
{
  return (BseExportNode*) &__enode_bse_string_extract_number;
}

/**
 ** Generated data ends here
 **/
