/*************************************************************
*  This file is part of the Surface Evolver source code.     *
*  Programmer:  Ken Brakke, brakke@geom.umn.edu              *
*************************************************************/


/**********************************************************
*
*  File: MVgraph.c
*
*  Contents:  Routines for interface with shared memory
*             MinneView.
*/

#include "include.h"

#ifndef OOGL
void Begin_OOGL()
{
  error("OOGL not available.\n",WARNING);
}

void UpdateOOGL()
{
}

void End_OOGL()
{
}

#else 


/* Rest adapted from */
/* oogl.c */
/* miniview code */
/* Charlie Gunn & Ken Musgrave */
/* 12/89 */


#include "oogl/geom.h"
#include "oogl/quad.h"

static Geom     *objj[2];
static char *mysym = "quadlist";    /* name of shared memory sector */
static char smfile[] = "/tmp/MVmem";
static GeomSMRegion *sm;
static Quad     *quad[2];

static int      which = 0;
static int      MV_pid;  /* for MinneView child */
static QuadP  *quadptr;
static Point3  nullquad;
static QuadC  *colorptr;
static ColorA  nullcolor;
static quadcount;  /* how many quads actually done */
static maxquad;    /* how many quads MinneView expects */

void Begin_OOGL()
{
  if ( OOGL_flag ) 
    error("Cannot have multiple Minneview displays.\n",RECOVERABLE);

  if ( sm == NULL )
    {
      if ((sm = GeomOpenSM(smfile, SM_CREATE)) == NULL)
      {
        exit(fprintf(stderr,"Can't open %s\n",smfile));
      }
      GeomUseMem(sm);
    }

  OOGL_flag = 1;    /* tell everybody we're initialized */
  UpdateOOGL();     /* make initial display             */
  
  /* spawn MinneView */
  MV_pid = fork();
  if ( MV_pid == 0 ) 
    { /* child */
      signal(SIGINT,SIG_IGN);
      execlp("MinneView","MinneView","-M","quadlist",NULL);
      perror("MinneView"); /* only error gets here */
    }
}
 

void End_OOGL()
{
  OOGL_flag = 0;
  kill(MV_pid,SIGTERM);
}

void OOGL_start()
{
  if ( web.torus_clip_flag )
   maxquad = 4*web.skel[FACET].count;
  else if ( web.torus_flag )
   maxquad = 2*web.skel[FACET].count;
  else
   maxquad = web.skel[FACET].count;
  quad[which] = GeomNew(Quad);
  quad[which]->quadflag = VERT_P|VERT_C;
  quad[which]->maxquad = maxquad;
  quad[which]->p  = GeomNewN(QuadP,maxquad);
  quad[which]->n = NULL;
  quad[which]->c = GeomNewN(QuadC,maxquad);
  if ((quad[which]->p == NULL) || (quad[which]->c == NULL) )
     error("No space for PolyQuad\n",RECOVERABLE);
  
  quadcount = 0;
  quadptr = quad[which]->p;
  colorptr = quad[which]->c;
}

void OOGL_facet(gdata,f_id)
struct graphdata *gdata;
facet_id f_id;
{
  int i; 
  int color = get_facet_color(f_id);

  if ( color == CLEAR ) return;

  if ( quadcount >= maxquad )
    error("Facet count exceeds maximum alloted in OOGL_facet.\n",RECOVERABLE);

  for ( i = 0 ; i < 3 ; i++ )
    { 
      (*quadptr)[i].x = gdata[i].x[1];  /* MinneView has z toward viewer */
      (*quadptr)[i].y = gdata[i].x[2];  /* and y vertical */
      (*quadptr)[i].z = gdata[i].x[0];
    }
  /* fourth vertex */
  (*quadptr)[3].x = gdata[0].x[1];
  (*quadptr)[3].y = gdata[0].x[2];
  (*quadptr)[3].z = gdata[0].x[0];
  for ( i = 0 ; i < 4 ; i++ )
    { (*colorptr)[i].r = iris_colors[color].r;
      (*colorptr)[i].g = iris_colors[color].g;
      (*colorptr)[i].b = iris_colors[color].b;
      (*colorptr)[i].a = facet_alpha;
    }
  quadptr++;
  colorptr++;
  quadcount++;
}

void OOGL_end()
{        
  int i; 

  
  /* null out remaining quads */
/*   quad[which]->maxquad = quadcount; */
 for ( ; quadcount < maxquad ; quadcount++, quadptr++,colorptr++ ) 
   for ( i = 0 ; i < 4 ; i++ )
    { 
      (*quadptr)[i] = nullquad;
      (*colorptr)[i] = nullcolor;
    }

  objj[which] = GeomCreate(quad[which], QuadMethods());  
  if ( objj[which] == NULL )
  { 
      error("Bad return from GeomCreate",RECOVERABLE);
  }
  if (GeomShare(objj[which], sm, mysym) == NULL)
  {
      error("Bad return from GeomShare\n",RECOVERABLE);
  }
        
  which = (which+1) % 2;
  if (objj[which])
  {
    GeomDelete(objj[which]);
    objj[which] == NULL;
  }

}


void UpdateOOGL()
{
  void (*old_start)();
  void (*old_end)();  
  void (*old_gfacet)(); 
 
  /* if user has asked us to quit, don't bother redisplaying */
  /* (especially since graphgen resets breakflag!) */
  if (breakflag) return;

  /* save current screen graphics pointers */
  old_start = graph_start;
  old_end   = graph_end;
  old_gfacet = graph_facet;

  /* OOGL pointers */
  graph_start = OOGL_start;
  graph_facet = OOGL_facet;
  graph_end   = OOGL_end;

  /* do output */
  innerflag = outerflag = 1;  /* graph all */
  graphgen();

  /* restore old graphics */
  graph_start = old_start;
  graph_end   = old_end;
  graph_facet = old_gfacet;
}
#endif

