/*
**  Compile with:  cc -O -Bstatic getty_play.c -o getty_play
**
**  Install this program as "/usr/etc/getty" after renaming
**  the real /usr/etc/getty to "/usr/etc/getty_real".
**  Then create an (empty) file called either:
**      /etc/getty_play.flag	- to get a musical screen-saver
**  or
**      /etc/getty_ss.flag	- to get a simple screen-saver
**  on each machine which is to use the screen saver.
**
**  Derived from getty_ss.c by Dan Strick, 5/21/86
**  All the stuff you might want to tweak is after the ====== line.
**	psl 2/89
*/

#include <signal.h>
#include <sgtty.h>
#include <sys/file.h>

#define PFLG	"/etc/getty_play.flag"
#define SFLG	"/etc/getty_ss.flag"
#define	GETTY	"/usr/etc/getty_real"

typedef void (*sigfunc)();

int Fd, Fd1, Fd2;
sigfunc Of1, Of2;
struct sgttyb Ottyb;
struct tchars Otchr;
char **Argv;

void
dogetty (sig)
{
	(void) alarm (0); /* otherwise the real getty/login gets shot down */
	(void) ioctl (Fd, TIOCSETP, (char*)&Ottyb);
	(void) ioctl (Fd, TIOCSETC, (char*)&Otchr);
	(void) write (Fd, "\014\033[p",4);
	(void) signal (SIGINT,  Of1);
	(void) signal (SIGQUIT, Of2);
	sigsetmask (0);	/* otherwise ^C may be blocked later */
	close(Fd);
	close(Fd1);
	close(Fd2);
	execv (GETTY, Argv);
	perror ("getty_ss");	/* not likely to escape black hole */
	exit (1);		/* exit status probably not used */
}

/*==================================================================*/

char	Msg1[]	= "Type ^C to login to Binky... ";
char	Msg2[]	= "Listen to the headphones!  (Type ^C to stop this tune.) ";
char	*Play	= "cd /u/psl/midi/`arch`/bin; /bin/sh playmisc %d";
char	Buf[256], *Bp, *Mp;

main (argc, argv)
char	*argv[];
{
	int i, n;
	struct sgttyb tb;
	struct tchars tc;

	if (strcmp (argv[argc - 1],"console")	/* fail if not on the console */
	 || (access(PFLG, F_OK) && access(SFLG, F_OK))	/* fail if no flags */
 	 || (Fd = open("/dev/console",2)) < 0)	/* fail if can't open console */
	    execv (GETTY, argv);		/* execute "normal" getty */
	Argv = argv;
	Fd1 = dup (Fd);
	Fd2 = dup (Fd);				/* try to create stderr */
	(void) ioctl (Fd, TIOCGETP, (char*)&Ottyb);
	(void) ioctl (Fd, TIOCGETC, (char*)&Otchr);
	Of1 = signal (SIGINT,  dogetty);
	Of2 = signal (SIGQUIT, dogetty);
	tb = Ottyb;
	tb.sg_flags &= ~RAW;
	if (ioctl (Fd, TIOCSETP, (char*)&tb)  <  0)
	    dogetty(perror ("getty_play (SETP)"));
	tc = Otchr;
	tc.t_intrc = 003;
	tc.t_quitc = 034;
	if (ioctl (Fd, TIOCSETC, (char*)&tc)  <  0)
	    dogetty(perror ("getty_play (SETC)"));
	if ((int)Of1 == -1  ||  (int)Of2 == -1)
	    dogetty(perror ("getty_play (signal)"));
	sleep (5);
	for (n = 0; ; n = (n & 0xFFF) + 1) {
	    rmsg(Fd, "\033[p\014", Msg1, sizeof Msg1);
	    sleep(5);
	    if (access(PFLG, F_OK)) {		/* check musical ss flag */
		rmsg(Fd, "\033[q\014", Msg1, sizeof Msg1);
		sleep(20);
	    } else {
		rmsg(Fd, "\033[q\014", Msg2, sizeof Msg2);
		sprintf(Buf, Play, n);
		system(Buf);
	    }
	}
}

rmsg(fd, pp, mp, len)
char	*pp, *mp;
{
	int i;

	for (Bp = Buf; *Bp = *pp++; Bp++);
	for (i = rand() % 29 + 3; --i >= 0; *Bp++ = '\n');
	for (i = rand() % (66 - len) + 8; --i >= 0; *Bp++ = ' ');
	for (; *Bp = *mp++; Bp++);
	(void) write (fd, Buf, Bp - Buf);
}
