/*
**	RIFFS -- C major Riffs for Ballblazer riff generator
*/
#include	<notedefs.h>

char	Minriffs[]	= {
	A4,  B4,  C5,  A4,  B4,  C5,  D5,  B4,	/* 0 */
	C4,  D4,  Eb4, C4,  D4,  Eb4, F4,  D4,
	E4,  Ab4, A4,  E4,  Ab4, A4,  B4,  Ab4,
	A4,  B4,  C5,  D5,  Eb5, E5,  Eb5, C5,	/* 1 */
	C5,  D5,  E5,  F5,  G5,  A5,  G5,  Eb5,
	Gb4, Ab4, A4,  B4,  C5,  D5,  C5,  A5,
	A4,  Bb4, B4,  C5,  Db5, D5,  Eb5, E5,	/* 2 */
	C5,  Db5, D5,  Eb5, E5,  F5,  Gb5, G5,
	E5,  F5,  Gb5, G5,  Ab5, A5,  Bb5, B5,
	A4,  Bb4, B4,  C5,  E5,  Eb5, D5,  C5,	/* 3 */
	C5,  Db5, D5,  Eb5, G5,  Gb5, F5,  Eb5,
	E5,  F5,  Gb5, G5,  B5,  Bb5, A5,  G5,
	A4,  C5,  D5,  Eb5, Gb5, Ab5, A5,  C6,	/* 4 Pat Metheny */
	C4,  E4,  Gb4, G4,  A4,  B4,  C5,  E5,
	B4,  A4,  B4,  C5,  C5,  D5,  Eb5, A5,
	A4,  C5,  E5,  A5,  G5,  Eb5, C5,  A4,	/* 5 */
	C5,  E5,  G5,  C6,  B5,  G5,  Eb5, C5,
	A4,  Ab4, G4,  Gb4, D5,  C5,  A4,  Gb4,
	A4,  C5,  E5,  G5,  B5,  A5,  G5,  E5,	/* 6 */
	C5,  E5,  G5,  B5,  D6,  C6,  B5,  G5,
	E4,  A4,  C5,  E5,  G5,  F5,  E5,  C5,
	A4,  C5,  Eb5, B4,  D5,  F5,  Eb5, C5,	/* 7 */
	C5,  Eb5, G5,  D5,  F5,  A5,  G5,  Eb5,
	E4,  A4,  C5,  Ab4, B4,  D5,  C5,  A4,
	A5,  B5,  G5,  E5,  F5,  Gb5, G5,  Ab5,	/* 8 */
	C5,  D5,  B4,  G4,  Ab4, A4,  Bb4, B4,
	E5,  G5,  D5,  B4,  C5,  Db5, D5,  Eb5,
	A5,  E5,  C5,  A4,  G5,  Eb5, C5,  A4,	/* 9 */
	A5,  A5,  E5,  C5,  G5,  G5,  Eb5, C5,
	A5,  C6,  A5,  E5,  G5,  B5,  G5,  Eb5,
	Ab4, A4,  0,   G5,  0,   Eb5, C5,  E5,	/* 10 */
	B4,  C5,  0,   C6,  0,   G5,  Eb5, A5,
	D4,  E4,  0,   Eb5, 0,   C5,  A4,  C5,
	Ab4, A4,  B4,  C5,  Eb5, E5,  Ab5, A5,	/* 11 */
	B4,  C5,  Eb5, E5,  Ab5, A5,  B5,  C6,
	Eb5, E5,  Ab5, A5,  B5,  C6,  Eb6, E6,
	B4,  A4,  B4,  C5,  B4,  A4,  B4,  C5,	/* 12 first */
	D5,  C5,  D5,  Eb5, D5,  C5,  D5,  Eb5,
	Gb5, E5,  Gb5, G5,  Gb5, E5,  Gb5, G5,
	B4,  A4,  B4,  C5,  B4,  C5,  B4,  A4,	/* 13 */
	D5,  C5,  D5,  Eb5, D5,  Eb5, D5,  C5,
	Gb5, E5,  Gb5, G5,  Gb5, G5,  Gb5, E5,
	B4,  A4,  B4,  C5,  D5,  C5,  D5,  Eb5,	/* 14 */
	D5,  C5,  D5,  Eb5, Gb5, E5,  Gb5, G5,
	Gb5, E5,  Gb5, G5,  A5,  G5,  A5,  B5,
	B5,  C6,  A5,  E5,  G5,  B5,  A5,  0,	/* 15 */
	D5,  E5,  C5,  G4,  B4,  D5,  C5,  0,
	G5,  A5,  E5,  C5,  D5,  Gb5, E5,  0,
	C5,  Ab4, A4,  G5,  F5,  Gb5, Eb5, E5,	/* 16 Marty Cutler */
	Eb5, B4,  C5,  B5,  A5,  0,   G5,  0,
	G5,  D5,  Eb5, E5,  D5,  0,   C5,  0,
	C5,  D5,  C5,  B4,  C5,  B4,  A4,  0,	/* 17 */
	E5,  F5,  E5,  D5,  E5,  D5,  C5,  0,
	A4,  0,   Ab4, G4,  Gb4, F4,  E4,  0,
	C5,  D5,  Eb5, C5,  D5,  Eb5, F5,  D5,	/* 18 */
	Eb5, F5,  G5,  Eb5, F5,  G5,  A5,  Ab5,
	A4,  B4,  C5,  A4,  B4,  C5,  D5,  B4,
	C6,  B5,  A5,  G5,  Gb5, E5,  Eb5, C5,	/* 19 */
	A5,  G5,  Gb5, E5,  Eb5, C5,  B4,  A4,
	C6,  Eb6, C6,  B5,  A5,  G5,  Gb5, E5,
	D5,  C5,  A4,  C5,  E5,  Eb5, D5,  C5,	/* 20 */
	B4,  A4,  E4,  A4,  C5,  B4,  Bb4, A4,
	Gb5, E5,  C5,  E5,  G5,  Gb5, F5,  E5,
	D5,  C5,  D5,  Eb5, D5,  C5,  D5,  Eb5,	/* 21 */
	Gb5, E5,  Gb5, G5,  Gb5, E5,  Gb5, G5,
	A5,  G5,  A5,  B5,  A5,  G5,  A5,  B5,
	D5,  Eb5, G5,  Eb5, D5,  C5,  B4,  C5,	/* 22 Charlie Keagle */
	B4,  C5,  Eb5, C5,  B4,  A4,  Ab4, A4,
	Gb5, G5,  C6,  G5,  Gb5, E5,  Eb5, E5,
	D5,  E5,  G5,  E5,  C5,  0,   D5,  A5,	/* 23 Lyle Mays/Steve Cantor? */
	B4,  C5,  E5,  C5,  A4,  0,   B4,  E5,
	Gb5, G5,  B5,  G5,  E5,  0,   Gb5, C6,
	D5,  Eb5, A5,  D5,  0,   C5,  A4,  E4,	/* 24 */
	B4,  C5,  Eb5, B4,  0,   A4,  Gb4, C4,
	Ab5, A5,  C5,  Gb5, 0,   E5,  C5,  A4,
	Eb4, D4,  A4,  F4,  E4,  C5,  A4,  A4,	/* 25 */
	G4,  Gb4, C5,  A4,  0,   E5,  C5,  C5,
	C5,  B4,  E5,  C5,  0,   A5,  Eb5, E5,
	Eb5, E5,  A5,  C5,  B4,  E5,  A4,  A4,	/* 26 */
	B4,  C5,  F5,  A4,  Ab4, B4,  E4,  E4,
	Ab5, A5,  C5,  F5,  E5,  D5,  C5,  C5,
	Eb5, E5,  D5,  C5,  B4,  A4,  Ab4, A4,	/* 27 Richie Shulberg */
	B4,  C5,  B4,  A4,  Ab4, E4,  D4,  C4,
	Ab5, A5,  F5,  E5,  D5,  C5,  B4,  A4,
	Eb5, D5,  Eb5, D5,  0,   C5,  A4,  0,	/* 28 */
	C5,  B4,  C5,  B4,  0,   A4,  E4,  0,
	G5,  Gb5, G5,  Gb5, 0,   E5,  C5,  0,
	Eb5, D5,  Eb5, F5,  Eb5, D5,  C5,  B4,	/* 29 */
	G5,  F5,  G5,  A5,  G5,  F5,  Eb5, D5,
	C5,  B4,  A4,  B4,  C5,  B4,  A4,  Ab4,
	E5,  A4,  C5,  Ab4, B4,  G4,  Gb4, E4,	/* 30 David Levine */
	G5,  C5,  E5,  B4,  D5,  B4,  A4,  G4,
	C5,  E4,  A4,  E4,  Ab4, Eb4, D4,  C4,
	E5,  Eb5, D5,  C5,  B4,  C5,  D5,  F5,	/* 31 */
	G5,  Gb5, F5,  E5,  D5,  Eb5, F5,  Ab5,
	C5,  B4,  Bb4, A4,  Ab4, A4,  Ab4, B4,
	F4,  A4,  Eb5, D5,  E4,  A4,  C5,  A4,	/* 32 */
	A4,  C5,  G5,  F5,  A4,  C5,  E5,  C5,
	C4,  F4,  C5,  B4,  C4,  E4,  A4,  E4,
	G5,  E5,  D5,  B4,  Eb5, 0,   C5,  A4,	/* 33 */
	B5,  G5,  Gb5, D5,  G5,  0,   E5,  C5,
	E5,  C5,  B4,  G4,  C5,  0,   A4,  E4,
	G5,  E5,  D5,  Gb5, C5,  0,   A4,  0,	/* 34 Mike Cross */
	B5,  G5,  Gb5, A5,  E5,  0,   C5,  0,
	E5,  C5,  B4,  D5,  A4,  0,   E4,  0,
	A4,  Bb4, B4,  C5,  Db5, D5,  Eb5, E5,	/* 35 */
	C5,  Db5, D5,  Eb5, E5,  F5,  Gb5, G5,
	A4,  0,   A4,  0,   A4,  Bb4, B4,  C5,
	D5,  Eb5, E5,  F5,  Gb5, G5,  Ab5, A5,	/* 36 */
	F5,  Gb5, G5,  Ab5, A5,  Bb5, B5,  C6,
	A4,  Bb4, B4,  C5,  Db5, D5,  Eb5, E5,
	A5,  E5,  C5,  G4,  C5,  E5,  A5,  A5,	/* 37 Django */
	Ab5, Eb5, B4,  Gb4, B4,  Eb5, Ab5, C6,
	C6,  A5,  E5,  C5,  E5,  A5,  C6,  E6,
	B5,  D6,  C6,  E5,  Ab5, B5,  A5,  C5,	/* 38 Django */
	Ab5, B5,  A5,  C5,  Eb5, Gb5, E5,  A4,
	Eb5, Gb5, E5,  A4,  B4,  D5,  C5,  E4,
	Eb5, Gb5, E5,  A4,  B4,  D5,  C5,  E4,	/* 39 Django */
	B4,  D5,  C5,  E4,  Ab4, B4,  A4,  C4,
	Ab4, B4,  A4,  C4,  Eb4, Gb4, E4,  A3,
	Ab5, A5,  Ab5, A5,  Ab5, A5,  Ab5, A5,	/* 40 Django */
	Eb5, E5,  Eb5, E5,  Eb5, E5,  Eb5, E5,
	B4,  C5,  B4,  C5,  B4,  C5,  B4,  C5,
};

int	Nminriffs	= (sizeof Minriffs / 24);

char	Majriffs[]	= {		/* C major riffs */
	C4,  D4,  E4,  C4,  D4,  E4,  F4,  D4,  /*   0    */  
	E3,  F3,  G3,  E3,  F3,  G3,  A3,  F3, 
	G3,  B3,  C4,  G3,  B3,  C4,  D4,  B3, 
	C4,  D4,  E4,  F4,  Gb4, G4,  F4,  E4,  /*   1    */  
	E4,  F4,  G4,  A4,  Bb4, C5,  A4,  G4,
	A3,  B3,  C4,  D4,  Eb4, E4,  D4,  C5, 
	C4,  Db4, D4,  Eb4, E4,  F4,  Gb4, G4,  /*   2    */  
	E4,  F4,  F4,  Gb4, G4,  A4,  Bb4, B4,
	G4,  Ab4, A4,  Bb4, B4,  C5,  Db5, D5, 
	C4,  D4,  Eb4, E4,  G4,  Gb4, F4,  E4,  /*   3    */  
	E4,  F4,  Gb4, G4,  B4,  Bb4, A4,  G4,
	G4,  A4,  B4,  C5,  D5,  Db5, C5,  B4,
	C4,  E4,  F4,  G4,  A4,  B4,  C5,  E5,  /*   4    */  
	E3,  G3,  A3,  B3,  C4,  D4,  E4,  G4, 
	G3,  C4,  D4,  D4,  E4,  F4,  G4,  C5, 
	C4,  E4,  G4,  C5,  Bb4, G4,  E4,  C4,  /*   5    */  
	E4,  G4,  C5,  E5,  D5,  Bb4, G4,  E4,
	C4,  C4,  E4,  G4,  F4,  E4,  C4,  G3, 
	C4,  E4,  G4,  Bb4, D5,  C5,  Bb4, G4,  /*   6    */  
	E4,  G4,  Bb4, D5,  F5,  E5,  D5,  Bb4,
	G3,  C4,  E4,  G4,  Bb4, A4,  G4,  E4,
	C4,  E4,  G4,  D4,  F4,  A4,  G4,  E4,  /*   7    */  
	E4,  G4,  B4,  F4,  A4,  C5,  B4,  G4,
	G3,  C4,  E4,  A3,  D4,  F4,  E4,  C4, 
	C5,  D5,  Bb4, G4,  Ab4, A4,  Bb4, B4,  /*   8    */  
	E4,  F4,  D4,  C4,  C4,  C4,  E4,  D4, 
	G4,  A4,  F4,  E4,  E4,  F4,  G4,  G4,
	C5,  G4,  E4,  C4,  A4,  G4,  E4,  C4,  /*   9    */  
	C5,  C5,  G4,  E4,  C5,  B4,  G4,  E4,
	C5,  E5,  C5,  G4,  C5,  D5,  Bb4, G4,
	B3,  C4,  0,   A4,  0,   G4,  E4,  G4,  /*   10   */  
	D4,  E4,  0,   C5,  0,   B4,  G4,  C5, 
	F3,  G3,  0,   F4,  0,   D4,  C4,  E4,
	B3,  C4,  D4,  E4,  F4,  G4,  B4,  C5,  /*   11   */  
	D4,  E4,  F4,  G4,  A4,  B4,  D5,  E5,
	Gb4, G4,  A4,  B4,  C5,  D5,  F5,  G5, 
	D4,  C4,  D4,  E4,  D4,  C4,  D4,  E4,  /*   12   first */  
	F4,  E4,  F4,  G4,  F4,  E4,  F4,  G4,
	A4,  G4,  A4,  B4,  A4,  G4,  A4,  B4,
	D4,  C4,  D4,  E4,  D4,  E4,  D4,  C4,  /*   13   */  
	F4,  E4,  F4,  G4,  F4,  G4,  F4,  E4,
	A4,  G4,  A4,  B4,  A4,  B4,  A4,  G4, 
	D4,  C4,  D4,  E4,  F4,  E4,  F4,  G4,  /*   14   */  
	F4,  E4,  F4,  G4,  A4,  G4,  A4,  B4,
	A4,  G4,  A4,  B4,  C5,  B4,  C5,  D5, 
	D5,  E5,  C5,  G4,  B4,  D5,  C5,  0,   /*   15   */  
	F4,  G4,  E4,  B3,  D4,  F4,  E4,  0,  
	B4,  C5,  G4,  E4,  F4,  A4,  G4,  0,  
	E4,  B3,  C4,  B4,  Ab4, A4,  Gb4, G4,  /*   16   */  
	G4,  D4,  E4,  D5,  0,   C5,  0,   C5,
	B4,  F4,  G4,  G4,  E4,  F4,  Eb4, E4,  
	E4,  F4,  E4,  D4,  E4,  D4,  C4,  0,   /*   17   */  
	G4,  A4,  G4,  F4,  G4,  F4,  E4,  0,  
	C4,  0,   B3,  0,   C4,  0,   A3,  0,  
	E4,  F4,  G4,  E4,  F4,  G4,  A4,  F4,  /*   18   */  
	G4,  A4,  B4,  G4,  A4,  B4,  C5,  A4, 
	C4,  D4,  E4,  C4,  D4,  E4,  F4,  D4, 
	E5,  D5,  C5,  B4,  A4,  G4,  Gb4, F4,  /*   19   */  
	C5,  B4,  A4,  G4,  F4,  E4,  Eb4, D4, 
	E5,  F5,  E5,  D5,  C5,  B4,  Bb4, A4, 
	F4,  E4,  C4,  E4,  G4,  Gb4, F4,  E4,  /*   20   */  
	D4,  C4,  G3,  C4,  E4,  Eb4, D4,  C4, 
	A4,  G4,  E4,  G4,  C5,  B4,  A4,  G4, 
	F4,  E4,  F4,  G4,  F4,  E4,  F4,  G4,  /*   21   */  
	A4,  G4,  A4,  B4,  A4,  G4,  A4,  B4,
	C5,  C5,  C5,  D5,  C5,  C5,  C5,  D5, 
	F4,  G4,  Bb4, G4,  F4,  E4,  D4,  E4,  /*   22   */  
	D4,  E4,  G4,  E4,  D4,  C4,  B3,  C4, 
	A4,  B4,  D5,  B4,  A4,  G4,  F4,  G4, 
	F4,  G4,  A4,  G4,  E4,  0,   F4,  C5,  /*   23   */  
	D4,  E4,  F4,  E4,  C4,  0,   D4,  G4, 
	A4,  B4,  C5,  B4,  A4,  0,   B4,  E5,
	F4,  G4,  C5,  0,   F4,  E4,  C4,  G3,  /*   24   */  
	D4,  E4,  G4,  0,   D4,  C4,  A3,  E3,
	B4,  C5,  E4,  0,   A4,  G4,  E4,  C4, 
	G3,  F3,  C4,  A3,  G3,  E4,  C4,  C4,  /*   25   */  
	B3,  A3,  E4,  0,   C4,  G4,  Eb4, E4,
	E4,  D4,  G4,  0,   E4,  C5,  Gb4, G4, 
	Gb4, G4,  C5,  E4,  D4,  G4,  C4,  C4,  /*   26   */  
	D4,  E4,  A4,  C4,  B3,  D4,  G3,  G3, 
	B4,  C5,  E4,  A4,  G4,  F4,  E4,  E4,
	Gb4, G4,  F4,  E4,  D4,  C4,  B3,  C4,  /*   27   */  
	Eb4, E4,  D4,  C4,  B3,  A3,  F3,  G3,
	B4,  C5,  A4,  G4,  F4,  E4,  D4,  C4, 
	Gb4, F4,  Gb4, F4,  0,   E4,  C4,  0,   /*   28   */  
	Eb4, D4,  Eb4, D4,  0,   C4,  A3,  0,  
	C4,  0,   C4,  0,   0,   G4,  E4,  0,  
	Gb4, F4,  Gb4, A4,  Gb4, F4,  E4,  D4,  /*   29   */  
	Bb4, A4,  Bb4, C5,  Bb4, A4,  G4,  F4, 
	Eb4, D4,  Eb4, F4,  Eb4, D4,  C4,  B3, 
	G4,  C4,  E4,  B3,  D4,  B3,  A3,  G3,  /*   30   */  
	B4,  E4,  G4,  D4,  F4,  D4,  C4,  B3,
	E4,  G3,  C4,  G3,  B3,  G3,  F3,  E3,
	G4,  Gb4, F4,  E4,  D4,  E4,  F4,  A4,  /*   31   */  
	B4,  Bb4, A4,  G4,  F4,  G4,  A4,  C5, 
	E4,  Eb4, D4,  C4,  B3,  C4,  D4,  E4, 
	A3,  C4,  E4,  F4,  G3,  C4,  E4,  C4,  /*   32   */  
	C4,  E4,  G4,  A4,  B3,  E4,  G4,  E4,
	E3,  A3,  C4,  D4,  E3,  G3,  C4,  G3, 
	Bb4, G4,  F4,  D4,  A4,  0,   E4,  C4,  /*   33   */  
	D5,  Bb4, A4,  F4,  C5,  0,   G4,  E4,
	G4,  E4,  D4,  B3,  F4,  0,   C4,  G3, 
	Bb4, G4,  F4,  A4,  Eb4, 0,   C4,  0,   /*   34   */  
	D5,  Bb4, A4,  C5,  G4,  0,   E4,  0,  
	G4,  E4,  D4,  F4,  C4,  0,   G3,  0,  
	C4,  Db4, D4,  Eb4, E4,  F4,  Gb4, G4,  /*   35   */  
	E4,  F4,  Gb4, G4,  Ab4, A4,  Bb4, B4,
	C4,  0,   B3,  0,   C4,  0,   D4,  0,
	F4,  Gb4, G4,  Ab4, A4,  Bb4, B4,  C5,  /*   36   */  
	A4,  Bb4, B4,  C5,  Db5, D5,  Eb5, E5,
	C4,  Db4, D4,  Eb4, E4,  F4,  Gb4, G4, 
	C5,  G4,  E4,  C4,  E4,  G4,  C5,  C5,  /*   37   */  
	B4,  Gb4, Eb4, B3,  Eb4, Gb4, B4,  E5,
	E5,  C5,  G4,  E4,  G4,  C5,  E5,  G5, 
	D5,  F5,  E5,  G4,  B4,  D5,  C5,  E4,  /*   38   */  
	B4,  D5,  C5,  E4,  G4,  B4,  A4,  C4, 
	G4,  B4,  A4,  C4,  D4,  F4,  E4,  G3, 
	F4,  A4,  G4,  C4,  D4,  F4,  E4,  G3,  /*   39   */  
	D4,  F4,  E4,  G3,  B3,  D4,  C4,  E3,
	B3,  D4,  C4,  E3,  G3,  A3,  G3,  C3, 
	B4,  C5,  B4,  C5,  B4,  C5,  B4,  C5,  /*   40   */  
	Gb4, G4,  Gb4, G4,  Gb4, G4,  Gb4, G4, 
	Eb4, E4,  Eb4, E4,  Eb4, E4,  Eb4, E4,
};

int	Nmajriffs	= (sizeof Majriffs / 24);

