/*
**	RETRO -- Play a melody backwards (retrograde)
**	psl 4/89
*/
#include	<stdio.h>
#include	<midi.h>

#define	MAXCHAN	16
#define	MAXKEY	128

#define	MAXS	4096
MCMD	Stack[MAXS], *Sp = Stack;
u_char	Sbuf[MAXS * 4], *Bp = Sbuf;

main(argc, argv)
char	*argv[];
{
	register u_char *cp;
	register MCMD *mp;
	int stat, vel[MAXCHAN][MAXKEY];
	long now;

	while (--argc > 0) {
	    if (argv[argc][0] == '-') {
		switch (argv[argc][1]) {
		default:
		    goto syntax;
		}
	    } else {
syntax:
		fprintf(stderr, "Usage: %s <forward >backward\n", argv[0]);
		exit(2);
	    }
	}
	/* read in all MIDI events & push on stack, swapping key-on & key-off */
	for (now = 0L; mp = getmcmd(stdin, now); now = mp->when) {
	    *Sp = *mp;
	    Sp->cmd = Bp;
	    for (cp = mp->cmd; --mp->len >= 0; *Bp++ = *cp++);
	    stat = (Sp->cmd[0] & M_CMD_MASK);
	    if (stat == CH_KEY_OFF) {
		Sp->cmd[0] ^= (CH_KEY_ON ^ CH_KEY_OFF);
		Sp->cmd[2] = 0;
		stat = CH_KEY_ON;
	    }
	    if (stat == CH_KEY_ON) {
		if (Sp->cmd[2]) {			/* key on */
		    vel[Sp->cmd[0] & M_CHAN_MASK][Sp->cmd[1]] = Sp->cmd[2];
		    Sp->cmd[2] = 0;
		} else {				/* key off */
		    Sp->cmd[2] = vel[Sp->cmd[0] & M_CHAN_MASK][Sp->cmd[1]];
		}
	    }
	    Sp++;
	}
	/* pop MIDI events and output */
	while (--Sp >= Stack) {
	    Sp->when = now - Sp->when;
	    putmcmd(stdout, Sp);
	}
	exit(0);
}
